/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KeystorePasswordPolicy {
    private static final Logger logger = LogManager.getLogger(KeystorePasswordPolicy.class);
    private static final int MIN_LENGTH = 12;

    private KeystorePasswordPolicy() {
    }

    public static void warnIfNonCompliant(@NonNull String configKey, @NonNull String password) {
        Objects.requireNonNull(configKey, "configKey must not be null");
        Objects.requireNonNull(password, "password must not be null");
        List<String> issues = KeystorePasswordPolicy.issues(password);
        if (issues.isEmpty()) {
            return;
        }
        logger.warn("Configured {} does not meet recommended password policy ({}). This is not enforced, but weak keystore passwords increase risk of offline brute-force attacks.", (Object)configKey, (Object)String.join((CharSequence)", ", issues));
    }

    @NonNull
    private static List<String> issues(@NonNull String password) {
        ArrayList<String> issues = new ArrayList<String>();
        if (password.length() < 12) {
            issues.add("minLength>=12");
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        boolean hasDigit = false;
        boolean hasSpecial = false;
        for (int i = 0; i < password.length(); ++i) {
            char characterAt = password.charAt(i);
            if (Character.isUpperCase(characterAt)) {
                hasUpper = true;
                continue;
            }
            if (Character.isLowerCase(characterAt)) {
                hasLower = true;
                continue;
            }
            if (Character.isDigit(characterAt)) {
                hasDigit = true;
                continue;
            }
            hasSpecial = true;
        }
        if (!hasUpper) {
            issues.add("uppercase");
        }
        if (!hasLower) {
            issues.add("lowercase");
        }
        if (!hasDigit) {
            issues.add("digit");
        }
        if (!hasSpecial) {
            issues.add("special");
        }
        return issues;
    }
}

