/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.standalone;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.node.app.config.BootstrapConfigProviderImpl;
import com.hedera.node.app.config.ConfigProviderImpl;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.hints.impl.HintsLibraryImpl;
import com.hedera.node.app.hints.impl.HintsServiceImpl;
import com.hedera.node.app.history.impl.HistoryLibraryImpl;
import com.hedera.node.app.history.impl.HistoryServiceImpl;
import com.hedera.node.app.info.NodeInfoImpl;
import com.hedera.node.app.records.impl.producers.formats.SelfNodeAccountIdManagerImpl;
import com.hedera.node.app.service.addressbook.impl.AddressBookServiceImpl;
import com.hedera.node.app.service.consensus.impl.ConsensusServiceImpl;
import com.hedera.node.app.service.contract.impl.ContractServiceImpl;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategies;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.file.impl.FileServiceImpl;
import com.hedera.node.app.service.networkadmin.impl.NetworkServiceImpl;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceImpl;
import com.hedera.node.app.service.token.impl.TokenServiceImpl;
import com.hedera.node.app.service.util.impl.UtilServiceImpl;
import com.hedera.node.app.services.AppContextImpl;
import com.hedera.node.app.signature.AppSignatureVerifier;
import com.hedera.node.app.signature.impl.SignatureExpanderImpl;
import com.hedera.node.app.signature.impl.SignatureVerifierImpl;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.records.RecordSource;
import com.hedera.node.app.state.recordcache.LegacyListRecordSource;
import com.hedera.node.app.throttle.AppScheduleThrottleFactory;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.standalone.DaggerExecutorComponent;
import com.hedera.node.app.workflows.standalone.ExecutorComponent;
import com.hedera.node.app.workflows.standalone.TransactionExecutor;
import com.hedera.node.app.workflows.standalone.impl.NoopVerificationStrategies;
import com.hedera.node.app.workflows.standalone.impl.StandaloneNetworkInfo;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.types.StreamMode;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.InstantSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hiero.consensus.metrics.noop.NoOpMetrics;
import org.hyperledger.besu.evm.operation.Operation;

public enum TransactionExecutors {
    TRANSACTION_EXECUTORS;

    @Deprecated(since="0.61")
    public static final String MAX_SIGNED_TXN_SIZE_PROPERTY = "executor.maxSignedTxnSize";
    public static final String DISABLE_THROTTLES_PROPERTY = "executor.disableThrottles";
    private static final Metrics NO_OP_METRICS;

    public TransactionExecutor newExecutor(@NonNull Properties properties, @NonNull EntityIdFactory entityIdFactory) {
        Objects.requireNonNull(properties);
        return this.newExecutor(properties.state(), properties.appProperties(), properties.customTracerBinding(), properties.customOps(), entityIdFactory);
    }

    private TransactionExecutor newExecutor(@NonNull State state, @NonNull Map<String, String> properties, @Nullable TracerBinding customTracerBinding, @NonNull Set<Operation> customOps, @NonNull EntityIdFactory entityIdFactory) {
        TracerBinding tracerBinding = customTracerBinding != null ? customTracerBinding : DefaultTracerBinding.DEFAULT_TRACER_BINDING;
        ExecutorComponent executor = this.newExecutorComponent(state, properties, tracerBinding, customOps, entityIdFactory);
        executor.stateNetworkInfo().initFrom(state);
        executor.initializer().initialize(state, StreamMode.BOTH);
        ExchangeRateManager exchangeRateManager = executor.exchangeRateManager();
        return (transactionBody, consensusNow, tracers) -> {
            Dispatch dispatch = executor.standaloneDispatchFactory().newDispatch(state, transactionBody, consensusNow);
            tracerBinding.runWhere(List.of(tracers), () -> executor.dispatchProcessor().processDispatch(dispatch));
            RecordSource recordSource = dispatch.stack().buildHandleOutput(consensusNow, exchangeRateManager.exchangeRates()).recordSourceOrThrow();
            return ((LegacyListRecordSource)recordSource).precomputedRecords();
        };
    }

    public ExecutorComponent newExecutorComponent(@NonNull State state, @NonNull Map<String, String> properties, @NonNull TracerBinding tracerBinding, @NonNull Set<Operation> customOps, @NonNull EntityIdFactory entityIdFactory) {
        if (properties.containsKey(MAX_SIGNED_TXN_SIZE_PROPERTY)) {
            properties = properties.entrySet().stream().map(e -> MAX_SIGNED_TXN_SIZE_PROPERTY.equals(e.getKey()) ? Map.entry("hedera.nodeTransaction.maxBytes", (String)e.getValue()) : e).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        BootstrapConfigProviderImpl bootstrapConfigProvider = new BootstrapConfigProviderImpl(properties);
        VersionedConfiguration bootstrapConfig = bootstrapConfigProvider.getConfiguration();
        ConfigProviderImpl configProvider = new ConfigProviderImpl(false, null, properties);
        AtomicReference<ExecutorComponent> componentRef = new AtomicReference<ExecutorComponent>();
        NodeInfoImpl defaultNodeInfo = new NodeInfoImpl(0L, entityIdFactory.newAccountId(3L), 10L, List.of(), Bytes.EMPTY, List.of(), false, null);
        Boolean disableThrottles = Optional.ofNullable(properties.get(DISABLE_THROTTLES_PROPERTY)).map(Boolean::parseBoolean).orElse(false);
        AppContextImpl appContext = new AppContextImpl(InstantSource.system(), new AppSignatureVerifier((HederaConfig)bootstrapConfig.getConfigData(HederaConfig.class), new SignatureExpanderImpl(), new SignatureVerifierImpl()), AppContext.Gossip.UNAVAILABLE_GOSSIP, bootstrapConfigProvider::getConfiguration, () -> defaultNodeInfo, () -> NO_OP_METRICS, new AppScheduleThrottleFactory(configProvider::getConfiguration, () -> state, () -> ((ExecutorComponent)componentRef.get()).throttleServiceManager().activeThrottleDefinitionsOrThrow(), (configSupplier, capacitySplitSource, throttleType) -> disableThrottles != false ? new ThrottleAccumulator(configSupplier, capacitySplitSource, ThrottleAccumulator.ThrottleType.NOOP_THROTTLE) : new ThrottleAccumulator(configSupplier, capacitySplitSource, throttleType)), () -> ((ExecutorComponent)componentRef.get()).appFeeCharging(), entityIdFactory);
        ContractServiceImpl contractService = new ContractServiceImpl((AppContext)appContext, NO_OP_METRICS, (VerificationStrategies)NoopVerificationStrategies.NOOP_VERIFICATION_STRATEGIES, (Supplier)tracerBinding, customOps);
        UtilServiceImpl utilService = new UtilServiceImpl((AppContext)appContext, (signedTxn, config) -> ((ExecutorComponent)componentRef.get()).transactionChecker().parseSignedAndCheck(signedTxn, ((HederaConfig)config.getConfigData(HederaConfig.class)).nodeTransactionMaxBytes()).txBody());
        FileServiceImpl fileService = new FileServiceImpl();
        ScheduleServiceImpl scheduleService = new ScheduleServiceImpl((AppContext)appContext);
        HintsServiceImpl hintsService = new HintsServiceImpl(NO_OP_METRICS, ForkJoinPool.commonPool(), appContext, new HintsLibraryImpl(), ((BlockStreamConfig)bootstrapConfig.getConfigData(BlockStreamConfig.class)).blockPeriod());
        HistoryServiceImpl historyService = new HistoryServiceImpl(NO_OP_METRICS, ForkJoinPool.commonPool(), appContext, new HistoryLibraryImpl());
        StandaloneNetworkInfo standaloneNetworkInfo = new StandaloneNetworkInfo(configProvider);
        standaloneNetworkInfo.initFrom(state);
        ExecutorComponent component = DaggerExecutorComponent.builder().appContext(appContext).configProviderImpl(configProvider).disableThrottles(disableThrottles).bootstrapConfigProviderImpl(bootstrapConfigProvider).fileServiceImpl(fileService).tokenServiceImpl(new TokenServiceImpl((AppContext)appContext)).consensusServiceImpl(new ConsensusServiceImpl()).networkServiceImpl(new NetworkServiceImpl()).contractServiceImpl(contractService).utilServiceImpl(utilService).scheduleServiceImpl(scheduleService).hintsService(hintsService).historyService(historyService).addressBookService(new AddressBookServiceImpl()).metrics(NO_OP_METRICS).throttleFactory(appContext.throttleFactory()).selfNodeAccountIdManager(new SelfNodeAccountIdManagerImpl(configProvider, standaloneNetworkInfo, state)).build();
        componentRef.set(component);
        return component;
    }

    static {
        NO_OP_METRICS = new NoOpMetrics();
    }

    public record Properties(@NonNull State state, @NonNull Map<String, String> appProperties, @Nullable TracerBinding customTracerBinding, @NonNull Set<Operation> customOps, @NonNull SemanticVersion softwareVersionFactory) {
        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private State state;
            private TracerBinding customTracerBinding;
            private final Map<String, String> appProperties = new HashMap<String, String>();
            private final Set<Operation> customOps = new HashSet<Operation>();
            private SemanticVersion softwareVersionFactory;

            public Builder state(@NonNull State state) {
                this.state = Objects.requireNonNull(state);
                return this;
            }

            public Builder appProperty(@NonNull String key, @NonNull String value) {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                this.appProperties.put(key, value);
                return this;
            }

            public Builder appProperties(@NonNull Map<String, String> properties) {
                Objects.requireNonNull(properties);
                this.appProperties.putAll(properties);
                return this;
            }

            public Builder customTracerBinding(@Nullable TracerBinding customTracerBinding) {
                this.customTracerBinding = customTracerBinding;
                return this;
            }

            public Builder customOps(@NonNull Set<? extends Operation> customOps) {
                Objects.requireNonNull(customOps);
                this.customOps.addAll(customOps);
                return this;
            }

            public Builder addCustomOp(@NonNull Operation customOp) {
                Objects.requireNonNull(customOp);
                this.customOps.add(customOp);
                return this;
            }

            public Builder softwareVersionFactory(@NonNull SemanticVersion softwareVersionFactory) {
                this.softwareVersionFactory = Objects.requireNonNull(softwareVersionFactory);
                return this;
            }

            public Properties build() {
                if (this.state == null) {
                    throw new IllegalStateException("State must not be null");
                }
                return new Properties(this.state, Map.copyOf(this.appProperties), this.customTracerBinding, Set.copyOf(this.customOps), this.softwareVersionFactory);
            }
        }
    }

    public static interface TracerBinding
    extends Supplier<List<ActionSidecarContentTracer>> {
        public void runWhere(@NonNull List<ActionSidecarContentTracer> var1, @NonNull Runnable var2);
    }

    private static enum DefaultTracerBinding implements TracerBinding
    {
        DEFAULT_TRACER_BINDING;

        private static final ThreadLocal<List<ActionSidecarContentTracer>> TRACERS;

        @Override
        public void runWhere(@NonNull List<ActionSidecarContentTracer> tracers, @NonNull Runnable runnable) {
            TRACERS.set(tracers);
            runnable.run();
        }

        @Override
        public List<ActionSidecarContentTracer> get() {
            return TRACERS.get();
        }

        static {
            TRACERS = ThreadLocal.withInitial(List::of);
        }
    }
}

