/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.communication.states;

import java.io.IOException;
import java.io.OutputStream;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationProtocols;
import org.hiero.consensus.gossip.impl.network.communication.states.NegotiationState;
import org.hiero.consensus.gossip.impl.network.communication.states.NegotiationStateWithDescription;
import org.hiero.consensus.gossip.impl.network.communication.states.SentInitiate;
import org.hiero.consensus.gossip.impl.network.communication.states.SentKeepalive;

public class InitialState
extends NegotiationStateWithDescription {
    private final NegotiationProtocols protocols;
    private final OutputStream byteOutput;
    private final SentKeepalive stateSentKeepalive;
    private final SentInitiate stateSentInitiate;

    public InitialState(NegotiationProtocols protocols, OutputStream byteOutput, SentKeepalive stateSentKeepalive, SentInitiate stateSentInitiate) {
        this.protocols = protocols;
        this.byteOutput = byteOutput;
        this.stateSentKeepalive = stateSentKeepalive;
        this.stateSentInitiate = stateSentInitiate;
    }

    @Override
    public NegotiationState transition() throws IOException {
        byte protocolByte = this.protocols.initiateProtocol();
        if (protocolByte >= 0) {
            this.byteOutput.write(protocolByte);
            this.byteOutput.flush();
            this.setDescription("initiated protocol " + this.protocols.getInitiatedProtocol().getProtocolName());
            return this.stateSentInitiate.initiatedProtocol(protocolByte);
        }
        this.byteOutput.write(255);
        this.byteOutput.flush();
        this.setDescription("sent keepalive");
        return this.stateSentKeepalive;
    }
}

