/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.converter;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.converter.ConfigConverter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.base.utility.CommonUtils;

public class BytesConverter
implements ConfigConverter<Bytes> {
    @Nullable
    public Bytes convert(@NonNull String value) throws IllegalArgumentException, NullPointerException {
        if (value == null) {
            throw new NullPointerException("BytesConverter cannot convert null value");
        }
        try {
            String hex = value.startsWith("0x") ? value.substring(2) : value;
            byte[] bytes = CommonUtils.unhex((String)hex);
            return Bytes.wrap((byte[])bytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid format: " + value, e);
        }
    }
}

