/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.internal;

import com.swirlds.base.state.Startable;
import com.swirlds.base.state.Stoppable;
import com.swirlds.component.framework.counters.ObjectCounter;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.schedulers.internal.SequentialThreadTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import org.hiero.consensus.metrics.extensions.FractionalTimer;

public class SequentialThreadTaskScheduler<OUT>
extends TaskScheduler<OUT>
implements Startable,
Stoppable {
    private static final SequentialThreadTask POISON_PILL = new SequentialThreadTask(o -> {}, new Object());
    public static final String THREAD_NAME_PREFIX = "<scheduler ";
    public static final String THREAD_NAME_SUFFIX = ">";
    private final ObjectCounter onRamp;
    private final ObjectCounter offRamp;
    private final ToLongFunction<Object> dataCounter;
    private final FractionalTimer busyTimer;
    private final long capacity;
    private final BlockingQueue<SequentialThreadTask> tasks = new LinkedBlockingQueue<SequentialThreadTask>();
    private static final int BUFFER_SIZE = 1024;
    private volatile boolean alive = true;
    private final Thread thread;

    public SequentialThreadTaskScheduler(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp, @NonNull ToLongFunction<Object> dataCounter, @NonNull FractionalTimer busyTimer, long capacity, boolean flushEnabled, boolean squelchingEnabled, boolean insertionIsBlocking) {
        super(model, name, TaskSchedulerType.SEQUENTIAL_THREAD, uncaughtExceptionHandler, flushEnabled, squelchingEnabled, insertionIsBlocking);
        this.onRamp = Objects.requireNonNull(onRamp);
        this.offRamp = Objects.requireNonNull(offRamp);
        this.dataCounter = dataCounter;
        this.busyTimer = Objects.requireNonNull(busyTimer);
        this.capacity = capacity;
        this.thread = new Thread(this::run, THREAD_NAME_PREFIX + name + THREAD_NAME_SUFFIX);
    }

    @Override
    public long getUnprocessedTaskCount() {
        return this.onRamp.getCount();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void flush() {
        this.throwIfFlushDisabled();
        this.onRamp.waitUntilEmpty();
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.onRamp(this.dataCounter.applyAsLong(data));
        this.tasks.add(new SequentialThreadTask(handler, data));
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        boolean accepted = this.onRamp.attemptOnRamp(this.dataCounter.applyAsLong(data));
        if (!accepted) {
            return false;
        }
        this.tasks.add(new SequentialThreadTask(handler, data));
        return true;
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.forceOnRamp(this.dataCounter.applyAsLong(data));
        this.tasks.add(new SequentialThreadTask(handler, data));
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.alive = false;
        this.tasks.add(POISON_PILL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        ArrayList<SequentialThreadTask> buffer = new ArrayList<SequentialThreadTask>(1024);
        while (this.alive) {
            if (this.tasks.drainTo(buffer, 1024) == 0) {
                try {
                    SequentialThreadTask task = this.tasks.take();
                    buffer.add(task);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            this.busyTimer.activate();
            for (SequentialThreadTask task : buffer) {
                if (!this.alive) break;
                try {
                    task.handle();
                }
                catch (Throwable t) {
                    this.getUncaughtExceptionHandler().uncaughtException(this.thread, t);
                }
                finally {
                    this.offRamp.offRamp(this.dataCounter.applyAsLong(task.data()));
                }
            }
            this.busyTimer.deactivate();
            buffer.clear();
        }
    }
}

