/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.core;

import com.google.protobuf.MessageLite;
import io.grpc.MethodDescriptor;
import io.helidon.grpc.core.MarshallerSupplier;
import io.helidon.grpc.core.ProtoMarshallerSupplier;

class DefaultMarshallerSupplier
implements MarshallerSupplier {
    private final ProtoMarshallerSupplier proto = ProtoMarshallerSupplier.create();

    private DefaultMarshallerSupplier() {
    }

    static DefaultMarshallerSupplier create() {
        return new DefaultMarshallerSupplier();
    }

    @Override
    public <T> MethodDescriptor.Marshaller<T> get(Class<T> clazz) {
        if (MessageLite.class.isAssignableFrom(clazz)) {
            return this.proto.get(clazz);
        }
        String msg = String.format("Class %s must be a valid ProtoBuf message, or a custom marshaller for it must be specified explicitly", clazz.getName());
        throw new IllegalArgumentException(msg);
    }
}

