/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.merkledb.files.DataFileCommon;
import com.swirlds.merkledb.files.DataFileMetadata;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.function.Consumer;
import org.hiero.base.utility.MemoryUtils;

public final class DataFileWriter {
    private static final int DEFAULT_BUF_SIZE = 0x4000000;
    private static final String ERROR_DATA_ITEM_TOO_LARGE = "Data item is too large to write to a data file. Increase data file mapped byte buffer size";
    private MappedByteBuffer mappedDataBuffer;
    private long bufferPositionInFile;
    private BufferedData dataBuffer;
    private final Path path;
    private final FileChannel fileChannel;
    private final DataFileMetadata metadata;
    private final long dataBufferSize;
    private boolean closed = false;

    public DataFileWriter(String filePrefix, Path dataFileDir, int index, Instant creationTime, int compactionLevel) throws IOException {
        this(filePrefix, dataFileDir, index, creationTime, compactionLevel, 0x4000000L);
    }

    public DataFileWriter(String filePrefix, Path dataFileDir, int index, Instant creationTime, int compactionLevel, long dataBufferSize) throws IOException {
        this.dataBufferSize = dataBufferSize;
        this.path = DataFileCommon.createDataFilePath(filePrefix, dataFileDir, index, creationTime, ".pbj");
        Files.createFile(this.path, new FileAttribute[0]);
        this.fileChannel = FileChannel.open(this.path, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.metadata = new DataFileMetadata(index, creationTime, compactionLevel);
        this.bufferPositionInFile = this.writeHeader();
        this.moveWritingBuffer(this.bufferPositionInFile);
    }

    private void moveWritingBuffer(long startPosition) throws IOException {
        MappedByteBuffer newBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, startPosition, this.dataBufferSize);
        if (this.mappedDataBuffer != null) {
            MemoryUtils.closeMmapBuffer((MappedByteBuffer)this.mappedDataBuffer);
        }
        this.bufferPositionInFile = startPosition;
        this.mappedDataBuffer = newBuffer;
        this.dataBuffer = BufferedData.wrap((ByteBuffer)this.mappedDataBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeHeader() throws IOException {
        MappedByteBuffer headerMappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 1024L);
        BufferedData headerBuffer = BufferedData.wrap((ByteBuffer)headerMappedBuffer);
        try {
            this.metadata.writeTo(headerBuffer);
            long l = headerBuffer.position();
            return l;
        }
        finally {
            MemoryUtils.closeMmapBuffer((MappedByteBuffer)headerMappedBuffer);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public DataFileMetadata getMetadata() {
        return this.metadata;
    }

    public long storeDataItem(BufferedData dataItem) throws IOException {
        return this.storeDataItem(o -> o.writeBytes(dataItem), Math.toIntExact(dataItem.remaining()));
    }

    public long storeDataItem(Consumer<BufferedData> dataItemWriter, int dataItemSize) throws IOException {
        if (this.closed) {
            throw new IOException("Data file is already closed");
        }
        long fileOffset = this.getCurrentFilePosition();
        int sizeToWrite = ProtoWriterTools.sizeOfDelimited((FieldDefinition)DataFileCommon.FIELD_DATAFILE_ITEMS, (int)dataItemSize);
        if ((long)sizeToWrite > this.dataBufferSize) {
            throw new IOException("Data item is too large to write to a data file. Increase data file mapped byte buffer size dataSize=" + sizeToWrite + ", bufferSize=" + this.dataBufferSize);
        }
        if (this.dataBuffer.remaining() < (long)sizeToWrite) {
            this.moveWritingBuffer(fileOffset);
        }
        ProtoWriterTools.writeDelimited((WritableSequentialData)this.dataBuffer, (FieldDefinition)DataFileCommon.FIELD_DATAFILE_ITEMS, (int)dataItemSize, dataItemWriter);
        if (this.getCurrentFilePosition() != fileOffset + (long)sizeToWrite) {
            throw new IOException("Estimated size / written bytes mismatch: expected=" + sizeToWrite + " written=" + (this.getCurrentFilePosition() - fileOffset));
        }
        return DataFileCommon.dataLocation(this.metadata.getIndex(), fileOffset);
    }

    public long storeDataItemWithTag(BufferedData dataItemWithTag) throws IOException {
        if (this.closed) {
            throw new IOException("Data file is already closed");
        }
        long fileOffset = this.getCurrentFilePosition();
        int sizeToWrite = Math.toIntExact(dataItemWithTag.remaining());
        if ((long)sizeToWrite > this.dataBufferSize) {
            throw new IOException("Data item is too large to write to a data file. Increase data file mapped byte buffer size dataSize=" + sizeToWrite + ", bufferSize=" + this.dataBufferSize);
        }
        if (this.dataBuffer.remaining() < (long)sizeToWrite) {
            this.moveWritingBuffer(fileOffset);
        }
        this.dataBuffer.writeBytes(dataItemWithTag);
        if (this.getCurrentFilePosition() != fileOffset + (long)sizeToWrite) {
            throw new IOException("Estimated size / written bytes mismatch: expected=" + sizeToWrite + " written=" + (this.getCurrentFilePosition() - fileOffset));
        }
        return DataFileCommon.dataLocation(this.metadata.getIndex(), fileOffset);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        long totalFileSize = this.bufferPositionInFile + this.dataBuffer.position();
        MemoryUtils.closeMmapBuffer((MappedByteBuffer)this.mappedDataBuffer);
        this.fileChannel.truncate(totalFileSize);
        this.bufferPositionInFile = totalFileSize;
        this.fileChannel.close();
    }

    private long getCurrentFilePosition() {
        return this.bufferPositionInFile + this.dataBuffer.position();
    }
}

