/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class ActiveContractVerificationStrategy
implements VerificationStrategy {
    private final ContractID activeContractID;
    private final Bytes activeAddress;
    private final boolean requiresDelegatePermission;
    private final UseTopLevelSigs useTopLevelSigs;

    public ActiveContractVerificationStrategy(ContractID activeContractID, @NonNull Bytes activeAddress, boolean requiresDelegatePermission, @NonNull UseTopLevelSigs useTopLevelSigs) {
        this.activeContractID = activeContractID;
        this.useTopLevelSigs = Objects.requireNonNull(useTopLevelSigs);
        this.activeAddress = Objects.requireNonNull(activeAddress);
        this.requiresDelegatePermission = requiresDelegatePermission;
    }

    @Override
    public VerificationStrategy.Decision decideForPrimitive(@NonNull Key key) {
        Key.KeyOneOfType keyKind = (Key.KeyOneOfType)key.key().kind();
        if (keyKind == Key.KeyOneOfType.CONTRACT_ID) {
            if (this.requiresDelegatePermission) {
                return VerificationStrategy.Decision.INVALID;
            }
            return this.decisionFor(key.contractIDOrThrow());
        }
        if (keyKind == Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID) {
            return this.decisionFor(key.delegatableContractIdOrThrow());
        }
        return this.useTopLevelSigs == UseTopLevelSigs.YES ? VerificationStrategy.Decision.DELEGATE_TO_CRYPTOGRAPHIC_VERIFICATION : VerificationStrategy.Decision.INVALID;
    }

    public ContractID getActiveContractID() {
        return this.activeContractID;
    }

    public Bytes getActiveAddress() {
        return this.activeAddress;
    }

    public boolean requiresDelegatePermission() {
        return this.requiresDelegatePermission;
    }

    private VerificationStrategy.Decision decisionFor(@NonNull ContractID authorizedId) {
        if (authorizedId.hasContractNum() && this.activeContractID.hasContractNum() && authorizedId.contractNumOrThrow().equals(this.activeContractID.contractNumOrThrow())) {
            return VerificationStrategy.Decision.VALID;
        }
        if (authorizedId.hasEvmAddress() && this.activeAddress.equals((Object)authorizedId.evmAddress())) {
            return VerificationStrategy.Decision.VALID;
        }
        return VerificationStrategy.Decision.INVALID;
    }

    public static enum UseTopLevelSigs {
        YES,
        NO;

    }
}

