/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import java.util.List;

public enum TokenKeyValidation implements EnumWithProtoMetadata
{
    FULL_VALIDATION(0, "FULL_VALIDATION"),
    NO_VALIDATION(1, "NO_VALIDATION"),
    UNRECOGNIZED(-1, "UNRECOGNIZED");

    private final int protoOrdinal;
    private final String protoName;

    private TokenKeyValidation(int protoOrdinal, String protoName) {
        this.protoOrdinal = protoOrdinal;
        this.protoName = protoName;
    }

    public int protoOrdinal() {
        return this.protoOrdinal;
    }

    public String protoName() {
        return this.protoName;
    }

    public static TokenKeyValidation fromProtobufOrdinal(int ordinal) {
        return switch (ordinal) {
            case 0 -> FULL_VALIDATION;
            case 1 -> NO_VALIDATION;
            default -> UNRECOGNIZED;
        };
    }

    public static TokenKeyValidation fromString(String name) {
        return switch (name) {
            case "FULL_VALIDATION" -> FULL_VALIDATION;
            case "NO_VALIDATION" -> NO_VALIDATION;
            default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
        };
    }

    public static TokenKeyValidation fromObject(Object obj) {
        if (obj == null) {
            return TokenKeyValidation.fromProtobufOrdinal(0);
        }
        if (obj instanceof TokenKeyValidation) {
            TokenKeyValidation pbjEnum = (TokenKeyValidation)((Object)obj);
            return pbjEnum;
        }
        return UNRECOGNIZED;
    }

    public static List<TokenKeyValidation> fromObjects(List<?> list) {
        return list.stream().map(TokenKeyValidation::fromObject).toList();
    }

    public static int toProtoOrdinal(Object obj) {
        if (obj instanceof TokenKeyValidation) {
            TokenKeyValidation pbjEnum = (TokenKeyValidation)((Object)obj);
            return pbjEnum.protoOrdinal();
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        throw new IllegalArgumentException("Neither TokenKeyValidation, nor Integer, but: " + obj.getClass().getName());
    }

    public static List<Integer> toProtoOrdinals(List<?> list) {
        return list.stream().map(TokenKeyValidation::toProtoOrdinal).toList();
    }

    public static int compare(Object o1, Object o2) {
        int i2;
        int i1;
        if (o1 instanceof TokenKeyValidation) {
            TokenKeyValidation e1 = (TokenKeyValidation)((Object)o1);
            if (o2 instanceof TokenKeyValidation) {
                TokenKeyValidation e2 = (TokenKeyValidation)((Object)o2);
                return e1.compareTo(e2);
            }
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof TokenKeyValidation) {
            TokenKeyValidation e1 = (TokenKeyValidation)((Object)o1);
            i1 = e1.protoOrdinal();
        } else if (o1 instanceof Integer) {
            Integer ii1 = (Integer)o1;
            i1 = ii1;
        } else {
            throw new IllegalArgumentException("o1 is neither TokenKeyValidation, nor Integer. It's: " + o1.getClass().getName());
        }
        if (o2 instanceof TokenKeyValidation) {
            TokenKeyValidation e2 = (TokenKeyValidation)((Object)o2);
            i2 = e2.protoOrdinal();
        } else if (o2 instanceof Integer) {
            Integer ii2 = (Integer)o2;
            i2 = ii2;
        } else {
            throw new IllegalArgumentException("o2 is neither TokenKeyValidation, nor Integer. It's: " + o2.getClass().getName());
        }
        return Integer.compare(i1, i2);
    }
}

