/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.hapi.node.state.token.codec.AccountJsonCodec;
import com.hedera.hapi.node.state.token.codec.AccountProtoCodec;
import com.hedera.hapi.node.state.token.schema.AccountSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class Account {
    public static final Codec<Account> PROTOBUF = new AccountProtoCodec();
    public static final JsonCodec<Account> JSON = new AccountJsonCodec();
    public static final Account DEFAULT = Account.newBuilder().build();
    @Nullable
    private final AccountID accountId;
    @NonNull
    private final Bytes alias;
    @Nullable
    private final Key key;
    private final long expirationSecond;
    private final long tinybarBalance;
    @NonNull
    private final String memo;
    private final boolean deleted;
    private final long stakedToMe;
    private final long stakePeriodStart;
    private final OneOf<StakedIdOneOfType> stakedId;
    private final boolean declineReward;
    private final boolean receiverSigRequired;
    @Nullable
    private final TokenID headTokenId;
    @Nullable
    private final NftID headNftId;
    private final long headNftSerialNumber;
    private final long numberOwnedNfts;
    private final int maxAutoAssociations;
    private final int usedAutoAssociations;
    private final int numberAssociations;
    private final boolean smartContract;
    private final int numberPositiveBalances;
    private final long ethereumNonce;
    private final long stakeAtStartOfLastRewardedPeriod;
    @Nullable
    private final AccountID autoRenewAccountId;
    private final long autoRenewSeconds;
    private final int contractKvPairsNumber;
    @NonNull
    private final List<AccountCryptoAllowance> cryptoAllowances;
    @NonNull
    private final List<AccountApprovalForAllAllowance> approveForAllNftAllowances;
    @NonNull
    private final List<AccountFungibleTokenAllowance> tokenAllowances;
    private final int numberTreasuryTitles;
    private final boolean expiredAndPendingRemoval;
    @NonNull
    private final Bytes firstContractStorageKey;
    @Nullable
    private final PendingAirdropId headPendingAirdropId;
    private final long numberPendingAirdrops;
    private final long numberHooksInUse;
    private final long firstHookId;
    private final long numberEvmHookStorageSlots;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public Account(AccountID accountId, Bytes alias, Key key, long expirationSecond, long tinybarBalance, String memo, boolean deleted, long stakedToMe, long stakePeriodStart, OneOf<StakedIdOneOfType> stakedId, boolean declineReward, boolean receiverSigRequired, TokenID headTokenId, NftID headNftId, long headNftSerialNumber, long numberOwnedNfts, int maxAutoAssociations, int usedAutoAssociations, int numberAssociations, boolean smartContract, int numberPositiveBalances, long ethereumNonce, long stakeAtStartOfLastRewardedPeriod, AccountID autoRenewAccountId, long autoRenewSeconds, int contractKvPairsNumber, List<AccountCryptoAllowance> cryptoAllowances, List<AccountApprovalForAllAllowance> approveForAllNftAllowances, List<AccountFungibleTokenAllowance> tokenAllowances, int numberTreasuryTitles, boolean expiredAndPendingRemoval, Bytes firstContractStorageKey, PendingAirdropId headPendingAirdropId, long numberPendingAirdrops, long numberHooksInUse, long firstHookId, long numberEvmHookStorageSlots) {
        this.$unknownFields = null;
        this.accountId = accountId;
        this.alias = alias != null ? alias : Bytes.EMPTY;
        this.key = key;
        this.expirationSecond = expirationSecond;
        this.tinybarBalance = tinybarBalance;
        this.memo = memo != null ? memo : "";
        this.deleted = deleted;
        this.stakedToMe = stakedToMe;
        this.stakePeriodStart = stakePeriodStart;
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
        this.stakedId = stakedId;
        this.declineReward = declineReward;
        this.receiverSigRequired = receiverSigRequired;
        this.headTokenId = headTokenId;
        this.headNftId = headNftId;
        this.headNftSerialNumber = headNftSerialNumber;
        this.numberOwnedNfts = numberOwnedNfts;
        this.maxAutoAssociations = maxAutoAssociations;
        this.usedAutoAssociations = usedAutoAssociations;
        this.numberAssociations = numberAssociations;
        this.smartContract = smartContract;
        this.numberPositiveBalances = numberPositiveBalances;
        this.ethereumNonce = ethereumNonce;
        this.stakeAtStartOfLastRewardedPeriod = stakeAtStartOfLastRewardedPeriod;
        this.autoRenewAccountId = autoRenewAccountId;
        this.autoRenewSeconds = autoRenewSeconds;
        this.contractKvPairsNumber = contractKvPairsNumber;
        this.cryptoAllowances = cryptoAllowances == null ? Collections.emptyList() : cryptoAllowances;
        this.approveForAllNftAllowances = approveForAllNftAllowances == null ? Collections.emptyList() : approveForAllNftAllowances;
        this.tokenAllowances = tokenAllowances == null ? Collections.emptyList() : tokenAllowances;
        this.numberTreasuryTitles = numberTreasuryTitles;
        this.expiredAndPendingRemoval = expiredAndPendingRemoval;
        this.firstContractStorageKey = firstContractStorageKey != null ? firstContractStorageKey : Bytes.EMPTY;
        this.headPendingAirdropId = headPendingAirdropId;
        this.numberPendingAirdrops = numberPendingAirdrops;
        this.numberHooksInUse = numberHooksInUse;
        this.firstHookId = firstHookId;
        this.numberEvmHookStorageSlots = numberEvmHookStorageSlots;
    }

    public Account(AccountID accountId, Bytes alias, Key key, long expirationSecond, long tinybarBalance, String memo, boolean deleted, long stakedToMe, long stakePeriodStart, OneOf<StakedIdOneOfType> stakedId, boolean declineReward, boolean receiverSigRequired, TokenID headTokenId, NftID headNftId, long headNftSerialNumber, long numberOwnedNfts, int maxAutoAssociations, int usedAutoAssociations, int numberAssociations, boolean smartContract, int numberPositiveBalances, long ethereumNonce, long stakeAtStartOfLastRewardedPeriod, AccountID autoRenewAccountId, long autoRenewSeconds, int contractKvPairsNumber, List<AccountCryptoAllowance> cryptoAllowances, List<AccountApprovalForAllAllowance> approveForAllNftAllowances, List<AccountFungibleTokenAllowance> tokenAllowances, int numberTreasuryTitles, boolean expiredAndPendingRemoval, Bytes firstContractStorageKey, PendingAirdropId headPendingAirdropId, long numberPendingAirdrops, long numberHooksInUse, long firstHookId, long numberEvmHookStorageSlots, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.accountId = accountId;
        this.alias = alias != null ? alias : Bytes.EMPTY;
        this.key = key;
        this.expirationSecond = expirationSecond;
        this.tinybarBalance = tinybarBalance;
        this.memo = memo != null ? memo : "";
        this.deleted = deleted;
        this.stakedToMe = stakedToMe;
        this.stakePeriodStart = stakePeriodStart;
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
        this.stakedId = stakedId;
        this.declineReward = declineReward;
        this.receiverSigRequired = receiverSigRequired;
        this.headTokenId = headTokenId;
        this.headNftId = headNftId;
        this.headNftSerialNumber = headNftSerialNumber;
        this.numberOwnedNfts = numberOwnedNfts;
        this.maxAutoAssociations = maxAutoAssociations;
        this.usedAutoAssociations = usedAutoAssociations;
        this.numberAssociations = numberAssociations;
        this.smartContract = smartContract;
        this.numberPositiveBalances = numberPositiveBalances;
        this.ethereumNonce = ethereumNonce;
        this.stakeAtStartOfLastRewardedPeriod = stakeAtStartOfLastRewardedPeriod;
        this.autoRenewAccountId = autoRenewAccountId;
        this.autoRenewSeconds = autoRenewSeconds;
        this.contractKvPairsNumber = contractKvPairsNumber;
        this.cryptoAllowances = cryptoAllowances == null ? Collections.emptyList() : cryptoAllowances;
        this.approveForAllNftAllowances = approveForAllNftAllowances == null ? Collections.emptyList() : approveForAllNftAllowances;
        this.tokenAllowances = tokenAllowances == null ? Collections.emptyList() : tokenAllowances;
        this.numberTreasuryTitles = numberTreasuryTitles;
        this.expiredAndPendingRemoval = expiredAndPendingRemoval;
        this.firstContractStorageKey = firstContractStorageKey != null ? firstContractStorageKey : Bytes.EMPTY;
        this.headPendingAirdropId = headPendingAirdropId;
        this.numberPendingAirdrops = numberPendingAirdrops;
        this.numberHooksInUse = numberHooksInUse;
        this.firstHookId = firstHookId;
        this.numberEvmHookStorageSlots = numberEvmHookStorageSlots;
    }

    public AccountID accountId() {
        return this.accountId;
    }

    public Bytes alias() {
        return this.alias;
    }

    public Key key() {
        return this.key;
    }

    public long expirationSecond() {
        return this.expirationSecond;
    }

    public long tinybarBalance() {
        return this.tinybarBalance;
    }

    public String memo() {
        return this.memo;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public long stakedToMe() {
        return this.stakedToMe;
    }

    public long stakePeriodStart() {
        return this.stakePeriodStart;
    }

    public OneOf<StakedIdOneOfType> stakedId() {
        return this.stakedId;
    }

    public boolean declineReward() {
        return this.declineReward;
    }

    public boolean receiverSigRequired() {
        return this.receiverSigRequired;
    }

    public TokenID headTokenId() {
        return this.headTokenId;
    }

    public NftID headNftId() {
        return this.headNftId;
    }

    public long headNftSerialNumber() {
        return this.headNftSerialNumber;
    }

    public long numberOwnedNfts() {
        return this.numberOwnedNfts;
    }

    public int maxAutoAssociations() {
        return this.maxAutoAssociations;
    }

    public int usedAutoAssociations() {
        return this.usedAutoAssociations;
    }

    public int numberAssociations() {
        return this.numberAssociations;
    }

    public boolean smartContract() {
        return this.smartContract;
    }

    public int numberPositiveBalances() {
        return this.numberPositiveBalances;
    }

    public long ethereumNonce() {
        return this.ethereumNonce;
    }

    public long stakeAtStartOfLastRewardedPeriod() {
        return this.stakeAtStartOfLastRewardedPeriod;
    }

    public AccountID autoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public long autoRenewSeconds() {
        return this.autoRenewSeconds;
    }

    public int contractKvPairsNumber() {
        return this.contractKvPairsNumber;
    }

    public List<AccountCryptoAllowance> cryptoAllowances() {
        return this.cryptoAllowances;
    }

    public List<AccountApprovalForAllAllowance> approveForAllNftAllowances() {
        return this.approveForAllNftAllowances;
    }

    public List<AccountFungibleTokenAllowance> tokenAllowances() {
        return this.tokenAllowances;
    }

    public int numberTreasuryTitles() {
        return this.numberTreasuryTitles;
    }

    public boolean expiredAndPendingRemoval() {
        return this.expiredAndPendingRemoval;
    }

    public Bytes firstContractStorageKey() {
        return this.firstContractStorageKey;
    }

    public PendingAirdropId headPendingAirdropId() {
        return this.headPendingAirdropId;
    }

    public long numberPendingAirdrops() {
        return this.numberPendingAirdrops;
    }

    public long numberHooksInUse() {
        return this.numberHooksInUse;
    }

    public long firstHookId() {
        return this.firstHookId;
    }

    public long numberEvmHookStorageSlots() {
        return this.numberEvmHookStorageSlots;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.ACCOUNT_ID, (Object)this.accountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)AccountSchema.ALIAS, (RandomAccessData)this.alias, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.KEY, (Object)this.key, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.EXPIRATION_SECOND, (long)this.expirationSecond, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.TINYBAR_BALANCE, (long)this.tinybarBalance, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)AccountSchema.MEMO, (String)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.DELETED, (boolean)this.deleted, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.STAKED_TO_ME, (long)this.stakedToMe, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.STAKE_PERIOD_START, (long)this.stakePeriodStart, (boolean)true);
            if (this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.STAKED_ACCOUNT_ID, (Object)((AccountID)this.stakedId.as()), AccountID.PROTOBUF);
            }
            if (this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID) {
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.STAKED_NODE_ID, (long)((Long)this.stakedId.as()), (boolean)true);
            }
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.DECLINE_REWARD, (boolean)this.declineReward, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.RECEIVER_SIG_REQUIRED, (boolean)this.receiverSigRequired, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.HEAD_TOKEN_ID, (Object)this.headTokenId, TokenID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.HEAD_NFT_ID, (Object)this.headNftId, NftID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.HEAD_NFT_SERIAL_NUMBER, (long)this.headNftSerialNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.NUMBER_OWNED_NFTS, (long)this.numberOwnedNfts, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.MAX_AUTO_ASSOCIATIONS, (int)this.maxAutoAssociations, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.USED_AUTO_ASSOCIATIONS, (int)this.usedAutoAssociations, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.NUMBER_ASSOCIATIONS, (int)this.numberAssociations, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.SMART_CONTRACT, (boolean)this.smartContract, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.NUMBER_POSITIVE_BALANCES, (int)this.numberPositiveBalances, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.ETHEREUM_NONCE, (long)this.ethereumNonce, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.STAKE_AT_START_OF_LAST_REWARDED_PERIOD, (long)this.stakeAtStartOfLastRewardedPeriod, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.AUTO_RENEW_ACCOUNT_ID, (Object)this.autoRenewAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.AUTO_RENEW_SECONDS, (long)this.autoRenewSeconds, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.CONTRACT_KV_PAIRS_NUMBER, (int)this.contractKvPairsNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AccountSchema.CRYPTO_ALLOWANCES, this.cryptoAllowances, AccountCryptoAllowance.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AccountSchema.APPROVE_FOR_ALL_NFT_ALLOWANCES, this.approveForAllNftAllowances, AccountApprovalForAllAllowance.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AccountSchema.TOKEN_ALLOWANCES, this.tokenAllowances, AccountFungibleTokenAllowance.PROTOBUF);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.NUMBER_TREASURY_TITLES, (int)this.numberTreasuryTitles, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.EXPIRED_AND_PENDING_REMOVAL, (boolean)this.expiredAndPendingRemoval, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)AccountSchema.FIRST_CONTRACT_STORAGE_KEY, (RandomAccessData)this.firstContractStorageKey, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.HEAD_PENDING_AIRDROP_ID, (Object)this.headPendingAirdropId, PendingAirdropId.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.NUMBER_PENDING_AIRDROPS, (long)this.numberPendingAirdrops, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.NUMBER_HOOKS_IN_USE, (long)this.numberHooksInUse, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.FIRST_HOOK_ID, (long)this.firstHookId, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.NUMBER_EVM_HOOK_STORAGE_SLOTS, (long)this.numberEvmHookStorageSlots, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<AccountFungibleTokenAllowance> list;
            List<AccountApprovalForAllAllowance> list$approveForAllNftAllowances;
            List<AccountCryptoAllowance> list$cryptoAllowances;
            int result = 1;
            if (this.accountId != null && !this.accountId.equals(Account.DEFAULT.accountId)) {
                result = 31 * result + this.accountId.hashCode();
            }
            if (this.alias != null && !this.alias.equals((Object)Account.DEFAULT.alias)) {
                result = 31 * result + this.alias.hashCode();
            }
            if (this.key != null && !this.key.equals(Account.DEFAULT.key)) {
                result = 31 * result + this.key.hashCode();
            }
            if (this.expirationSecond != Account.DEFAULT.expirationSecond) {
                result = 31 * result + Long.hashCode(this.expirationSecond);
            }
            if (this.tinybarBalance != Account.DEFAULT.tinybarBalance) {
                result = 31 * result + Long.hashCode(this.tinybarBalance);
            }
            if (this.memo != null && !this.memo.equals(Account.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.deleted != Account.DEFAULT.deleted) {
                result = 31 * result + Boolean.hashCode(this.deleted);
            }
            if (this.stakedToMe != Account.DEFAULT.stakedToMe) {
                result = 31 * result + Long.hashCode(this.stakedToMe);
            }
            if (this.stakePeriodStart != Account.DEFAULT.stakePeriodStart) {
                result = 31 * result + Long.hashCode(this.stakePeriodStart);
            }
            if (this.stakedId != null && !this.stakedId.equals(Account.DEFAULT.stakedId)) {
                result = 31 * result + this.stakedId.hashCode();
            }
            if (this.declineReward != Account.DEFAULT.declineReward) {
                result = 31 * result + Boolean.hashCode(this.declineReward);
            }
            if (this.receiverSigRequired != Account.DEFAULT.receiverSigRequired) {
                result = 31 * result + Boolean.hashCode(this.receiverSigRequired);
            }
            if (this.headTokenId != null && !this.headTokenId.equals(Account.DEFAULT.headTokenId)) {
                result = 31 * result + this.headTokenId.hashCode();
            }
            if (this.headNftId != null && !this.headNftId.equals(Account.DEFAULT.headNftId)) {
                result = 31 * result + this.headNftId.hashCode();
            }
            if (this.headNftSerialNumber != Account.DEFAULT.headNftSerialNumber) {
                result = 31 * result + Long.hashCode(this.headNftSerialNumber);
            }
            if (this.numberOwnedNfts != Account.DEFAULT.numberOwnedNfts) {
                result = 31 * result + Long.hashCode(this.numberOwnedNfts);
            }
            if (this.maxAutoAssociations != Account.DEFAULT.maxAutoAssociations) {
                result = 31 * result + Integer.hashCode(this.maxAutoAssociations);
            }
            if (this.usedAutoAssociations != Account.DEFAULT.usedAutoAssociations) {
                result = 31 * result + Integer.hashCode(this.usedAutoAssociations);
            }
            if (this.numberAssociations != Account.DEFAULT.numberAssociations) {
                result = 31 * result + Integer.hashCode(this.numberAssociations);
            }
            if (this.smartContract != Account.DEFAULT.smartContract) {
                result = 31 * result + Boolean.hashCode(this.smartContract);
            }
            if (this.numberPositiveBalances != Account.DEFAULT.numberPositiveBalances) {
                result = 31 * result + Integer.hashCode(this.numberPositiveBalances);
            }
            if (this.ethereumNonce != Account.DEFAULT.ethereumNonce) {
                result = 31 * result + Long.hashCode(this.ethereumNonce);
            }
            if (this.stakeAtStartOfLastRewardedPeriod != Account.DEFAULT.stakeAtStartOfLastRewardedPeriod) {
                result = 31 * result + Long.hashCode(this.stakeAtStartOfLastRewardedPeriod);
            }
            if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(Account.DEFAULT.autoRenewAccountId)) {
                result = 31 * result + this.autoRenewAccountId.hashCode();
            }
            if (this.autoRenewSeconds != Account.DEFAULT.autoRenewSeconds) {
                result = 31 * result + Long.hashCode(this.autoRenewSeconds);
            }
            if (this.contractKvPairsNumber != Account.DEFAULT.contractKvPairsNumber) {
                result = 31 * result + Integer.hashCode(this.contractKvPairsNumber);
            }
            if ((list$cryptoAllowances = this.cryptoAllowances) != null) {
                for (AccountCryptoAllowance accountCryptoAllowance : list$cryptoAllowances) {
                    if (accountCryptoAllowance != null) {
                        result = 31 * result + ((Object)accountCryptoAllowance).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list$approveForAllNftAllowances = this.approveForAllNftAllowances) != null) {
                for (AccountApprovalForAllAllowance accountApprovalForAllAllowance : list$approveForAllNftAllowances) {
                    if (accountApprovalForAllAllowance != null) {
                        result = 31 * result + ((Object)accountApprovalForAllAllowance).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list = this.tokenAllowances) != null) {
                for (AccountFungibleTokenAllowance o : list) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.numberTreasuryTitles != Account.DEFAULT.numberTreasuryTitles) {
                result = 31 * result + Integer.hashCode(this.numberTreasuryTitles);
            }
            if (this.expiredAndPendingRemoval != Account.DEFAULT.expiredAndPendingRemoval) {
                result = 31 * result + Boolean.hashCode(this.expiredAndPendingRemoval);
            }
            if (this.firstContractStorageKey != null && !this.firstContractStorageKey.equals((Object)Account.DEFAULT.firstContractStorageKey)) {
                result = 31 * result + this.firstContractStorageKey.hashCode();
            }
            if (this.headPendingAirdropId != null && !this.headPendingAirdropId.equals(Account.DEFAULT.headPendingAirdropId)) {
                result = 31 * result + this.headPendingAirdropId.hashCode();
            }
            if (this.numberPendingAirdrops != Account.DEFAULT.numberPendingAirdrops) {
                result = 31 * result + Long.hashCode(this.numberPendingAirdrops);
            }
            if (this.numberHooksInUse != Account.DEFAULT.numberHooksInUse) {
                result = 31 * result + Long.hashCode(this.numberHooksInUse);
            }
            if (this.firstHookId != Account.DEFAULT.firstHookId) {
                result = 31 * result + Long.hashCode(this.firstHookId);
            }
            if (this.numberEvmHookStorageSlots != Account.DEFAULT.numberEvmHookStorageSlots) {
                result = 31 * result + Long.hashCode(this.numberEvmHookStorageSlots);
            }
            if (this.$unknownFields != null) {
                void var5_12;
                boolean bl = false;
                while (var5_12 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var5_12).hashCode();
                    ++var5_12;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Account thatObj = (Account)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.accountId == null && thatObj.accountId != null) {
            return false;
        }
        if (this.accountId != null && !this.accountId.equals(thatObj.accountId)) {
            return false;
        }
        if (this.alias == null && thatObj.alias != null) {
            return false;
        }
        if (this.alias != null && !this.alias.equals((Object)thatObj.alias)) {
            return false;
        }
        if (this.key == null && thatObj.key != null) {
            return false;
        }
        if (this.key != null && !this.key.equals(thatObj.key)) {
            return false;
        }
        if (this.expirationSecond != thatObj.expirationSecond) {
            return false;
        }
        if (this.tinybarBalance != thatObj.tinybarBalance) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.stakedToMe != thatObj.stakedToMe) {
            return false;
        }
        if (this.stakePeriodStart != thatObj.stakePeriodStart) {
            return false;
        }
        if (this.stakedId == null && thatObj.stakedId != null) {
            return false;
        }
        if (this.stakedId != null && !this.stakedId.equals(thatObj.stakedId)) {
            return false;
        }
        if (this.declineReward != thatObj.declineReward) {
            return false;
        }
        if (this.receiverSigRequired != thatObj.receiverSigRequired) {
            return false;
        }
        if (this.headTokenId == null && thatObj.headTokenId != null) {
            return false;
        }
        if (this.headTokenId != null && !this.headTokenId.equals(thatObj.headTokenId)) {
            return false;
        }
        if (this.headNftId == null && thatObj.headNftId != null) {
            return false;
        }
        if (this.headNftId != null && !this.headNftId.equals(thatObj.headNftId)) {
            return false;
        }
        if (this.headNftSerialNumber != thatObj.headNftSerialNumber) {
            return false;
        }
        if (this.numberOwnedNfts != thatObj.numberOwnedNfts) {
            return false;
        }
        if (this.maxAutoAssociations != thatObj.maxAutoAssociations) {
            return false;
        }
        if (this.usedAutoAssociations != thatObj.usedAutoAssociations) {
            return false;
        }
        if (this.numberAssociations != thatObj.numberAssociations) {
            return false;
        }
        if (this.smartContract != thatObj.smartContract) {
            return false;
        }
        if (this.numberPositiveBalances != thatObj.numberPositiveBalances) {
            return false;
        }
        if (this.ethereumNonce != thatObj.ethereumNonce) {
            return false;
        }
        if (this.stakeAtStartOfLastRewardedPeriod != thatObj.stakeAtStartOfLastRewardedPeriod) {
            return false;
        }
        if (this.autoRenewAccountId == null && thatObj.autoRenewAccountId != null) {
            return false;
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(thatObj.autoRenewAccountId)) {
            return false;
        }
        if (this.autoRenewSeconds != thatObj.autoRenewSeconds) {
            return false;
        }
        if (this.contractKvPairsNumber != thatObj.contractKvPairsNumber) {
            return false;
        }
        if (this.cryptoAllowances == null && thatObj.cryptoAllowances != null) {
            return false;
        }
        if (this.cryptoAllowances != null && !this.cryptoAllowances.equals(thatObj.cryptoAllowances)) {
            return false;
        }
        if (this.approveForAllNftAllowances == null && thatObj.approveForAllNftAllowances != null) {
            return false;
        }
        if (this.approveForAllNftAllowances != null && !this.approveForAllNftAllowances.equals(thatObj.approveForAllNftAllowances)) {
            return false;
        }
        if (this.tokenAllowances == null && thatObj.tokenAllowances != null) {
            return false;
        }
        if (this.tokenAllowances != null && !this.tokenAllowances.equals(thatObj.tokenAllowances)) {
            return false;
        }
        if (this.numberTreasuryTitles != thatObj.numberTreasuryTitles) {
            return false;
        }
        if (this.expiredAndPendingRemoval != thatObj.expiredAndPendingRemoval) {
            return false;
        }
        if (this.firstContractStorageKey == null && thatObj.firstContractStorageKey != null) {
            return false;
        }
        if (this.firstContractStorageKey != null && !this.firstContractStorageKey.equals((Object)thatObj.firstContractStorageKey)) {
            return false;
        }
        if (this.headPendingAirdropId == null && thatObj.headPendingAirdropId != null) {
            return false;
        }
        if (this.headPendingAirdropId != null && !this.headPendingAirdropId.equals(thatObj.headPendingAirdropId)) {
            return false;
        }
        if (this.numberPendingAirdrops != thatObj.numberPendingAirdrops) {
            return false;
        }
        if (this.numberHooksInUse != thatObj.numberHooksInUse) {
            return false;
        }
        if (this.firstHookId != thatObj.firstHookId) {
            return false;
        }
        if (this.numberEvmHookStorageSlots != thatObj.numberEvmHookStorageSlots) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "Account[accountId=" + String.valueOf(this.accountId) + ", alias=" + String.valueOf(this.alias) + ", key=" + String.valueOf(this.key) + ", expirationSecond=" + this.expirationSecond + ", tinybarBalance=" + this.tinybarBalance + ", memo=" + this.memo + ", deleted=" + this.deleted + ", stakedToMe=" + this.stakedToMe + ", stakePeriodStart=" + this.stakePeriodStart + ", stakedId=" + String.valueOf(this.stakedId) + ", declineReward=" + this.declineReward + ", receiverSigRequired=" + this.receiverSigRequired + ", headTokenId=" + String.valueOf(this.headTokenId) + ", headNftId=" + String.valueOf(this.headNftId) + ", headNftSerialNumber=" + this.headNftSerialNumber + ", numberOwnedNfts=" + this.numberOwnedNfts + ", maxAutoAssociations=" + this.maxAutoAssociations + ", usedAutoAssociations=" + this.usedAutoAssociations + ", numberAssociations=" + this.numberAssociations + ", smartContract=" + this.smartContract + ", numberPositiveBalances=" + this.numberPositiveBalances + ", ethereumNonce=" + this.ethereumNonce + ", stakeAtStartOfLastRewardedPeriod=" + this.stakeAtStartOfLastRewardedPeriod + ", autoRenewAccountId=" + String.valueOf(this.autoRenewAccountId) + ", autoRenewSeconds=" + this.autoRenewSeconds + ", contractKvPairsNumber=" + this.contractKvPairsNumber + ", cryptoAllowances=" + String.valueOf(this.cryptoAllowances) + ", approveForAllNftAllowances=" + String.valueOf(this.approveForAllNftAllowances) + ", tokenAllowances=" + String.valueOf(this.tokenAllowances) + ", numberTreasuryTitles=" + this.numberTreasuryTitles + ", expiredAndPendingRemoval=" + this.expiredAndPendingRemoval + ", firstContractStorageKey=" + String.valueOf(this.firstContractStorageKey) + ", headPendingAirdropId=" + String.valueOf(this.headPendingAirdropId) + ", numberPendingAirdrops=" + this.numberPendingAirdrops + ", numberHooksInUse=" + this.numberHooksInUse + ", firstHookId=" + this.firstHookId + ", numberEvmHookStorageSlots=" + this.numberEvmHookStorageSlots + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public Key keyOrElse(@NonNull Key defaultValue) {
        return this.hasKey() ? this.key : defaultValue;
    }

    @NonNull
    public Key keyOrThrow() {
        return Objects.requireNonNull(this.key, "Field key is null");
    }

    public void ifKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKey()) {
            ifPresent.accept(this.key);
        }
    }

    public boolean hasHeadTokenId() {
        return this.headTokenId != null;
    }

    public TokenID headTokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasHeadTokenId() ? this.headTokenId : defaultValue;
    }

    @NonNull
    public TokenID headTokenIdOrThrow() {
        return Objects.requireNonNull(this.headTokenId, "Field headTokenId is null");
    }

    public void ifHeadTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasHeadTokenId()) {
            ifPresent.accept(this.headTokenId);
        }
    }

    public boolean hasHeadNftId() {
        return this.headNftId != null;
    }

    public NftID headNftIdOrElse(@NonNull NftID defaultValue) {
        return this.hasHeadNftId() ? this.headNftId : defaultValue;
    }

    @NonNull
    public NftID headNftIdOrThrow() {
        return Objects.requireNonNull(this.headNftId, "Field headNftId is null");
    }

    public void ifHeadNftId(@NonNull Consumer<NftID> ifPresent) {
        if (this.hasHeadNftId()) {
            ifPresent.accept(this.headNftId);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasHeadPendingAirdropId() {
        return this.headPendingAirdropId != null;
    }

    public PendingAirdropId headPendingAirdropIdOrElse(@NonNull PendingAirdropId defaultValue) {
        return this.hasHeadPendingAirdropId() ? this.headPendingAirdropId : defaultValue;
    }

    @NonNull
    public PendingAirdropId headPendingAirdropIdOrThrow() {
        return Objects.requireNonNull(this.headPendingAirdropId, "Field headPendingAirdropId is null");
    }

    public void ifHeadPendingAirdropId(@NonNull Consumer<PendingAirdropId> ifPresent) {
        if (this.hasHeadPendingAirdropId()) {
            ifPresent.accept(this.headPendingAirdropId);
        }
    }

    @Nullable
    public AccountID stakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID ? (AccountID)this.stakedId.value() : null;
    }

    public boolean hasStakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID;
    }

    public AccountID stakedAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasStakedAccountId() ? this.stakedAccountId() : defaultValue;
    }

    @NonNull
    public AccountID stakedAccountIdOrThrow() {
        return Objects.requireNonNull(this.stakedAccountId(), "Field stakedAccountId is null");
    }

    @Nullable
    public Long stakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID ? (Long)this.stakedId.value() : null;
    }

    public boolean hasStakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID;
    }

    public Long stakedNodeIdOrElse(@NonNull Long defaultValue) {
        return this.hasStakedNodeId() ? this.stakedNodeId() : defaultValue;
    }

    @NonNull
    public Long stakedNodeIdOrThrow() {
        return Objects.requireNonNull(this.stakedNodeId(), "Field stakedNodeId is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.accountId, this.alias, this.key, this.expirationSecond, this.tinybarBalance, this.memo, this.deleted, this.stakedToMe, this.stakePeriodStart, this.stakedId, this.declineReward, this.receiverSigRequired, this.headTokenId, this.headNftId, this.headNftSerialNumber, this.numberOwnedNfts, this.maxAutoAssociations, this.usedAutoAssociations, this.numberAssociations, this.smartContract, this.numberPositiveBalances, this.ethereumNonce, this.stakeAtStartOfLastRewardedPeriod, this.autoRenewAccountId, this.autoRenewSeconds, this.contractKvPairsNumber, this.cryptoAllowances, this.approveForAllNftAllowances, this.tokenAllowances, this.numberTreasuryTitles, this.expiredAndPendingRemoval, this.firstContractStorageKey, this.headPendingAirdropId, this.numberPendingAirdrops, this.numberHooksInUse, this.firstHookId, this.numberEvmHookStorageSlots, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum StakedIdOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        STAKED_ACCOUNT_ID(10, "staked_account_id"),
        STAKED_NODE_ID(11, "staked_node_id");

        private final int protoOrdinal;
        private final String protoName;

        private StakedIdOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static StakedIdOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 10 -> STAKED_ACCOUNT_ID;
                case 11 -> STAKED_NODE_ID;
                default -> UNSET;
            };
        }

        public static StakedIdOneOfType fromString(String name) {
            return switch (name) {
                case "staked_account_id", "STAKED_ACCOUNT_ID" -> STAKED_ACCOUNT_ID;
                case "staked_node_id", "STAKED_NODE_ID" -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static StakedIdOneOfType fromObject(Object obj) {
            if (obj == null) {
                return StakedIdOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof StakedIdOneOfType) {
                StakedIdOneOfType pbjEnum = (StakedIdOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<StakedIdOneOfType> fromObjects(List<?> list) {
            return list.stream().map(StakedIdOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof StakedIdOneOfType) {
                StakedIdOneOfType pbjEnum = (StakedIdOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither StakedIdOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(StakedIdOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof StakedIdOneOfType) {
                StakedIdOneOfType e1 = (StakedIdOneOfType)((Object)o1);
                if (o2 instanceof StakedIdOneOfType) {
                    StakedIdOneOfType e2 = (StakedIdOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof StakedIdOneOfType) {
                StakedIdOneOfType e1 = (StakedIdOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither StakedIdOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof StakedIdOneOfType) {
                StakedIdOneOfType e2 = (StakedIdOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither StakedIdOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class Builder {
        @Nullable
        private AccountID accountId = null;
        @NonNull
        private Bytes alias = Bytes.EMPTY;
        @Nullable
        private Key key = null;
        private long expirationSecond = 0L;
        private long tinybarBalance = 0L;
        @NonNull
        private String memo = "";
        private boolean deleted = false;
        private long stakedToMe = 0L;
        private long stakePeriodStart = 0L;
        private OneOf<StakedIdOneOfType> stakedId = AccountProtoCodec.STAKED_ID_UNSET;
        private boolean declineReward = false;
        private boolean receiverSigRequired = false;
        @Nullable
        private TokenID headTokenId = null;
        @Nullable
        private NftID headNftId = null;
        private long headNftSerialNumber = 0L;
        private long numberOwnedNfts = 0L;
        private int maxAutoAssociations = 0;
        private int usedAutoAssociations = 0;
        private int numberAssociations = 0;
        private boolean smartContract = false;
        private int numberPositiveBalances = 0;
        private long ethereumNonce = 0L;
        private long stakeAtStartOfLastRewardedPeriod = 0L;
        @Nullable
        private AccountID autoRenewAccountId = null;
        private long autoRenewSeconds = 0L;
        private int contractKvPairsNumber = 0;
        @NonNull
        private List<AccountCryptoAllowance> cryptoAllowances = Collections.emptyList();
        @NonNull
        private List<AccountApprovalForAllAllowance> approveForAllNftAllowances = Collections.emptyList();
        @NonNull
        private List<AccountFungibleTokenAllowance> tokenAllowances = Collections.emptyList();
        private int numberTreasuryTitles = 0;
        private boolean expiredAndPendingRemoval = false;
        @NonNull
        private Bytes firstContractStorageKey = Bytes.EMPTY;
        @Nullable
        private PendingAirdropId headPendingAirdropId = null;
        private long numberPendingAirdrops = 0L;
        private long numberHooksInUse = 0L;
        private long firstHookId = 0L;
        private long numberEvmHookStorageSlots = 0L;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(AccountID accountId, Bytes alias, Key key, long expirationSecond, long tinybarBalance, String memo, boolean deleted, long stakedToMe, long stakePeriodStart, OneOf<StakedIdOneOfType> stakedId, boolean declineReward, boolean receiverSigRequired, TokenID headTokenId, NftID headNftId, long headNftSerialNumber, long numberOwnedNfts, int maxAutoAssociations, int usedAutoAssociations, int numberAssociations, boolean smartContract, int numberPositiveBalances, long ethereumNonce, long stakeAtStartOfLastRewardedPeriod, AccountID autoRenewAccountId, long autoRenewSeconds, int contractKvPairsNumber, List<AccountCryptoAllowance> cryptoAllowances, List<AccountApprovalForAllAllowance> approveForAllNftAllowances, List<AccountFungibleTokenAllowance> tokenAllowances, int numberTreasuryTitles, boolean expiredAndPendingRemoval, Bytes firstContractStorageKey, PendingAirdropId headPendingAirdropId, long numberPendingAirdrops, long numberHooksInUse, long firstHookId, long numberEvmHookStorageSlots) {
            this.$unknownFields = null;
            this.accountId = accountId;
            this.alias = alias != null ? alias : Bytes.EMPTY;
            this.key = key;
            this.expirationSecond = expirationSecond;
            this.tinybarBalance = tinybarBalance;
            this.memo = memo != null ? memo : "";
            this.deleted = deleted;
            this.stakedToMe = stakedToMe;
            this.stakePeriodStart = stakePeriodStart;
            this.stakedId = stakedId;
            this.declineReward = declineReward;
            this.receiverSigRequired = receiverSigRequired;
            this.headTokenId = headTokenId;
            this.headNftId = headNftId;
            this.headNftSerialNumber = headNftSerialNumber;
            this.numberOwnedNfts = numberOwnedNfts;
            this.maxAutoAssociations = maxAutoAssociations;
            this.usedAutoAssociations = usedAutoAssociations;
            this.numberAssociations = numberAssociations;
            this.smartContract = smartContract;
            this.numberPositiveBalances = numberPositiveBalances;
            this.ethereumNonce = ethereumNonce;
            this.stakeAtStartOfLastRewardedPeriod = stakeAtStartOfLastRewardedPeriod;
            this.autoRenewAccountId = autoRenewAccountId;
            this.autoRenewSeconds = autoRenewSeconds;
            this.contractKvPairsNumber = contractKvPairsNumber;
            this.cryptoAllowances = cryptoAllowances == null ? Collections.emptyList() : cryptoAllowances;
            this.approveForAllNftAllowances = approveForAllNftAllowances == null ? Collections.emptyList() : approveForAllNftAllowances;
            this.tokenAllowances = tokenAllowances == null ? Collections.emptyList() : tokenAllowances;
            this.numberTreasuryTitles = numberTreasuryTitles;
            this.expiredAndPendingRemoval = expiredAndPendingRemoval;
            this.firstContractStorageKey = firstContractStorageKey != null ? firstContractStorageKey : Bytes.EMPTY;
            this.headPendingAirdropId = headPendingAirdropId;
            this.numberPendingAirdrops = numberPendingAirdrops;
            this.numberHooksInUse = numberHooksInUse;
            this.firstHookId = firstHookId;
            this.numberEvmHookStorageSlots = numberEvmHookStorageSlots;
        }

        public Builder(AccountID accountId, Bytes alias, Key key, long expirationSecond, long tinybarBalance, String memo, boolean deleted, long stakedToMe, long stakePeriodStart, OneOf<StakedIdOneOfType> stakedId, boolean declineReward, boolean receiverSigRequired, TokenID headTokenId, NftID headNftId, long headNftSerialNumber, long numberOwnedNfts, int maxAutoAssociations, int usedAutoAssociations, int numberAssociations, boolean smartContract, int numberPositiveBalances, long ethereumNonce, long stakeAtStartOfLastRewardedPeriod, AccountID autoRenewAccountId, long autoRenewSeconds, int contractKvPairsNumber, List<AccountCryptoAllowance> cryptoAllowances, List<AccountApprovalForAllAllowance> approveForAllNftAllowances, List<AccountFungibleTokenAllowance> tokenAllowances, int numberTreasuryTitles, boolean expiredAndPendingRemoval, Bytes firstContractStorageKey, PendingAirdropId headPendingAirdropId, long numberPendingAirdrops, long numberHooksInUse, long firstHookId, long numberEvmHookStorageSlots, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.accountId = accountId;
            this.alias = alias != null ? alias : Bytes.EMPTY;
            this.key = key;
            this.expirationSecond = expirationSecond;
            this.tinybarBalance = tinybarBalance;
            this.memo = memo != null ? memo : "";
            this.deleted = deleted;
            this.stakedToMe = stakedToMe;
            this.stakePeriodStart = stakePeriodStart;
            this.stakedId = stakedId;
            this.declineReward = declineReward;
            this.receiverSigRequired = receiverSigRequired;
            this.headTokenId = headTokenId;
            this.headNftId = headNftId;
            this.headNftSerialNumber = headNftSerialNumber;
            this.numberOwnedNfts = numberOwnedNfts;
            this.maxAutoAssociations = maxAutoAssociations;
            this.usedAutoAssociations = usedAutoAssociations;
            this.numberAssociations = numberAssociations;
            this.smartContract = smartContract;
            this.numberPositiveBalances = numberPositiveBalances;
            this.ethereumNonce = ethereumNonce;
            this.stakeAtStartOfLastRewardedPeriod = stakeAtStartOfLastRewardedPeriod;
            this.autoRenewAccountId = autoRenewAccountId;
            this.autoRenewSeconds = autoRenewSeconds;
            this.contractKvPairsNumber = contractKvPairsNumber;
            this.cryptoAllowances = cryptoAllowances == null ? Collections.emptyList() : cryptoAllowances;
            this.approveForAllNftAllowances = approveForAllNftAllowances == null ? Collections.emptyList() : approveForAllNftAllowances;
            this.tokenAllowances = tokenAllowances == null ? Collections.emptyList() : tokenAllowances;
            this.numberTreasuryTitles = numberTreasuryTitles;
            this.expiredAndPendingRemoval = expiredAndPendingRemoval;
            this.firstContractStorageKey = firstContractStorageKey != null ? firstContractStorageKey : Bytes.EMPTY;
            this.headPendingAirdropId = headPendingAirdropId;
            this.numberPendingAirdrops = numberPendingAirdrops;
            this.numberHooksInUse = numberHooksInUse;
            this.firstHookId = firstHookId;
            this.numberEvmHookStorageSlots = numberEvmHookStorageSlots;
        }

        public Account build() {
            return new Account(this.accountId, this.alias, this.key, this.expirationSecond, this.tinybarBalance, this.memo, this.deleted, this.stakedToMe, this.stakePeriodStart, this.stakedId, this.declineReward, this.receiverSigRequired, this.headTokenId, this.headNftId, this.headNftSerialNumber, this.numberOwnedNfts, this.maxAutoAssociations, this.usedAutoAssociations, this.numberAssociations, this.smartContract, this.numberPositiveBalances, this.ethereumNonce, this.stakeAtStartOfLastRewardedPeriod, this.autoRenewAccountId, this.autoRenewSeconds, this.contractKvPairsNumber, this.cryptoAllowances, this.approveForAllNftAllowances, this.tokenAllowances, this.numberTreasuryTitles, this.expiredAndPendingRemoval, this.firstContractStorageKey, this.headPendingAirdropId, this.numberPendingAirdrops, this.numberHooksInUse, this.firstHookId, this.numberEvmHookStorageSlots);
        }

        public Builder accountId(@Nullable AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder alias(@NonNull Bytes alias) {
            this.alias = alias != null ? alias : Bytes.EMPTY;
            return this;
        }

        public Builder key(@Nullable Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Key.Builder builder) {
            this.key = builder.build();
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder tinybarBalance(long tinybarBalance) {
            this.tinybarBalance = tinybarBalance;
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder stakedToMe(long stakedToMe) {
            this.stakedToMe = stakedToMe;
            return this;
        }

        public Builder stakePeriodStart(long stakePeriodStart) {
            this.stakePeriodStart = stakePeriodStart;
            return this;
        }

        public void clearStakedId() {
            this.stakedId = AccountProtoCodec.STAKED_ID_UNSET;
        }

        public Builder stakedAccountId(@Nullable AccountID stakedAccountId) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)stakedAccountId);
            return this;
        }

        public Builder stakedAccountId(AccountID.Builder builder) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder stakedNodeId(long stakedNodeId) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_NODE_ID, (Object)stakedNodeId);
            return this;
        }

        public Builder declineReward(boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }

        public Builder receiverSigRequired(boolean receiverSigRequired) {
            this.receiverSigRequired = receiverSigRequired;
            return this;
        }

        public Builder headTokenId(@Nullable TokenID headTokenId) {
            this.headTokenId = headTokenId;
            return this;
        }

        public Builder headTokenId(TokenID.Builder builder) {
            this.headTokenId = builder.build();
            return this;
        }

        public Builder headNftId(@Nullable NftID headNftId) {
            this.headNftId = headNftId;
            return this;
        }

        public Builder headNftId(NftID.Builder builder) {
            this.headNftId = builder.build();
            return this;
        }

        public Builder headNftSerialNumber(long headNftSerialNumber) {
            this.headNftSerialNumber = headNftSerialNumber;
            return this;
        }

        public Builder numberOwnedNfts(long numberOwnedNfts) {
            this.numberOwnedNfts = numberOwnedNfts;
            return this;
        }

        public Builder maxAutoAssociations(int maxAutoAssociations) {
            this.maxAutoAssociations = maxAutoAssociations;
            return this;
        }

        public Builder usedAutoAssociations(int usedAutoAssociations) {
            this.usedAutoAssociations = usedAutoAssociations;
            return this;
        }

        public Builder numberAssociations(int numberAssociations) {
            this.numberAssociations = numberAssociations;
            return this;
        }

        public Builder smartContract(boolean smartContract) {
            this.smartContract = smartContract;
            return this;
        }

        public Builder numberPositiveBalances(int numberPositiveBalances) {
            this.numberPositiveBalances = numberPositiveBalances;
            return this;
        }

        public Builder ethereumNonce(long ethereumNonce) {
            this.ethereumNonce = ethereumNonce;
            return this;
        }

        public Builder stakeAtStartOfLastRewardedPeriod(long stakeAtStartOfLastRewardedPeriod) {
            this.stakeAtStartOfLastRewardedPeriod = stakeAtStartOfLastRewardedPeriod;
            return this;
        }

        public Builder autoRenewAccountId(@Nullable AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder autoRenewSeconds(long autoRenewSeconds) {
            this.autoRenewSeconds = autoRenewSeconds;
            return this;
        }

        public Builder contractKvPairsNumber(int contractKvPairsNumber) {
            this.contractKvPairsNumber = contractKvPairsNumber;
            return this;
        }

        public Builder cryptoAllowances(@NonNull List<AccountCryptoAllowance> cryptoAllowances) {
            this.cryptoAllowances = cryptoAllowances != null ? cryptoAllowances : Collections.emptyList();
            return this;
        }

        public Builder cryptoAllowances(AccountCryptoAllowance ... values) {
            this.cryptoAllowances = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder approveForAllNftAllowances(@NonNull List<AccountApprovalForAllAllowance> approveForAllNftAllowances) {
            this.approveForAllNftAllowances = approveForAllNftAllowances != null ? approveForAllNftAllowances : Collections.emptyList();
            return this;
        }

        public Builder approveForAllNftAllowances(AccountApprovalForAllAllowance ... values) {
            this.approveForAllNftAllowances = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder tokenAllowances(@NonNull List<AccountFungibleTokenAllowance> tokenAllowances) {
            this.tokenAllowances = tokenAllowances != null ? tokenAllowances : Collections.emptyList();
            return this;
        }

        public Builder tokenAllowances(AccountFungibleTokenAllowance ... values) {
            this.tokenAllowances = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder numberTreasuryTitles(int numberTreasuryTitles) {
            this.numberTreasuryTitles = numberTreasuryTitles;
            return this;
        }

        public Builder expiredAndPendingRemoval(boolean expiredAndPendingRemoval) {
            this.expiredAndPendingRemoval = expiredAndPendingRemoval;
            return this;
        }

        public Builder firstContractStorageKey(@NonNull Bytes firstContractStorageKey) {
            this.firstContractStorageKey = firstContractStorageKey != null ? firstContractStorageKey : Bytes.EMPTY;
            return this;
        }

        public Builder headPendingAirdropId(@Nullable PendingAirdropId headPendingAirdropId) {
            this.headPendingAirdropId = headPendingAirdropId;
            return this;
        }

        public Builder headPendingAirdropId(PendingAirdropId.Builder builder) {
            this.headPendingAirdropId = builder.build();
            return this;
        }

        public Builder numberPendingAirdrops(long numberPendingAirdrops) {
            this.numberPendingAirdrops = numberPendingAirdrops;
            return this;
        }

        public Builder numberHooksInUse(long numberHooksInUse) {
            this.numberHooksInUse = numberHooksInUse;
            return this;
        }

        public Builder firstHookId(long firstHookId) {
            this.firstHookId = firstHookId;
            return this;
        }

        public Builder numberEvmHookStorageSlots(long numberEvmHookStorageSlots) {
            this.numberEvmHookStorageSlots = numberEvmHookStorageSlots;
            return this;
        }

        public AccountID accountId() {
            return this.accountId;
        }

        public Bytes alias() {
            return this.alias;
        }

        public Key key() {
            return this.key;
        }

        public long expirationSecond() {
            return this.expirationSecond;
        }

        public long tinybarBalance() {
            return this.tinybarBalance;
        }

        public String memo() {
            return this.memo;
        }

        public boolean deleted() {
            return this.deleted;
        }

        public long stakedToMe() {
            return this.stakedToMe;
        }

        public long stakePeriodStart() {
            return this.stakePeriodStart;
        }

        public OneOf<StakedIdOneOfType> stakedId() {
            return this.stakedId;
        }

        public boolean declineReward() {
            return this.declineReward;
        }

        public boolean receiverSigRequired() {
            return this.receiverSigRequired;
        }

        public TokenID headTokenId() {
            return this.headTokenId;
        }

        public NftID headNftId() {
            return this.headNftId;
        }

        public long headNftSerialNumber() {
            return this.headNftSerialNumber;
        }

        public long numberOwnedNfts() {
            return this.numberOwnedNfts;
        }

        public int maxAutoAssociations() {
            return this.maxAutoAssociations;
        }

        public int usedAutoAssociations() {
            return this.usedAutoAssociations;
        }

        public int numberAssociations() {
            return this.numberAssociations;
        }

        public boolean smartContract() {
            return this.smartContract;
        }

        public int numberPositiveBalances() {
            return this.numberPositiveBalances;
        }

        public long ethereumNonce() {
            return this.ethereumNonce;
        }

        public long stakeAtStartOfLastRewardedPeriod() {
            return this.stakeAtStartOfLastRewardedPeriod;
        }

        public AccountID autoRenewAccountId() {
            return this.autoRenewAccountId;
        }

        public long autoRenewSeconds() {
            return this.autoRenewSeconds;
        }

        public int contractKvPairsNumber() {
            return this.contractKvPairsNumber;
        }

        public List<AccountCryptoAllowance> cryptoAllowances() {
            return this.cryptoAllowances;
        }

        public List<AccountApprovalForAllAllowance> approveForAllNftAllowances() {
            return this.approveForAllNftAllowances;
        }

        public List<AccountFungibleTokenAllowance> tokenAllowances() {
            return this.tokenAllowances;
        }

        public int numberTreasuryTitles() {
            return this.numberTreasuryTitles;
        }

        public boolean expiredAndPendingRemoval() {
            return this.expiredAndPendingRemoval;
        }

        public Bytes firstContractStorageKey() {
            return this.firstContractStorageKey;
        }

        public PendingAirdropId headPendingAirdropId() {
            return this.headPendingAirdropId;
        }

        public long numberPendingAirdrops() {
            return this.numberPendingAirdrops;
        }

        public long numberHooksInUse() {
            return this.numberHooksInUse;
        }

        public long firstHookId() {
            return this.firstHookId;
        }

        public long numberEvmHookStorageSlots() {
            return this.numberEvmHookStorageSlots;
        }
    }
}

