/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.util.FileSigningUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.pcli.AbstractCommand;
import picocli.CommandLine;

public abstract class SignCommand
extends AbstractCommand {
    private static final Logger logger = LogManager.getLogger(SignCommand.class);
    private List<Path> pathsToSign = List.of(FileUtils.getAbsolutePath());
    @Nullable
    private Path destinationDirectory = null;
    private Path keyFilePath;
    private String keyFilePassword;
    private String keyAlias;
    private KeyPair keyPair;

    @CommandLine.Parameters(description={"The path to the key file to use to generate signatures"}, index="0")
    private void setKeyFile(@NonNull Path keyFilePath) {
        this.keyFilePath = this.pathMustExist(keyFilePath.toAbsolutePath().normalize());
    }

    @CommandLine.Parameters(description={"The password to the key file"}, index="1")
    private void setKeyFilePassword(@NonNull String keyFilePassword) {
        this.keyFilePassword = keyFilePassword;
    }

    @CommandLine.Parameters(description={"The alias of the key in the key file"}, index="2")
    private void setKeyAlias(@NonNull String keyAlias) {
        this.keyAlias = keyAlias;
    }

    @CommandLine.Option(names={"-p", "--paths-to-sign"}, description={"The paths to what will be signed. Can contain single files, as well as directories.Defaults to the current working directory"})
    private void setPathsToSign(@NonNull List<Path> pathsToSign) {
        this.pathsToSign = pathsToSign.stream().map(path -> this.pathMustExist(path.toAbsolutePath().normalize())).toList();
    }

    @CommandLine.Option(names={"-d", "--destination-directory"}, description={"Specify the destination directory where signature files will be generated. If specified,source files will be copied to the destination directory. If not specified,the signature file will simply be generated in the same directory as the source file"})
    private void setDestinationDirectory(@NonNull Path destinationDirectory) {
        this.destinationDirectory = destinationDirectory.toAbsolutePath().normalize();
    }

    @Override
    public Integer call() {
        this.keyPair = FileSigningUtils.loadPfxKey((Path)this.keyFilePath, (String)this.keyFilePassword, (String)this.keyAlias);
        this.pathsToSign.forEach(this::signFilesAtPath);
        return 0;
    }

    public abstract boolean generateSignatureFile(@NonNull Path var1, @NonNull Path var2, @NonNull KeyPair var3);

    public abstract boolean isFileSupported(@NonNull Path var1);

    private void signFile(@NonNull Path fileToSign) {
        Path signatureFileDestinationPath = this.destinationDirectory == null ? FileSigningUtils.buildSignatureFilePath((Path)fileToSign.getParent(), (Path)fileToSign) : FileSigningUtils.buildSignatureFilePath((Path)this.destinationDirectory, (Path)fileToSign);
        if (Files.exists(signatureFileDestinationPath, new LinkOption[0])) {
            logger.warn(LogMarker.CLI.getMarker(), "Signature file {} already exists. Skipping file {}", (Object)signatureFileDestinationPath, (Object)fileToSign);
            return;
        }
        if (!this.generateSignatureFile(signatureFileDestinationPath, fileToSign, this.keyPair)) {
            return;
        }
        if (this.destinationDirectory == null) {
            return;
        }
        try {
            Files.copy(fileToSign, this.destinationDirectory.resolve(fileToSign.getFileName()), new CopyOption[0]);
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to copy source file {} to destination directory {}", (Object)fileToSign.getFileName(), (Object)this.destinationDirectory, (Object)e);
        }
    }

    private void signFilesAtPath(@NonNull Path path) {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.filter(this::isFileSupported).forEach(this::signFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list files: " + String.valueOf(path));
        }
    }
}

