/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.associations;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.associations.AssociationsDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AssociationsTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod HRC_ASSOCIATE = SystemContractMethod.declare("associate()", "(int)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.ASSOCIATION);
    public static final SystemContractMethod ASSOCIATE_ONE = SystemContractMethod.declare("associateToken(address,address)", "(int64)").withCategories(SystemContractMethod.Category.ASSOCIATION);
    public static final SystemContractMethod DISSOCIATE_ONE = SystemContractMethod.declare("dissociateToken(address,address)", "(int64)").withCategories(SystemContractMethod.Category.ASSOCIATION);
    public static final SystemContractMethod HRC_DISSOCIATE = SystemContractMethod.declare("dissociate()", "(int)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.ASSOCIATION);
    public static final SystemContractMethod ASSOCIATE_MANY = SystemContractMethod.declare("associateTokens(address,address[])", "(int64)").withCategories(SystemContractMethod.Category.ASSOCIATION);
    public static final SystemContractMethod DISSOCIATE_MANY = SystemContractMethod.declare("dissociateTokens(address,address[])", "(int64)").withCategories(SystemContractMethod.Category.ASSOCIATION);
    private final AssociationsDecoder decoder;

    @Inject
    public AssociationsTranslator(@NonNull AssociationsDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(ASSOCIATE_ONE, ASSOCIATE_MANY, DISSOCIATE_ONE, DISSOCIATE_MANY, HRC_ASSOCIATE, HRC_DISSOCIATE);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isRedirect() ? attempt.isMethod(HRC_ASSOCIATE, HRC_DISSOCIATE) : attempt.isMethod(ASSOCIATE_ONE, ASSOCIATE_MANY, DISSOCIATE_ONE, DISSOCIATE_MANY);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new DispatchForResponseCodeHtsCall(attempt, attempt.isSelector(HRC_ASSOCIATE, HRC_DISSOCIATE) ? this.bodyForHrc(attempt) : this.bodyForClassic(attempt), AssociationsTranslator::gasRequirement);
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.ASSOCIATE, payerId);
    }

    private TransactionBody bodyForHrc(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(HRC_ASSOCIATE)) {
            return this.decoder.decodeHrcAssociate(attempt);
        }
        return this.decoder.decodeHrcDissociate(attempt);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(ASSOCIATE_ONE)) {
            return this.decoder.decodeAssociateOne(attempt);
        }
        if (attempt.isSelector(ASSOCIATE_MANY)) {
            return this.decoder.decodeAssociateMany(attempt);
        }
        if (attempt.isSelector(DISSOCIATE_ONE)) {
            return this.decoder.decodeDissociateOne(attempt);
        }
        return this.decoder.decodeDissociateMany(attempt);
    }
}

