/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.cryptography.wraps;

import com.hedera.common.nativesupport.SingletonLoader;
import com.hedera.cryptography.wraps.Proof;
import com.hedera.cryptography.wraps.SchnorrKeys;
import com.hedera.cryptography.wraps.WRAPSVerificationKey;
import java.io.File;
import java.util.Arrays;
import java.util.Set;

public class WRAPSLibraryBridge {
    private static final SingletonLoader<WRAPSLibraryBridge> INSTANCE_HOLDER = new SingletonLoader("wraps", (Object)new WRAPSLibraryBridge());
    private static final long MAX_SUM_OF_WEIGHTS = Long.MAX_VALUE;
    public static final int ENTROPY_SIZE = 32;
    private static final int ROUND1_MESSAGE_SIZE = 40;
    private static final int ROUND2_3_MESSAGE_SIZE = 72;
    private static final byte[][] EMPTY_BYTE_ARRAY_2;
    private static final long[] EMPTY_LONG_ARRAY;
    private static final boolean[] EMPTY_BOOLEAN_ARRAY;

    private WRAPSLibraryBridge() {
    }

    public static WRAPSLibraryBridge getInstance() {
        return (WRAPSLibraryBridge)INSTANCE_HOLDER.getInstance();
    }

    public static boolean isProofSupported() {
        String path = System.getenv("TSS_LIB_WRAPS_ARTIFACTS_PATH");
        if (path == null || path.isBlank()) {
            return false;
        }
        if (path.contains("..")) {
            return false;
        }
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        Set<String> files = Set.of(dir.list());
        return files.equals(Set.of("decider_pp.bin", "decider_vp.bin", "nova_pp.bin", "nova_vp.bin"));
    }

    public SchnorrKeys generateSchnorrKeys(byte[] seed) {
        if (seed == null || seed.length != 32) {
            return null;
        }
        return this.generateSchnorrKeysImpl(seed);
    }

    private native SchnorrKeys generateSchnorrKeysImpl(byte[] var1);

    public byte[] runSigningProtocolPhase(SigningProtocolPhase phase, byte[] instanceEntropy, byte[] messageToSign, byte[] schnorrPrivateKey, byte[][] schnorrPublicKeys, long[] weights, long[] nodeIds, boolean[] signers, byte[][] round1Messages, byte[][] round2Messages, byte[][] round3Messages) {
        if (phase == null || messageToSign == null) {
            return null;
        }
        if (schnorrPublicKeys == null) {
            schnorrPublicKeys = EMPTY_BYTE_ARRAY_2;
        }
        if (weights == null) {
            weights = EMPTY_LONG_ARRAY;
        }
        if (nodeIds == null) {
            nodeIds = EMPTY_LONG_ARRAY;
        }
        if (signers == null) {
            signers = EMPTY_BOOLEAN_ARRAY;
        }
        if (round1Messages == null) {
            round1Messages = EMPTY_BYTE_ARRAY_2;
        }
        if (round2Messages == null) {
            round2Messages = EMPTY_BYTE_ARRAY_2;
        }
        if (round3Messages == null) {
            round3Messages = EMPTY_BYTE_ARRAY_2;
        }
        if (phase != SigningProtocolPhase.Aggregate && (schnorrPrivateKey == null || instanceEntropy == null || instanceEntropy.length != 32)) {
            return null;
        }
        int numOfActualSigners = 0;
        for (boolean signer : signers) {
            if (!signer) continue;
            ++numOfActualSigners;
        }
        if (schnorrPublicKeys.length != 0 && numOfActualSigners > schnorrPublicKeys.length) {
            return null;
        }
        if (phase == SigningProtocolPhase.R1) {
            if (!(Arrays.equals((Object[])schnorrPublicKeys, (Object[])EMPTY_BYTE_ARRAY_2) && Arrays.equals((Object[])round1Messages, (Object[])EMPTY_BYTE_ARRAY_2) && Arrays.equals((Object[])round2Messages, (Object[])EMPTY_BYTE_ARRAY_2) && Arrays.equals((Object[])round3Messages, (Object[])EMPTY_BYTE_ARRAY_2))) {
                return null;
            }
        } else if (phase == SigningProtocolPhase.R2) {
            if (!(WRAPSLibraryBridge.validateRoundMessages(round1Messages, 40) && Arrays.equals((Object[])round2Messages, (Object[])EMPTY_BYTE_ARRAY_2) && Arrays.equals((Object[])round3Messages, (Object[])EMPTY_BYTE_ARRAY_2))) {
                return null;
            }
            if (schnorrPublicKeys.length == 0 || numOfActualSigners != round1Messages.length || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys) || weights.length != schnorrPublicKeys.length || nodeIds.length != schnorrPublicKeys.length || signers.length != schnorrPublicKeys.length) {
                return null;
            }
        } else if (phase == SigningProtocolPhase.R3) {
            if (!(WRAPSLibraryBridge.validateRoundMessages(round1Messages, 40) && WRAPSLibraryBridge.validateRoundMessages(round2Messages, 72) && Arrays.equals((Object[])round3Messages, (Object[])EMPTY_BYTE_ARRAY_2))) {
                return null;
            }
            if (schnorrPublicKeys.length == 0 || numOfActualSigners != round1Messages.length || numOfActualSigners != round2Messages.length || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys) || weights.length != schnorrPublicKeys.length || nodeIds.length != schnorrPublicKeys.length || signers.length != schnorrPublicKeys.length) {
                return null;
            }
        } else if (phase == SigningProtocolPhase.Aggregate) {
            if (schnorrPrivateKey != null || instanceEntropy != null) {
                return null;
            }
            if (!(WRAPSLibraryBridge.validateRoundMessages(round1Messages, 40) && WRAPSLibraryBridge.validateRoundMessages(round2Messages, 72) && WRAPSLibraryBridge.validateRoundMessages(round3Messages, 72))) {
                return null;
            }
            if (schnorrPublicKeys.length == 0 || numOfActualSigners != round1Messages.length || numOfActualSigners != round2Messages.length || numOfActualSigners != round3Messages.length || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys) || weights.length != schnorrPublicKeys.length || nodeIds.length != schnorrPublicKeys.length || signers.length != schnorrPublicKeys.length) {
                return null;
            }
        } else {
            throw new IllegalArgumentException("Unknown phase: " + String.valueOf((Object)phase));
        }
        return this.runSigningProtocolPhaseImpl(phase.ordinal(), instanceEntropy, messageToSign, schnorrPrivateKey, schnorrPublicKeys, weights, nodeIds, signers, round1Messages, round2Messages, round3Messages);
    }

    private native byte[] runSigningProtocolPhaseImpl(int var1, byte[] var2, byte[] var3, byte[] var4, byte[][] var5, long[] var6, long[] var7, boolean[] var8, byte[][] var9, byte[][] var10, byte[][] var11);

    public boolean verifySignature(byte[][] schnorrPublicKeys, long[] weights, long[] nodeIds, byte[] messageToSign, byte[] signature) {
        if (schnorrPublicKeys == null || messageToSign == null || signature == null || schnorrPublicKeys.length == 0 || weights == null || weights.length != schnorrPublicKeys.length || nodeIds == null || nodeIds.length != schnorrPublicKeys.length || messageToSign.length == 0 || signature.length == 0 || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
            return false;
        }
        return this.verifySignatureImpl(schnorrPublicKeys, weights, nodeIds, messageToSign, signature);
    }

    private native boolean verifySignatureImpl(byte[][] var1, long[] var2, long[] var3, byte[] var4, byte[] var5);

    public byte[] hashAddressBook(byte[][] schnorrPublicKeys, long[] weights, long[] nodeIds) {
        if (schnorrPublicKeys == null || weights == null || schnorrPublicKeys.length != weights.length || nodeIds == null || schnorrPublicKeys.length != nodeIds.length || !WRAPSLibraryBridge.validateWeightsSum(weights) || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
            return null;
        }
        return this.hashAddressBookImpl(schnorrPublicKeys, weights, nodeIds);
    }

    private native byte[] hashAddressBookImpl(byte[][] var1, long[] var2, long[] var3);

    public native byte[] hashArray(byte[] var1);

    public byte[] formatRotationMessage(byte[][] schnorrPublicKeys, long[] weights, long[] nodeIds, byte[] hintsVerificationKey) {
        if (schnorrPublicKeys == null || weights == null || schnorrPublicKeys.length != weights.length || nodeIds == null || schnorrPublicKeys.length != nodeIds.length || !WRAPSLibraryBridge.validateWeightsSum(weights) || hintsVerificationKey == null || hintsVerificationKey.length == 0 || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
            return null;
        }
        return this.formatRotationMessageImpl(schnorrPublicKeys, weights, nodeIds, hintsVerificationKey);
    }

    private native byte[] formatRotationMessageImpl(byte[][] var1, long[] var2, long[] var3, byte[] var4);

    public Proof constructWrapsProof(byte[] genesisAddressBookHash, byte[][] prevSchnorrPublicKeys, long[] prevWeights, long[] prevNodeIds, byte[][] nextSchnorrPublicKeys, long[] nextWeights, long[] nextNodeIds, byte[] prevProof, byte[] tssVerificationKey, byte[] aggregateSignature) {
        if (!WRAPSLibraryBridge.isProofSupported()) {
            return null;
        }
        if (!(genesisAddressBookHash != null && genesisAddressBookHash.length != 0 && prevSchnorrPublicKeys != null && prevWeights != null && prevSchnorrPublicKeys.length != 0 && prevSchnorrPublicKeys.length == prevWeights.length && prevNodeIds != null && prevSchnorrPublicKeys.length == prevNodeIds.length && WRAPSLibraryBridge.validateWeightsSum(prevWeights) && nextSchnorrPublicKeys != null && nextWeights != null && nextSchnorrPublicKeys.length != 0 && nextSchnorrPublicKeys.length == nextWeights.length && nextNodeIds != null && nextSchnorrPublicKeys.length == nextNodeIds.length && WRAPSLibraryBridge.validateWeightsSum(nextWeights) && tssVerificationKey != null && tssVerificationKey.length != 0 && aggregateSignature != null && aggregateSignature.length != 0 && WRAPSLibraryBridge.validateSchnorrPublicKeys(prevSchnorrPublicKeys) && WRAPSLibraryBridge.validateSchnorrPublicKeys(nextSchnorrPublicKeys))) {
            return null;
        }
        return this.constructWrapsProofImpl(genesisAddressBookHash, prevSchnorrPublicKeys, prevWeights, prevNodeIds, nextSchnorrPublicKeys, nextWeights, nextNodeIds, prevProof, tssVerificationKey, aggregateSignature);
    }

    private native Proof constructWrapsProofImpl(byte[] var1, byte[][] var2, long[] var3, long[] var4, byte[][] var5, long[] var6, long[] var7, byte[] var8, byte[] var9, byte[] var10);

    public boolean verifyCompressedProof(byte[] compressedProof, byte[] genesisAddressBookHash, byte[] tssVerificationKey) {
        if (genesisAddressBookHash == null || genesisAddressBookHash.length == 0 || tssVerificationKey == null || tssVerificationKey.length == 0 || compressedProof == null || compressedProof.length == 0) {
            return false;
        }
        return this.verifyCompressedProofImpl(compressedProof, genesisAddressBookHash, tssVerificationKey, WRAPSVerificationKey.getCurrentKey());
    }

    private native boolean verifyCompressedProofImpl(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static boolean validateWeightsSum(long[] weights) {
        try {
            long sum = 0L;
            for (int i = 0; i < weights.length; ++i) {
                if (weights[i] < 0L) {
                    return false;
                }
                sum = Math.addExact(sum, weights[i]);
            }
            return sum <= Long.MAX_VALUE;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    private static boolean validateSchnorrPublicKeys(byte[][] schnorrPublicKeys) {
        for (int i = 0; i < schnorrPublicKeys.length; ++i) {
            if (schnorrPublicKeys[i] != null && schnorrPublicKeys[i].length == 192) continue;
            return false;
        }
        return true;
    }

    private static boolean validateRoundMessages(byte[][] roundMessages, int size) {
        for (int i = 0; i < roundMessages.length; ++i) {
            if (roundMessages[i] != null && roundMessages[i].length == size) continue;
            return false;
        }
        return true;
    }

    static {
        WRAPSLibraryBridge.class.getModule().addOpens(INSTANCE_HOLDER.getNativeLibraryPackageName(), SingletonLoader.class.getModule());
        EMPTY_BYTE_ARRAY_2 = new byte[0][];
        EMPTY_LONG_ARRAY = new long[0];
        EMPTY_BOOLEAN_ARRAY = new boolean[0];
    }

    public static enum SigningProtocolPhase {
        R1,
        R2,
        R3,
        Aggregate;

    }
}

