/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.entityid.impl;

import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.entity.EntityCounts;
import com.hedera.node.app.service.entityid.EntityIdService;
import com.hedera.node.app.service.entityid.impl.schemas.V0490EntityIdSchema;
import com.hedera.node.app.service.entityid.impl.schemas.V0590EntityIdSchema;
import com.hedera.node.config.data.HederaConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityIdServiceImpl
extends EntityIdService {
    private static final Logger log = LogManager.getLogger(EntityIdServiceImpl.class);

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        registry.register((Schema)new V0490EntityIdSchema());
        registry.register((Schema)new V0590EntityIdSchema());
    }

    public boolean doGenesisSetup(@NonNull WritableStates writableStates, @NonNull Configuration configuration) {
        Objects.requireNonNull(writableStates);
        Objects.requireNonNull(configuration);
        HederaConfig hederaConfig = (HederaConfig)configuration.getConfigData(HederaConfig.class);
        long entityNum = hederaConfig.firstUserEntity() - 1L;
        log.info("Setting initial entity id to {}", (Object)entityNum);
        writableStates.getSingleton(V0490EntityIdSchema.ENTITY_ID_STATE_ID).put((Object)new EntityNumber(entityNum));
        writableStates.getSingleton(V0590EntityIdSchema.ENTITY_COUNTS_STATE_ID).put((Object)EntityCounts.DEFAULT);
        return true;
    }
}

