/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import java.util.Collection;
import java.util.Optional;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.worldstate.CodeDelegationService;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class EVMWorldUpdater
implements WorldUpdater {
    private final WorldUpdater rootWorldUpdater;
    private final CodeDelegationService codeDelegationService;

    public EVMWorldUpdater(WorldUpdater rootWorldUpdater, GasCalculator gasCalculator) {
        this(rootWorldUpdater, new CodeDelegationService(gasCalculator));
    }

    private EVMWorldUpdater(WorldUpdater rootWorldUpdater, CodeDelegationService codeDelegationService) {
        this.rootWorldUpdater = rootWorldUpdater;
        this.codeDelegationService = codeDelegationService;
    }

    public CodeDelegationService codeDelegationService() {
        return this.codeDelegationService;
    }

    @Override
    public MutableAccount createAccount(Address address, long nonce, Wei balance) {
        return this.codeDelegationService.processMutableAccount(this, this.rootWorldUpdater.createAccount(address, nonce, balance));
    }

    @Override
    public MutableAccount getAccount(Address address) {
        return this.codeDelegationService.processMutableAccount(this, this.rootWorldUpdater.getAccount(address));
    }

    @Override
    public MutableAccount getOrCreate(Address address) {
        return this.codeDelegationService.processMutableAccount(this, this.rootWorldUpdater.getOrCreate(address));
    }

    @Override
    public MutableAccount getOrCreateSenderAccount(Address address) {
        return this.codeDelegationService.processMutableAccount(this, this.rootWorldUpdater.getOrCreateSenderAccount(address));
    }

    @Override
    public MutableAccount getSenderAccount(MessageFrame frame) {
        return this.codeDelegationService.processMutableAccount(this, this.rootWorldUpdater.getSenderAccount(frame));
    }

    @Override
    public void deleteAccount(Address address) {
        this.rootWorldUpdater.deleteAccount(address);
    }

    @Override
    public Collection<? extends Account> getTouchedAccounts() {
        return this.rootWorldUpdater.getTouchedAccounts();
    }

    @Override
    public Collection<Address> getDeletedAccountAddresses() {
        return this.rootWorldUpdater.getDeletedAccountAddresses();
    }

    @Override
    public void revert() {
        this.rootWorldUpdater.revert();
    }

    @Override
    public void commit() {
        this.rootWorldUpdater.commit();
    }

    @Override
    public Optional<WorldUpdater> parentUpdater() {
        return this.rootWorldUpdater.parentUpdater().isPresent() ? Optional.of(new EVMWorldUpdater(this.rootWorldUpdater.parentUpdater().get(), this.codeDelegationService)) : Optional.empty();
    }

    @Override
    public WorldUpdater updater() {
        return new EVMWorldUpdater(this.rootWorldUpdater.updater(), this.codeDelegationService);
    }

    @Override
    public Account get(Address address) {
        return this.codeDelegationService.processAccount(this, this.rootWorldUpdater.get(address));
    }
}

