/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.recordcache;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.recordcache.codec.TransactionRecordEntryJsonCodec;
import com.hedera.hapi.node.state.recordcache.codec.TransactionRecordEntryProtoCodec;
import com.hedera.hapi.node.state.recordcache.schema.TransactionRecordEntrySchema;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class TransactionRecordEntry {
    public static final Codec<TransactionRecordEntry> PROTOBUF = new TransactionRecordEntryProtoCodec();
    public static final JsonCodec<TransactionRecordEntry> JSON = new TransactionRecordEntryJsonCodec();
    public static final TransactionRecordEntry DEFAULT = TransactionRecordEntry.newBuilder().build();
    private final long nodeId;
    @Nullable
    private final AccountID payerAccountId;
    @Nullable
    private final TransactionRecord transactionRecord;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public TransactionRecordEntry(long nodeId, AccountID payerAccountId, TransactionRecord transactionRecord) {
        this.$unknownFields = null;
        this.nodeId = nodeId;
        this.payerAccountId = payerAccountId;
        this.transactionRecord = transactionRecord;
    }

    public TransactionRecordEntry(long nodeId, AccountID payerAccountId, TransactionRecord transactionRecord, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.nodeId = nodeId;
        this.payerAccountId = payerAccountId;
        this.transactionRecord = transactionRecord;
    }

    public long nodeId() {
        return this.nodeId;
    }

    public AccountID payerAccountId() {
        return this.payerAccountId;
    }

    public TransactionRecord transactionRecord() {
        return this.transactionRecord;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TransactionRecordEntrySchema.NODE_ID, (long)this.nodeId, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordEntrySchema.PAYER_ACCOUNT_ID, (Object)this.payerAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordEntrySchema.TRANSACTION_RECORD, (Object)this.transactionRecord, TransactionRecord.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.nodeId != TransactionRecordEntry.DEFAULT.nodeId) {
                result = 31 * result + Long.hashCode(this.nodeId);
            }
            if (this.payerAccountId != null && !this.payerAccountId.equals(TransactionRecordEntry.DEFAULT.payerAccountId)) {
                result = 31 * result + this.payerAccountId.hashCode();
            }
            if (this.transactionRecord != null && !this.transactionRecord.equals(TransactionRecordEntry.DEFAULT.transactionRecord)) {
                result = 31 * result + this.transactionRecord.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionRecordEntry thatObj = (TransactionRecordEntry)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.nodeId != thatObj.nodeId) {
            return false;
        }
        if (this.payerAccountId == null && thatObj.payerAccountId != null) {
            return false;
        }
        if (this.payerAccountId != null && !this.payerAccountId.equals(thatObj.payerAccountId)) {
            return false;
        }
        if (this.transactionRecord == null && thatObj.transactionRecord != null) {
            return false;
        }
        if (this.transactionRecord != null && !this.transactionRecord.equals(thatObj.transactionRecord)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "TransactionRecordEntry[nodeId=" + this.nodeId + ", payerAccountId=" + String.valueOf(this.payerAccountId) + ", transactionRecord=" + String.valueOf(this.transactionRecord) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasPayerAccountId() {
        return this.payerAccountId != null;
    }

    public AccountID payerAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasPayerAccountId() ? this.payerAccountId : defaultValue;
    }

    @NonNull
    public AccountID payerAccountIdOrThrow() {
        return Objects.requireNonNull(this.payerAccountId, "Field payerAccountId is null");
    }

    public void ifPayerAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasPayerAccountId()) {
            ifPresent.accept(this.payerAccountId);
        }
    }

    public boolean hasTransactionRecord() {
        return this.transactionRecord != null;
    }

    public TransactionRecord transactionRecordOrElse(@NonNull TransactionRecord defaultValue) {
        return this.hasTransactionRecord() ? this.transactionRecord : defaultValue;
    }

    @NonNull
    public TransactionRecord transactionRecordOrThrow() {
        return Objects.requireNonNull(this.transactionRecord, "Field transactionRecord is null");
    }

    public void ifTransactionRecord(@NonNull Consumer<TransactionRecord> ifPresent) {
        if (this.hasTransactionRecord()) {
            ifPresent.accept(this.transactionRecord);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.nodeId, this.payerAccountId, this.transactionRecord, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long nodeId = 0L;
        @Nullable
        private AccountID payerAccountId = null;
        @Nullable
        private TransactionRecord transactionRecord = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long nodeId, AccountID payerAccountId, TransactionRecord transactionRecord) {
            this.$unknownFields = null;
            this.nodeId = nodeId;
            this.payerAccountId = payerAccountId;
            this.transactionRecord = transactionRecord;
        }

        public Builder(long nodeId, AccountID payerAccountId, TransactionRecord transactionRecord, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.nodeId = nodeId;
            this.payerAccountId = payerAccountId;
            this.transactionRecord = transactionRecord;
        }

        public TransactionRecordEntry build() {
            return new TransactionRecordEntry(this.nodeId, this.payerAccountId, this.transactionRecord);
        }

        public Builder nodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder payerAccountId(@Nullable AccountID payerAccountId) {
            this.payerAccountId = payerAccountId;
            return this;
        }

        public Builder payerAccountId(AccountID.Builder builder) {
            this.payerAccountId = builder.build();
            return this;
        }

        public Builder transactionRecord(@Nullable TransactionRecord transactionRecord) {
            this.transactionRecord = transactionRecord;
            return this;
        }

        public Builder transactionRecord(TransactionRecord.Builder builder) {
            this.transactionRecord = builder.build();
            return this;
        }

        public long nodeId() {
            return this.nodeId;
        }

        public AccountID payerAccountId() {
            return this.payerAccountId;
        }

        public TransactionRecord transactionRecord() {
            return this.transactionRecord;
        }
    }
}

