/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.gas;

import com.hedera.node.app.service.contract.impl.exec.gas.TinybarValues;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.config.data.CacheConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.CancunGasCalculator;

@Singleton
public class CustomGasCalculator
extends CancunGasCalculator {
    private static final long TX_DATA_ZERO_COST = 4L;
    private static final long ISTANBUL_TX_DATA_NON_ZERO_COST = 16L;
    private static final long TX_BASE_COST = 21000L;
    private static final int LOG_CONTRACT_ID_SIZE = 24;
    private static final int LOG_TOPIC_SIZE = 32;
    private static final int LOG_BLOOM_SIZE = 256;

    @Inject
    public CustomGasCalculator() {
    }

    public long transactionIntrinsicGasCost(Bytes payload, boolean isContractCreate, long baselineCost) {
        int zeros = 0;
        for (int i = 0; i < payload.size(); ++i) {
            if (payload.get(i) != 0) continue;
            ++zeros;
        }
        int nonZeros = payload.size() - zeros;
        long cost = 21000L + 4L * (long)zeros + 16L * (long)nonZeros;
        return isContractCreate ? cost + this.contractCreationCost(payload.size()) : cost;
    }

    public long logOperationGasCost(@NonNull MessageFrame frame, long dataOffset, long dataLength, int numTopics) {
        Objects.requireNonNull(frame);
        long evmGasCost = super.logOperationGasCost(frame, dataOffset, dataLength, numTopics);
        int lifetime = ((CacheConfig)FrameUtils.configOf(frame).getConfigData(CacheConfig.class)).recordsTtl();
        TinybarValues tinybarValues = FrameUtils.tinybarValuesFor(frame);
        long hevmGasCost = CustomGasCalculator.gasCostOfStoring(CustomGasCalculator.logSize(numTopics, dataLength), lifetime, tinybarValues.topLevelTinycentRbhPrice(), tinybarValues.topLevelTinycentGasPrice());
        return Math.max(evmGasCost, hevmGasCost);
    }

    public long getEdSignatureVerificationSystemContractGasCost() {
        return 1500000L;
    }

    private static long gasCostOfStoring(long numBytes, long lifetime, long rbhPrice, long gasPrice) {
        long storagePrice = lifetime * rbhPrice / 3600L;
        return Math.round((double)storagePrice / (double)gasPrice);
    }

    private static long logSize(int numberOfTopics, long dataSize) {
        return 280L + 32L * (long)numberOfTopics + dataSize;
    }
}

