/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNameSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class TypeStash {
    private static final Map<Class<?>, TypeName> CLASS_TYPE_STASH = new HashMap();
    private static final ReadWriteLock CLASS_TYPE_STASH_LOCK = new ReentrantReadWriteLock();
    private static final Map<String, TypeName> TYPE_STASH = new HashMap<String, TypeName>();
    private static final ReadWriteLock TYPE_STASH_LOCK = new ReentrantReadWriteLock();

    private TypeStash() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeName stash(Class<?> clazz) {
        TypeName typeName;
        CLASS_TYPE_STASH_LOCK.readLock().lock();
        try {
            typeName = CLASS_TYPE_STASH.get(clazz);
            if (typeName != null) {
                TypeName typeName2 = typeName;
                return typeName2;
            }
        }
        finally {
            CLASS_TYPE_STASH_LOCK.readLock().unlock();
        }
        CLASS_TYPE_STASH_LOCK.writeLock().lock();
        try {
            typeName = CLASS_TYPE_STASH.get(clazz);
            if (typeName != null) {
                TypeName typeName3 = typeName;
                return typeName3;
            }
            typeName = TypeNameSupport.doCreate(clazz);
            CLASS_TYPE_STASH.put(clazz, typeName);
            TypeName typeName4 = typeName;
            return typeName4;
        }
        finally {
            CLASS_TYPE_STASH_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeName stash(String className) {
        TypeName typeName;
        if (className.indexOf(60) > 0 || className.indexOf(63) > 0 || className.indexOf(46) == -1) {
            return TypeNameSupport.doCreate(className);
        }
        TYPE_STASH_LOCK.readLock().lock();
        try {
            typeName = TYPE_STASH.get(className);
            if (typeName != null) {
                TypeName typeName2 = typeName;
                return typeName2;
            }
        }
        finally {
            TYPE_STASH_LOCK.readLock().unlock();
        }
        TYPE_STASH_LOCK.writeLock().lock();
        try {
            typeName = TYPE_STASH.get(className);
            if (typeName != null) {
                TypeName typeName3 = typeName;
                return typeName3;
            }
            typeName = TypeNameSupport.doCreate(className);
            TYPE_STASH.put(className, typeName);
            TypeName typeName4 = typeName;
            return typeName4;
        }
        finally {
            TYPE_STASH_LOCK.writeLock().unlock();
        }
    }
}

