/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.reconnect.FallenBehindStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class FallenBehindMonitor {
    private final Lock lock = new ReentrantLock();
    private final Condition fallenBehindCondition = this.lock.newCondition();
    private final Condition gossipSyncPausedCondition = this.lock.newCondition();
    private final int peersSize;
    private final Set<NodeId> reportFallenBehind = new HashSet<NodeId>();
    @GuardedBy(value="lock")
    private final double fallenBehindThreshold;
    @GuardedBy(value="lock")
    private boolean isBehind;
    @GuardedBy(value="lock")
    private boolean pausedNotificationReceived;

    public FallenBehindMonitor(@NonNull Roster roster, @NonNull Configuration config, @NonNull Metrics metrics) {
        this(Objects.requireNonNull(roster).rosterEntries().size() - 1, ((ReconnectConfig)Objects.requireNonNull(config).getConfigData(ReconnectConfig.class)).fallenBehindThreshold());
        Objects.requireNonNull(metrics).getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "hasFallenBehind", Object.class, this::hasFallenBehind).withDescription("has this node fallen behind?"));
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "numReportFallenBehind", Integer.class, this::reportedSize).withDescription("the number of nodes that have fallen behind").withUnit("count"));
    }

    @VisibleForTesting
    public FallenBehindMonitor(int peersSize, double fallenBehindThreshold) {
        this.peersSize = peersSize;
        this.fallenBehindThreshold = fallenBehindThreshold;
    }

    private void checkAndNotify() {
        boolean wasNotBehind = !this.isBehind;
        boolean bl = this.isBehind = (double)this.peersSize * this.fallenBehindThreshold < (double)this.reportFallenBehind.size() || this.peersSize > 0 && this.reportFallenBehind.size() == this.peersSize;
        if (wasNotBehind && this.isBehind) {
            this.fallenBehindCondition.signalAll();
        }
    }

    void report(@NonNull NodeId id) {
        this.lock.lock();
        try {
            if (this.reportFallenBehind.add(id)) {
                this.checkAndNotify();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void clear(@NonNull NodeId id) {
        this.lock.lock();
        try {
            this.reportFallenBehind.remove(id);
            this.checkAndNotify();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasFallenBehind() {
        this.lock.lock();
        try {
            boolean bl = this.isBehind;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isBehindPeer(@NonNull NodeId peerId) {
        this.lock.lock();
        try {
            boolean bl = this.reportFallenBehind.contains(peerId);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.reportFallenBehind.clear();
            this.isBehind = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int reportedSize() {
        this.lock.lock();
        try {
            int n = this.reportFallenBehind.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void awaitFallenBehind() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.isBehind) {
                this.fallenBehindCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public FallenBehindStatus check(@NonNull EventWindow self, @NonNull EventWindow other, @NonNull NodeId peer) {
        Objects.requireNonNull(self);
        Objects.requireNonNull(other);
        Objects.requireNonNull(peer);
        FallenBehindStatus status = FallenBehindStatus.getStatus(self, other);
        if (status == FallenBehindStatus.SELF_FALLEN_BEHIND) {
            this.report(peer);
        } else {
            this.clear(peer);
        }
        return status;
    }

    public void notifySyncProtocolPaused() {
        this.lock.lock();
        try {
            this.gossipSyncPausedCondition.signal();
            this.pausedNotificationReceived = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void awaitGossipPaused() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.pausedNotificationReceived) {
                this.gossipSyncPausedCondition.await();
            }
            this.pausedNotificationReceived = false;
        }
        finally {
            this.lock.unlock();
        }
    }
}

