/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history;

import com.hedera.cryptography.rpm.SigningAndVerifyingSchnorrKeys;
import com.hedera.cryptography.wraps.Proof;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hiero.base.utility.CommonUtils;

public interface HistoryLibrary {
    public static final Bytes EMPTY_PUBLIC_KEY = Bytes.wrap((byte[])new byte[32]);

    public static Bytes computeHash(@NonNull HistoryLibrary library, @NonNull Set<Long> nodeIds, @NonNull LongUnaryOperator weightFn, @NonNull LongFunction<Bytes> proofKeyFn) {
        Objects.requireNonNull(nodeIds);
        Objects.requireNonNull(weightFn);
        Objects.requireNonNull(proofKeyFn);
        long[] sortedNodeIds = nodeIds.stream().sorted().mapToLong(Long::longValue).toArray();
        long[] targetWeights = Arrays.stream(sortedNodeIds).map(weightFn).toArray();
        byte[][] proofKeysArray = (byte[][])Arrays.stream(sortedNodeIds).mapToObj(proofKeyFn).map(Bytes::toByteArray).toArray(x$0 -> new byte[x$0][]);
        return Bytes.wrap((byte[])library.hashAddressBook(new AddressBook(targetWeights, proofKeysArray, sortedNodeIds)));
    }

    public SigningAndVerifyingSchnorrKeys newSchnorrKeyPair();

    public byte[] hashAddressBook(@NonNull AddressBook var1);

    public byte[] computeWrapsMessage(AddressBook var1, byte[] var2);

    public byte[] runWrapsPhaseR1(@NonNull byte[] var1, @NonNull byte[] var2, @NonNull byte[] var3);

    public byte[] runWrapsPhaseR2(@NonNull byte[] var1, @NonNull byte[] var2, @NonNull byte[][] var3, @NonNull byte[] var4, @NonNull byte[][] var5);

    public byte[] runWrapsPhaseR3(@NonNull byte[] var1, @NonNull byte[] var2, @NonNull byte[][] var3, @NonNull byte[][] var4, @NonNull byte[] var5, @NonNull byte[][] var6);

    public byte[] runAggregationPhase(@NonNull byte[] var1, @NonNull byte[][] var2, @NonNull byte[][] var3, @NonNull byte[][] var4, @NonNull byte[][] var5);

    public boolean verifyAggregateSignature(@NonNull byte[] var1, @NonNull byte[][] var2, @NonNull byte[] var3);

    public Proof constructGenesisWrapsProof(@NonNull byte[] var1, @NonNull byte[] var2, @NonNull Set<Long> var3, @NonNull AddressBook var4);

    public Proof constructIncrementalWrapsProof(@NonNull byte[] var1, @NonNull byte[] var2, @NonNull AddressBook var3, @NonNull AddressBook var4, @NonNull byte[] var5, @NonNull byte[] var6, @NonNull Set<Long> var7);

    public boolean isValidWraps(byte[] var1);

    public record AddressBook(@NonNull long[] weights, @NonNull byte[][] publicKeys, @NonNull long[] nodeIds) {
        public AddressBook {
            Objects.requireNonNull(weights);
            Objects.requireNonNull(publicKeys);
            Objects.requireNonNull(nodeIds);
        }

        public static AddressBook from(@NonNull SortedMap<Long, Long> weights, @NonNull SortedMap<Long, byte[]> publicKeys) {
            Objects.requireNonNull(weights);
            Objects.requireNonNull(publicKeys);
            byte[] emptyPublicKey = EMPTY_PUBLIC_KEY.toByteArray();
            return AddressBook.from(weights, (long nodeId) -> publicKeys.getOrDefault(nodeId, emptyPublicKey));
        }

        public static AddressBook from(@NonNull SortedMap<Long, Long> weights, @NonNull LongFunction<byte[]> publicKeys) {
            Objects.requireNonNull(weights);
            Objects.requireNonNull(publicKeys);
            long[] nodeIds = weights.keySet().stream().mapToLong(Long::longValue).toArray();
            return new AddressBook(Arrays.stream(nodeIds).map(weights::get).toArray(), (byte[][])Arrays.stream(nodeIds).mapToObj(publicKeys).toArray(x$0 -> new byte[x$0][]), nodeIds);
        }

        public boolean[] signersMask(@NonNull Set<Long> signers) {
            boolean[] mask = new boolean[this.nodeIds.length];
            for (int i = 0; i < this.nodeIds.length; ++i) {
                mask[i] = signers.contains(this.nodeIds[i]);
            }
            return mask;
        }

        @Override
        @NonNull
        public String toString() {
            return "AddressBook" + IntStream.range(0, this.nodeIds.length).mapToObj(i -> "(#" + i + " :: weight=" + this.weights[i] + " :: public_key=" + CommonUtils.hex((byte[])this.publicKeys[i]) + ")").collect(Collectors.joining(", ", "[", "]"));
        }
    }
}

