/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.handlers;

import com.hedera.hapi.services.auxiliary.history.HistoryProofKeyPublicationTransactionBody;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.ProofControllers;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class HistoryProofKeyPublicationHandler
implements TransactionHandler {
    private static final Logger log = LogManager.getLogger(HistoryProofKeyPublicationHandler.class);
    private final ProofControllers controllers;

    @Inject
    public HistoryProofKeyPublicationHandler(@NonNull ProofControllers controllers) {
        this.controllers = Objects.requireNonNull(controllers);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        HistoryProofKeyPublicationTransactionBody op = context.body().historyProofKeyPublicationOrThrow();
        WritableHistoryStore historyStore = (WritableHistoryStore)context.storeFactory().writableStore(WritableHistoryStore.class);
        long nodeId = context.creatorInfo().nodeId();
        if (op.hasProofKey()) {
            Bytes key = op.proofKeyOrThrow();
            log.info("node{} published new proof key '{}'", (Object)nodeId, (Object)key);
            if (historyStore.setProofKey(nodeId, key, context.consensusNow())) {
                this.controllers.getAnyInProgress().ifPresent(controller -> {
                    ReadableHistoryStore.ProofKeyPublication publication = new ReadableHistoryStore.ProofKeyPublication(nodeId, key, context.consensusNow());
                    controller.addProofKeyPublication(publication);
                    log.info("  - Added proof key to ongoing construction #{}", (Object)controller.constructionId());
                });
            }
        } else if (op.hasWrapsMessage()) {
            Bytes message = op.wrapsMessageOrThrow();
            log.info("node{} published new WRAPS message '{}'", (Object)nodeId, (Object)message);
            this.controllers.getAnyInProgress().ifPresent(controller -> {
                ReadableHistoryStore.WrapsMessagePublication publication = new ReadableHistoryStore.WrapsMessagePublication(nodeId, message, op.phase(), context.consensusNow());
                if (controller.addWrapsMessagePublication(publication, historyStore, (TssConfig)context.configuration().getConfigData(TssConfig.class))) {
                    historyStore.addWrapsMessage(controller.constructionId(), publication);
                }
            });
        }
    }
}

