/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.cryptography.rpm.SigningAndVerifyingSchnorrKeys;
import com.hedera.cryptography.wraps.Proof;
import com.hedera.cryptography.wraps.SchnorrKeys;
import com.hedera.cryptography.wraps.WRAPSLibraryBridge;
import com.hedera.node.app.history.HistoryLibrary;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import java.util.SplittableRandom;

public class HistoryLibraryImpl
implements HistoryLibrary {
    private static final byte[] DUMMY_HINTS_KEY = new byte[1280];
    public static final SplittableRandom RANDOM = new SplittableRandom();
    public static final WRAPSLibraryBridge WRAPS = WRAPSLibraryBridge.getInstance();

    @Override
    public SigningAndVerifyingSchnorrKeys newSchnorrKeyPair() {
        byte[] seed = new byte[32];
        RANDOM.nextBytes(seed);
        SchnorrKeys wrapsKeys = WRAPS.generateSchnorrKeys(seed);
        return new SigningAndVerifyingSchnorrKeys(wrapsKeys.privateKey(), wrapsKeys.publicKey());
    }

    @Override
    public byte[] hashAddressBook(@NonNull HistoryLibrary.AddressBook addressBook) {
        Objects.requireNonNull(addressBook);
        return WRAPS.hashAddressBook(addressBook.publicKeys(), addressBook.weights());
    }

    @Override
    public byte[] computeWrapsMessage(@NonNull HistoryLibrary.AddressBook addressBook, @NonNull byte[] hintsVerificationKey) {
        Objects.requireNonNull(addressBook);
        Objects.requireNonNull(hintsVerificationKey);
        return WRAPS.formatRotationMessage(addressBook.publicKeys(), addressBook.weights(), hintsVerificationKey);
    }

    @Override
    public byte[] runWrapsPhaseR1(@NonNull byte[] entropy, @NonNull byte[] message, @NonNull byte[] privateKey) {
        Objects.requireNonNull(entropy);
        Objects.requireNonNull(message);
        Objects.requireNonNull(privateKey);
        return WRAPS.runSigningProtocolPhase(WRAPSLibraryBridge.SigningProtocolPhase.R1, entropy, message, privateKey, (byte[][])new byte[0][], (byte[][])new byte[0][], (byte[][])new byte[0][], (byte[][])new byte[0][]);
    }

    @Override
    public byte[] runWrapsPhaseR2(@NonNull byte[] entropy, @NonNull byte[] message, @NonNull byte[][] r1Messages, @NonNull byte[] privateKey, @NonNull byte[][] publicKeys) {
        Objects.requireNonNull(entropy);
        Objects.requireNonNull(message);
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(r1Messages);
        Objects.requireNonNull(publicKeys);
        return WRAPS.runSigningProtocolPhase(WRAPSLibraryBridge.SigningProtocolPhase.R2, entropy, message, privateKey, publicKeys, r1Messages, (byte[][])new byte[0][], (byte[][])new byte[0][]);
    }

    @Override
    public byte[] runWrapsPhaseR3(@NonNull byte[] entropy, @NonNull byte[] message, @NonNull byte[][] r1Messages, @NonNull byte[][] r2Messages, @NonNull byte[] privateKey, @NonNull byte[][] publicKeys) {
        Objects.requireNonNull(entropy);
        Objects.requireNonNull(message);
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(r1Messages);
        Objects.requireNonNull(r2Messages);
        Objects.requireNonNull(publicKeys);
        return WRAPS.runSigningProtocolPhase(WRAPSLibraryBridge.SigningProtocolPhase.R3, entropy, message, privateKey, publicKeys, r1Messages, r2Messages, (byte[][])new byte[0][]);
    }

    @Override
    public byte[] runAggregationPhase(@NonNull byte[] message, @NonNull byte[][] r1Messages, @NonNull byte[][] r2Messages, @NonNull byte[][] r3Messages, @NonNull byte[][] publicKeys) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(r1Messages);
        Objects.requireNonNull(r2Messages);
        Objects.requireNonNull(r3Messages);
        Objects.requireNonNull(publicKeys);
        return WRAPS.runSigningProtocolPhase(WRAPSLibraryBridge.SigningProtocolPhase.Aggregate, null, message, null, publicKeys, r1Messages, r2Messages, r3Messages);
    }

    @Override
    public boolean verifyAggregateSignature(@NonNull byte[] message, @NonNull byte[][] publicKeys, @NonNull byte[] signature) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(publicKeys);
        Objects.requireNonNull(signature);
        return WRAPS.verifySignature(publicKeys, message, signature);
    }

    @Override
    public Proof constructGenesisWrapsProof(@NonNull byte[] genesisAddressBookHash, @NonNull byte[] aggregatedSignature, @NonNull Set<Long> signers, @NonNull HistoryLibrary.AddressBook addressBook) {
        Objects.requireNonNull(genesisAddressBookHash);
        Objects.requireNonNull(aggregatedSignature);
        Objects.requireNonNull(signers);
        Objects.requireNonNull(addressBook);
        return WRAPS.constructWrapsProof(genesisAddressBookHash, addressBook.publicKeys(), addressBook.weights(), addressBook.publicKeys(), addressBook.weights(), null, DUMMY_HINTS_KEY, aggregatedSignature, addressBook.signersMask(signers));
    }

    @Override
    public Proof constructIncrementalWrapsProof(@NonNull byte[] genesisAddressBookHash, @NonNull byte[] sourceProof, @NonNull HistoryLibrary.AddressBook sourceAddressBook, @NonNull HistoryLibrary.AddressBook targetAddressBook, @NonNull byte[] targetHintsVerificationKey, @NonNull byte[] aggregatedSignature, @NonNull Set<Long> signers) {
        Objects.requireNonNull(genesisAddressBookHash);
        Objects.requireNonNull(sourceProof);
        Objects.requireNonNull(sourceAddressBook);
        Objects.requireNonNull(targetAddressBook);
        Objects.requireNonNull(targetHintsVerificationKey);
        Objects.requireNonNull(aggregatedSignature);
        Objects.requireNonNull(signers);
        return WRAPS.constructWrapsProof(genesisAddressBookHash, sourceAddressBook.publicKeys(), sourceAddressBook.weights(), targetAddressBook.publicKeys(), targetAddressBook.weights(), sourceProof, targetHintsVerificationKey, aggregatedSignature, sourceAddressBook.signersMask(signers));
    }

    @Override
    public boolean isValidWraps(@NonNull byte[] compressedProof) {
        Objects.requireNonNull(compressedProof);
        return WRAPS.verifyCompressedProof(compressedProof);
    }
}

