/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.ProofKey;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.HistorySubmissions;
import com.hedera.node.app.history.impl.ProofKeysAccessorImpl;
import com.hedera.node.app.service.roster.impl.RosterTransitionWeights;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public interface HistoryProver {
    public static final Comparator<ProofKey> PROOF_KEY_COMPARATOR = Comparator.comparingLong(ProofKey::nodeId);

    @NonNull
    public Outcome advance(@NonNull Instant var1, @NonNull HistoryProofConstruction var2, @NonNull Bytes var3, @NonNull Map<Long, Bytes> var4, @NonNull TssConfig var5, @Nullable Bytes var6);

    public boolean cancelPendingWork();

    public boolean addWrapsSigningMessage(long var1, @NonNull ReadableHistoryStore.WrapsMessagePublication var3, @NonNull WritableHistoryStore var4, @NonNull TssConfig var5);

    default public void replayWrapsSigningMessage(long constructionId, @NonNull ReadableHistoryStore.WrapsMessagePublication publication) {
        Objects.requireNonNull(publication);
    }

    default public List<ProofKey> proofKeyListFrom(@NonNull Map<Long, Bytes> proofKeys) {
        return proofKeys.entrySet().stream().map(entry -> new ProofKey(((Long)entry.getKey()).longValue(), (Bytes)entry.getValue())).sorted(PROOF_KEY_COMPARATOR).toList();
    }

    public static sealed interface Outcome {

        public record Failed(@NonNull String reason) implements Outcome
        {
        }

        public record Completed(@NonNull HistoryProof proof) implements Outcome
        {
        }

        public static final class InProgress
        implements Outcome {
            public static final InProgress INSTANCE = new InProgress();

            private InProgress() {
            }
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public HistoryProver create(long var1, @NonNull ProofKeysAccessorImpl.SchnorrKeyPair var3, @Nullable HistoryProof var4, @NonNull RosterTransitionWeights var5, @NonNull Map<Long, Bytes> var6, @NonNull Executor var7, @NonNull HistoryLibrary var8, @NonNull HistorySubmissions var9);
    }
}

