/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.WrapsPhase;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.services.auxiliary.history.HistoryProofKeyPublicationTransactionBody;
import com.hedera.hapi.services.auxiliary.history.HistoryProofVoteTransactionBody;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.tss.TssSubmissions;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class HistorySubmissions
extends TssSubmissions {
    private static final Logger logger = LogManager.getLogger(HistorySubmissions.class);
    private final BiConsumer<TransactionBody, String> onFailure = (body, reason) -> logger.warn("Failed to submit {} ({})", body, reason);

    @Inject
    public HistorySubmissions(@NonNull Executor executor, @NonNull AppContext appContext) {
        super(executor, appContext);
    }

    public CompletableFuture<Void> submitProofKeyPublication(@NonNull Bytes proofKey) {
        Objects.requireNonNull(proofKey);
        return this.submitIfActive(b -> b.historyProofKeyPublication(HistoryProofKeyPublicationTransactionBody.newBuilder().proofKey(proofKey).phase(WrapsPhase.R1).build()), this.onFailure);
    }

    public CompletableFuture<Void> submitWrapsSigningMessage(@NonNull WrapsPhase phase, @NonNull Bytes message, long constructionId) {
        Objects.requireNonNull(phase);
        Objects.requireNonNull(message);
        logger.info("Submitting WRAPS {} message for construction #{}", (Object)phase, (Object)constructionId);
        return this.submitIfActive(b -> b.historyProofKeyPublication(HistoryProofKeyPublicationTransactionBody.newBuilder().phase(phase).wrapsMessage(message).constructionId(constructionId).build()), this.onFailure);
    }

    public CompletableFuture<Void> submitProofVote(long constructionId, @NonNull HistoryProof proof) {
        Objects.requireNonNull(proof);
        logger.info("Submitting proof vote for construction #{}", (Object)constructionId);
        HistoryProofVote vote = HistoryProofVote.newBuilder().proof(proof).build();
        return this.submitIfActive(b -> b.historyProofVote(new HistoryProofVoteTransactionBody(constructionId, vote)), this.onFailure);
    }
}

