/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats.v6;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.hapi.streams.TransactionSidecarRecord;
import com.hedera.hapi.streams.schema.RecordStreamFileSchema;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.records.impl.producers.BlockRecordWriter;
import com.hedera.node.app.records.impl.producers.SerializedSingleTransactionRecord;
import com.hedera.node.app.records.impl.producers.formats.v6.SidecarWriterV6;
import com.hedera.node.app.records.impl.producers.formats.v6.SignatureWriterV6;
import com.hedera.node.config.data.BlockRecordStreamConfig;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.common.stream.LinkedObjectStreamUtilities;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.HashingOutputStream;
import org.hiero.base.crypto.Signer;

public final class BlockRecordWriterV6
implements BlockRecordWriter {
    private static final Logger logger = LogManager.getLogger(BlockRecordWriterV6.class);
    public static final String RECORD_EXTENSION = "rcd";
    public static final String COMPRESSION_ALGORITHM_EXTENSION = ".gz";
    private final Signer signer;
    private final int maxSideCarSizeInBytes;
    private final Path nodeScopedRecordDir;
    private final Path nodeScopedSidecarDir;
    private long blockNumber;
    private HashObject startObjectRunningHash;
    private Instant startConsensusTime;
    private SemanticVersion hapiProtoVersion;
    private List<SidecarMetadata> sidecarMetadata;
    private SidecarWriterV6 sidecarFileWriter;
    private Path recordFilePath;
    private OutputStream fileOutputStream;
    private GZIPOutputStream gzipOutputStream = null;
    private HashingOutputStream hashingOutputStream;
    private BufferedOutputStream bufferedOutputStream;
    private WritableStreamingData outputStream;
    private State state;

    public BlockRecordWriterV6(@NonNull BlockRecordStreamConfig config, @NonNull AccountID nodeAccountId, @NonNull Signer signer, @NonNull FileSystem fileSystem) {
        if (config.recordFileVersion() != 6) {
            logger.fatal("Bad configuration: BlockRecordWriterV6 used with record file version {}", (Object)config.recordFileVersion());
            throw new IllegalArgumentException("Configuration record file version is not 6!");
        }
        if (config.signatureFileVersion() != 6) {
            logger.fatal("Bad configuration: BlockRecordWriterV6 used with signature file version {}", (Object)config.recordFileVersion());
            throw new IllegalArgumentException("Configuration signature file version is not 6!");
        }
        Objects.requireNonNull(nodeAccountId, "Node account id should not be null");
        this.state = State.UNINITIALIZED;
        this.signer = Objects.requireNonNull(signer);
        this.maxSideCarSizeInBytes = config.sidecarMaxSizeMb() * 1024 * 1024;
        Path recordDir = fileSystem.getPath(config.logDir(), new String[0]);
        this.nodeScopedRecordDir = recordDir.resolve("record" + HapiUtils.asAccountString((AccountID)nodeAccountId));
        this.nodeScopedSidecarDir = this.nodeScopedRecordDir.resolve(config.sidecarDir());
        try {
            Files.createDirectories(this.nodeScopedRecordDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.fatal("Could not create record directory {}", (Object)this.nodeScopedRecordDir, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void init(@NonNull SemanticVersion hapiProtoVersion, @NonNull HashObject startRunningHash, @NonNull Instant startConsensusTime, long blockNumber) {
        if (this.state != State.UNINITIALIZED) {
            throw new IllegalStateException("Cannot initialize a BlockRecordWriterV6 twice");
        }
        this.startObjectRunningHash = Objects.requireNonNull(startRunningHash);
        this.startConsensusTime = Objects.requireNonNull(startConsensusTime);
        this.hapiProtoVersion = Objects.requireNonNull(hapiProtoVersion);
        this.blockNumber = blockNumber;
        if (blockNumber < 0L) {
            throw new IllegalArgumentException("Block number must be non-negative");
        }
        this.recordFilePath = this.getRecordFilePath(startConsensusTime);
        try {
            this.fileOutputStream = Files.newOutputStream(this.recordFilePath, new OpenOption[0]);
            this.gzipOutputStream = new GZIPOutputStream(this.fileOutputStream);
            this.hashingOutputStream = new HashingOutputStream(this.createWholeFileMessageDigest(), (OutputStream)this.gzipOutputStream);
            this.bufferedOutputStream = new BufferedOutputStream((OutputStream)this.hashingOutputStream);
            this.outputStream = new WritableStreamingData((OutputStream)this.bufferedOutputStream);
            this.writeHeader(hapiProtoVersion);
            this.state = State.OPEN;
        }
        catch (IOException e) {
            logger.warn("Error initializing record file {}", (Object)this.recordFilePath, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeItem(@NonNull SerializedSingleTransactionRecord rec) {
        if (this.state != State.OPEN) {
            throw new IllegalStateException("Cannot write to a BlockRecordWriterV6 that is not open");
        }
        Bytes itemBytes = rec.protobufSerializedRecordStreamItem();
        this.outputStream.writeVarInt(RecordStreamFileSchema.RECORD_STREAM_ITEMS.number() << 3 | 2, false);
        this.outputStream.writeVarInt((int)itemBytes.length(), false);
        this.outputStream.writeBytes((RandomAccessData)itemBytes);
        this.handleSidecarItems(rec);
    }

    @Override
    public void close(@NonNull HashObject endRunningHash) {
        if (this.state != State.OPEN) {
            throw new IllegalStateException("Cannot close a BlockRecordWriterV6 that is not open");
        }
        try {
            this.bufferedOutputStream.flush();
            if (this.gzipOutputStream != null) {
                this.gzipOutputStream.flush();
            }
            this.fileOutputStream.flush();
            this.closeSidecarFileWriter();
            this.writeFooter(endRunningHash);
            this.outputStream.close();
            this.bufferedOutputStream.close();
            if (this.gzipOutputStream != null) {
                this.gzipOutputStream.close();
            }
            this.fileOutputStream.close();
            SignatureWriterV6.writeSignatureFile(this.recordFilePath, Bytes.wrap((byte[])this.hashingOutputStream.getDigest()), this.signer, true, 6, this.hapiProtoVersion, this.blockNumber, this.startObjectRunningHash.hash(), endRunningHash.hash());
            this.state = State.CLOSED;
        }
        catch (IOException e) {
            logger.warn("Error closing record file {}", (Object)this.recordFilePath, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    private void writeHeader(@NonNull SemanticVersion hapiProtoVersion) throws UncheckedIOException {
        try {
            this.outputStream.writeInt(6);
            ProtoWriterTools.writeMessage((WritableSequentialData)this.outputStream, (FieldDefinition)RecordStreamFileSchema.HAPI_PROTO_VERSION, (Object)hapiProtoVersion, (Codec)SemanticVersion.PROTOBUF);
            ProtoWriterTools.writeMessage((WritableSequentialData)this.outputStream, (FieldDefinition)RecordStreamFileSchema.START_OBJECT_RUNNING_HASH, (Object)this.startObjectRunningHash, (Codec)HashObject.PROTOBUF);
        }
        catch (IOException e) {
            logger.warn("Error writing header to record file {}", (Object)this.recordFilePath, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    private void writeFooter(@NonNull HashObject endRunningHash) throws UncheckedIOException {
        try {
            ProtoWriterTools.writeMessage((WritableSequentialData)this.outputStream, (FieldDefinition)RecordStreamFileSchema.END_OBJECT_RUNNING_HASH, (Object)endRunningHash, (Codec)HashObject.PROTOBUF);
            ProtoWriterTools.writeLong((WritableSequentialData)this.outputStream, (FieldDefinition)RecordStreamFileSchema.BLOCK_NUMBER, (long)this.blockNumber);
            ProtoWriterTools.writeMessageList((WritableSequentialData)this.outputStream, (FieldDefinition)RecordStreamFileSchema.SIDECARS, this.sidecarMetadata == null ? Collections.emptyList() : this.sidecarMetadata, (Codec)SidecarMetadata.PROTOBUF);
        }
        catch (IOException e) {
            logger.warn("Error writing footer to record file {}", (Object)this.recordFilePath, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    private void handleSidecarItems(@NonNull SerializedSingleTransactionRecord rec) {
        try {
            List<Bytes> sideCarItemsBytesList = rec.sideCarItemsBytes();
            int numOfSidecarItems = sideCarItemsBytesList.size();
            for (int i = 0; i < numOfSidecarItems; ++i) {
                boolean wasWritten;
                Bytes sidecarRecordBytes = sideCarItemsBytesList.get(i);
                TransactionSidecarRecord sideCarItem = rec.sideCarItems().get(i);
                TransactionSidecarRecord.SidecarRecordsOneOfType kind = (TransactionSidecarRecord.SidecarRecordsOneOfType)sideCarItem.sidecarRecords().kind();
                if (this.sidecarFileWriter == null) {
                    this.sidecarFileWriter = this.createSidecarFileWriter(1);
                }
                if (wasWritten = this.sidecarFileWriter.writeTransactionSidecarRecord(kind, sidecarRecordBytes)) continue;
                this.closeSidecarFileWriter();
                this.sidecarFileWriter = this.createSidecarFileWriter(this.sidecarFileWriter.id() + 1);
                if (this.sidecarFileWriter.writeTransactionSidecarRecord(kind, sidecarRecordBytes)) continue;
                logger.warn("Sidecar file is too large and cannot be written. Sidecar size: {} bytes", (Object)sidecarRecordBytes.length());
            }
        }
        catch (IOException e) {
            logger.warn("Error writing sidecar file", (Throwable)e);
        }
    }

    @NonNull
    private SidecarWriterV6 createSidecarFileWriter(int id) throws IOException {
        return new SidecarWriterV6(this.getSidecarFilePath(id), this.maxSideCarSizeInBytes, id);
    }

    private void closeSidecarFileWriter() {
        try {
            if (this.sidecarFileWriter != null) {
                this.sidecarFileWriter.close();
                Bytes sidecarHash = this.sidecarFileWriter.fileHash();
                if (this.sidecarMetadata == null) {
                    this.sidecarMetadata = new ArrayList<SidecarMetadata>();
                }
                this.sidecarMetadata.add(new SidecarMetadata(new HashObject(HashAlgorithm.SHA_384, (int)sidecarHash.length(), sidecarHash), this.sidecarFileWriter.id(), this.sidecarFileWriter.types()));
                this.writeSidecarMarkerFile();
            }
        }
        catch (IOException e) {
            logger.warn("Error closing sidecar file", (Throwable)e);
        }
    }

    private void writeSidecarMarkerFile() throws IOException {
        Path sidecarPath = this.getSidecarFilePath(this.sidecarFileWriter.id());
        Path markerPath = sidecarPath.resolveSibling(sidecarPath.getFileName().toString().replace(".rcd.gz", ".mf"));
        if (Files.exists(markerPath, new LinkOption[0])) {
            logger.debug("Side\u2011car marker already exists: {}", (Object)markerPath);
        } else {
            Files.createFile(markerPath, new FileAttribute[0]);
        }
    }

    @NonNull
    private Path getRecordFilePath(Instant consensusTime) {
        return this.nodeScopedRecordDir.resolve(LinkedObjectStreamUtilities.convertInstantToStringWithPadding((Instant)consensusTime) + ".rcd.gz");
    }

    @NonNull
    private Path getSidecarFilePath(int sidecarId) {
        return this.nodeScopedSidecarDir.resolve(LinkedObjectStreamUtilities.convertInstantToStringWithPadding((Instant)this.startConsensusTime) + "_" + String.format("%02d", sidecarId) + ".rcd.gz");
    }

    @NonNull
    private MessageDigest createWholeFileMessageDigest() {
        try {
            return MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            logger.fatal("Unable to create message digest", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static enum State {
        UNINITIALIZED,
        OPEN,
        CLOSED;

    }
}

