/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.GenericType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.QualifiedInstanceImpl;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class Service {
    private Service() {
    }

    @Contract
    public static interface ScopeHandler {
        public static final TypeName TYPE = TypeName.create(ScopeHandler.class);

        public Optional<io.helidon.service.registry.Scope> currentScope();

        default public void activate(io.helidon.service.registry.Scope scope) {
            scope.registry().activate();
        }

        default public void deactivate(io.helidon.service.registry.Scope scope) {
            scope.registry().deactivate();
        }
    }

    public static interface QualifiedInstance<T>
    extends Supplier<T> {
        public static <T> QualifiedInstance<T> create(T instance, io.helidon.service.registry.Qualifier ... qualifiers) {
            return new QualifiedInstanceImpl<T>(instance, Set.of(qualifiers));
        }

        public static <T> QualifiedInstance<T> create(T instance, Set<io.helidon.service.registry.Qualifier> qualifiers) {
            return new QualifiedInstanceImpl<T>(instance, qualifiers);
        }

        @Override
        public T get();

        public Set<io.helidon.service.registry.Qualifier> qualifiers();
    }

    public static interface QualifiedFactory<T, A extends Annotation> {
        public static final TypeName TYPE = TypeName.create(QualifiedFactory.class);

        public Optional<QualifiedInstance<T>> first(io.helidon.service.registry.Qualifier var1, Lookup var2, GenericType<T> var3);

        default public List<QualifiedInstance<T>> list(io.helidon.service.registry.Qualifier qualifier, Lookup lookup, GenericType<T> type) {
            return this.first(qualifier, lookup, type).map(List::of).orElseGet(List::of);
        }
    }

    public static interface InjectionPointFactory<T> {
        public static final TypeName TYPE = TypeName.create(InjectionPointFactory.class);

        public Optional<QualifiedInstance<T>> first(Lookup var1);

        default public List<QualifiedInstance<T>> list(Lookup lookup) {
            return this.first(lookup).map(List::of).orElseGet(List::of);
        }
    }

    public static interface ServicesFactory<T> {
        public static final TypeName TYPE = TypeName.create(ServicesFactory.class);

        public List<QualifiedInstance<T>> services();
    }

    @Deprecated
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
    public static @interface EntryPoint {
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface GenerateBinding {
        public String value() default "ApplicationBinding";

        public String packageName() default "@default";
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE})
    public static @interface Descriptor {
        public static final TypeName TYPE = TypeName.create(Descriptor.class);

        public double weight() default 100.0;

        public Class<?>[] contracts();
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface Describe {
        public Class<? extends Annotation> value() default Singleton.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface ExternalContracts {
        public Class<?>[] value();
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface Contract {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.PARAMETER, ElementType.FIELD})
    @Qualifier
    public static @interface InstanceName {
        public static final TypeName TYPE = TypeName.create(InstanceName.class);
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface PerInstance {
        public Class<?> value();
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface RunLevel {
        public static final double STARTUP = 10.0;
        public static final double SERVER = 50.0;
        public static final double NORMAL = 100.0;

        public double value() default 100.0;
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface NamedByType {
        public static final TypeName TYPE = TypeName.create(NamedByType.class);

        public Class<?> value();
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD, ElementType.TYPE})
    public static @interface Named {
        public static final TypeName TYPE = TypeName.create(Named.class);
        public static final String WILDCARD_NAME = "*";
        public static final String DEFAULT_NAME = "@default";

        public String value();
    }

    @Target(value={ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Qualifier {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.METHOD})
    public static @interface PreDestroy {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.METHOD})
    public static @interface PostConstruct {
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD})
    @Documented
    public static @interface Inject {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE})
    @Scope
    public static @interface PerLookup {
        public static final TypeName TYPE = TypeName.create(PerLookup.class);
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE, ElementType.METHOD})
    @Scope
    public static @interface PerRequest {
        public static final TypeName TYPE = TypeName.create(PerRequest.class);
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Scope
    public static @interface Singleton {
        public static final TypeName TYPE = TypeName.create(Singleton.class);
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.ANNOTATION_TYPE})
    @Inherited
    public static @interface Scope {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Inherited
    @Deprecated(forRemoval=true, since="4.2.0")
    public static @interface Provider {
        public static final TypeName TYPE = TypeName.create(Provider.class);
    }
}

