/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files.hashmap;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.files.hashmap.Bucket;
import com.swirlds.merkledb.files.hashmap.ReusableBucketPool;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ParsedBucket
extends Bucket {
    private static final Logger logger = LogManager.getLogger(ParsedBucket.class);
    private int bucketIndex = 0;
    private final List<BucketEntry> entries = new ArrayList<BucketEntry>(64);

    public ParsedBucket() {
        this(null);
    }

    ParsedBucket(ReusableBucketPool bucketPool) {
        super(bucketPool);
    }

    @Override
    public void clear() {
        this.bucketIndex = 0;
        if (this.entries != null) {
            this.entries.clear();
        }
    }

    @Override
    public int getBucketIndex() {
        return this.bucketIndex;
    }

    @Override
    public void setBucketIndex(int index) {
        this.bucketIndex = index;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int getBucketEntryCount() {
        return this.entries.size();
    }

    @Override
    public int sizeInBytes() {
        int size = 0;
        size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_BUCKET_INDEX, (ProtoConstants)ProtoConstants.WIRE_TYPE_FIXED_32_BIT) + 4;
        for (BucketEntry entry : this.entries) {
            size += ProtoWriterTools.sizeOfDelimited((FieldDefinition)FIELD_BUCKET_ENTRIES, (int)entry.sizeInBytes());
        }
        return size;
    }

    @Override
    public long findValue(int keyHashCode, Bytes key, long notFoundValue) throws IOException {
        int entryIndex = this.findEntryIndex(keyHashCode, key);
        if (entryIndex >= 0) {
            return this.entries.get(entryIndex).getValue();
        }
        return notFoundValue;
    }

    @Override
    public boolean putValue(Bytes keyBytes, int keyHashCode, long oldValue, long value) {
        boolean needCheckOldValue = oldValue != Long.MIN_VALUE;
        try {
            int entryIndex = this.findEntryIndex(keyHashCode, keyBytes);
            if (value == Long.MIN_VALUE) {
                if (entryIndex >= 0) {
                    BucketEntry entry = this.entries.get(entryIndex);
                    if (needCheckOldValue && oldValue != entry.getValue()) {
                        return false;
                    }
                    this.entries.remove(entryIndex);
                    return true;
                }
                return false;
            }
            if (entryIndex >= 0) {
                BucketEntry entry = this.entries.get(entryIndex);
                if (needCheckOldValue && oldValue != entry.getValue()) {
                    return false;
                }
                long entryOldValue = entry.getValue();
                entry.setValue(value);
                return value == entryOldValue;
            }
            if (needCheckOldValue) {
                return false;
            }
            BucketEntry newEntry = new BucketEntry(keyHashCode, value, keyBytes);
            this.entries.add(newEntry);
            this.checkLargestBucket();
            return true;
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed putting key={} value={} in a bucket", (Object)keyBytes, (Object)value, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    public void forEachEntry(Consumer<BucketEntry> consumer) {
        this.entries.forEach(consumer);
    }

    @Override
    public void readFrom(ReadableSequentialData in) {
        this.bucketIndex = 0;
        this.entries.clear();
        while (in.hasRemaining()) {
            int tag = in.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum == FIELD_BUCKET_INDEX.number()) {
                this.bucketIndex = in.readInt();
                continue;
            }
            if (fieldNum == FIELD_BUCKET_ENTRIES.number()) {
                int entryBytesSize = in.readVarInt(false);
                long oldLimit = in.limit();
                in.limit(in.position() + (long)entryBytesSize);
                this.entries.add(new BucketEntry(in));
                in.limit(oldLimit);
                continue;
            }
            throw new IllegalArgumentException("Unknown bucket field: " + fieldNum);
        }
        this.checkLargestBucket();
    }

    @Override
    public void writeTo(WritableSequentialData out) {
        ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_BUCKET_INDEX);
        out.writeInt(this.bucketIndex);
        for (BucketEntry entry : this.entries) {
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_BUCKET_ENTRIES);
            out.writeVarInt(entry.sizeInBytes(), false);
            entry.writeTo(out);
        }
    }

    private int findEntryIndex(int keyHashCode, Bytes keyBytes) throws IOException {
        int entryCount = this.entries.size();
        for (int index = 0; index < entryCount; ++index) {
            BucketEntry entry = this.entries.get(index);
            if (keyHashCode != entry.getHashCode() || !entry.getKeyBytes().equals((Object)keyBytes)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public String toString() {
        int entryCount = this.getBucketEntryCount();
        int size = this.sizeInBytes();
        StringBuilder sb = new StringBuilder("ParsedBucket{bucketIndex=" + this.getBucketIndex() + ", entryCount=" + entryCount + ", size=" + size + "\n");
        for (int i = 0; i < entryCount; ++i) {
            BucketEntry entry = this.entries.get(i);
            int hashCode = entry.getHashCode();
            long value = entry.getValue();
            Bytes keyBytes = entry.getKeyBytes();
            sb.append("    ENTRY[" + i + "] value= " + value + " keyHashCode=" + hashCode + " key=" + String.valueOf(keyBytes) + "\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class BucketEntry {
        private final int hashCode;
        private long value;
        private final Bytes keyBytes;

        public BucketEntry(int hashCode, long value, @NonNull Bytes keyBytes) {
            this.hashCode = hashCode;
            this.value = value;
            this.keyBytes = keyBytes;
        }

        public BucketEntry(ReadableSequentialData entryData) {
            int hashCode = 0;
            long value = 0L;
            Bytes keyBytes = null;
            while (entryData.hasRemaining()) {
                int tag = entryData.readVarInt(false);
                int fieldNum = tag >> 3;
                if (fieldNum == Bucket.FIELD_BUCKETENTRY_HASHCODE.number()) {
                    hashCode = entryData.readInt();
                    continue;
                }
                if (fieldNum == Bucket.FIELD_BUCKETENTRY_VALUE.number()) {
                    value = entryData.readLong();
                    continue;
                }
                if (fieldNum == Bucket.FIELD_BUCKETENTRY_KEYBYTES.number()) {
                    int bytesSize = entryData.readVarInt(false);
                    keyBytes = entryData.readBytes(bytesSize);
                    continue;
                }
                throw new IllegalArgumentException("Unknown bucket entry field: " + fieldNum);
            }
            if (keyBytes == null) {
                throw new IllegalArgumentException("Null key for bucket entry");
            }
            this.hashCode = hashCode;
            this.value = value;
            this.keyBytes = keyBytes;
        }

        public int getHashCode() {
            return this.hashCode;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public Bytes getKeyBytes() {
            return this.keyBytes;
        }

        public int sizeInBytes() {
            int size = 0;
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)Bucket.FIELD_BUCKETENTRY_HASHCODE, (ProtoConstants)ProtoConstants.WIRE_TYPE_FIXED_32_BIT) + 4;
            size += ProtoWriterTools.sizeOfTag((FieldDefinition)Bucket.FIELD_BUCKETENTRY_VALUE, (ProtoConstants)ProtoConstants.WIRE_TYPE_FIXED_64_BIT) + 8;
            return size += ProtoWriterTools.sizeOfDelimited((FieldDefinition)Bucket.FIELD_BUCKETENTRY_KEYBYTES, (int)Math.toIntExact(this.keyBytes.length()));
        }

        public void writeTo(WritableSequentialData out) {
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)Bucket.FIELD_BUCKETENTRY_HASHCODE);
            out.writeInt(this.hashCode);
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)Bucket.FIELD_BUCKETENTRY_VALUE);
            out.writeLong(this.value);
            ProtoWriterTools.writeDelimited((WritableSequentialData)out, (FieldDefinition)Bucket.FIELD_BUCKETENTRY_KEYBYTES, (int)Math.toIntExact(this.keyBytes.length()), arg_0 -> ((Bytes)this.keyBytes).writeTo(arg_0));
        }
    }
}

