/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.parameters.Parameters;
import io.helidon.http.Header;
import io.helidon.http.HeaderHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CookieParser {
    private static final Parameters EMPTY_COOKIES = Parameters.empty((String)"http/cookies");
    private static final String RFC2965_VERSION = "$Version";
    private static final String RFC2965_PATH = "$Path";
    private static final String RFC2965_DOMAIN = "$Domain";
    private static final String RFC2965_PORT = "$Port";

    private CookieParser() {
    }

    static Parameters parse(Header httpHeader) {
        HashMap<String, List<String>> allCookies = new HashMap<String, List<String>>();
        for (String value : httpHeader.allValues()) {
            CookieParser.parse(allCookies, value);
        }
        if (allCookies.isEmpty()) {
            return EMPTY_COOKIES;
        }
        return Parameters.create((String)"http/cookies", allCookies, (String[])new String[]{"http", "cookies"});
    }

    static Parameters empty() {
        return EMPTY_COOKIES;
    }

    private static void parse(Map<String, List<String>> allCookies, String cookieHeaderValue) {
        boolean isRfc2965 = false;
        if (cookieHeaderValue.regionMatches(true, 0, RFC2965_VERSION, 0, RFC2965_VERSION.length())) {
            isRfc2965 = true;
            int ind = cookieHeaderValue.indexOf(59);
            if (ind < 0) {
                return;
            }
            cookieHeaderValue = cookieHeaderValue.substring(ind + 1);
        }
        for (String baseToken : HeaderHelper.tokenize(',', cookieHeaderValue)) {
            for (String token : HeaderHelper.tokenize(';', baseToken)) {
                String name;
                int eqInd = token.indexOf(61);
                if (eqInd <= 0 || (name = token.substring(0, eqInd).trim()).isEmpty() || isRfc2965 && name.charAt(0) == '$' && (RFC2965_PATH.equalsIgnoreCase(name) || RFC2965_DOMAIN.equalsIgnoreCase(name) || RFC2965_PORT.equalsIgnoreCase(name) || RFC2965_VERSION.equalsIgnoreCase(name))) continue;
                String value = token.substring(eqInd + 1).trim();
                allCookies.computeIfAbsent(name, it -> new ArrayList(1)).add(HeaderHelper.unwrap(value));
            }
        }
    }
}

