/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.MediaType;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.HttpMediaType;
import io.helidon.http.Utils;
import io.helidon.service.registry.Service;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@Service.Describe(value=Service.PerRequest.class)
public interface Headers
extends Iterable<Header> {
    public List<String> all(HeaderName var1, Supplier<List<String>> var2);

    public boolean contains(HeaderName var1);

    public boolean contains(Header var1);

    public Header get(HeaderName var1);

    default public Optional<String> value(HeaderName headerName) {
        if (this.contains(headerName)) {
            List<String> hdrs = this.all(headerName, List::of);
            return Optional.of(String.join((CharSequence)",", hdrs));
        }
        return Optional.empty();
    }

    default public Optional<String> first(HeaderName headerName) {
        if (this.contains(headerName)) {
            return Optional.of((String)this.get(headerName).get());
        }
        return Optional.empty();
    }

    default public Optional<Header> find(HeaderName headerName) {
        if (this.contains(headerName)) {
            return Optional.of(this.get(headerName));
        }
        return Optional.empty();
    }

    default public List<String> values(HeaderName headerName) {
        return this.all(headerName, List::of).stream().flatMap(val -> Utils.tokenize(',', "\"", true, val).stream()).collect(Collectors.toList());
    }

    default public OptionalLong contentLength() {
        if (this.contains(HeaderNameEnum.CONTENT_LENGTH)) {
            return OptionalLong.of((Long)this.get(HeaderNameEnum.CONTENT_LENGTH).get(Long.TYPE));
        }
        return OptionalLong.empty();
    }

    default public Optional<HttpMediaType> contentType() {
        if (this.contains(HeaderNameEnum.CONTENT_TYPE)) {
            return Optional.of(HttpMediaType.create((String)this.get(HeaderNameEnum.CONTENT_TYPE).get()));
        }
        return Optional.empty();
    }

    public int size();

    public List<HttpMediaType> acceptedTypes();

    default public boolean isAccepted(MediaType ... mediaTypes) {
        return true;
    }

    @Deprecated
    default public Map<String, List<String>> toMap() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        this.forEach(it -> headers.put(it.name(), it.allValues()));
        return headers;
    }

    default public Stream<Header> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

