/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.uri.UriBuilderSupport;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriInfoBlueprint;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriQuery;
import java.util.Objects;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.uri.UriInfoBlueprint")
public interface UriInfo
extends UriInfoBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UriInfo instance) {
        return (Builder)UriInfo.builder().from(instance);
    }

    public static UriInfo create() {
        return UriInfo.builder().buildPrototype();
    }

    @Override
    public String scheme();

    @Override
    public String host();

    @Override
    public int port();

    @Override
    public UriPath path();

    @Override
    public UriQuery query();

    @Override
    public UriFragment fragment();

    public static class Builder
    extends BuilderBase<Builder, UriInfo>
    implements io.helidon.common.Builder<Builder, UriInfo> {
        private Builder() {
        }

        public UriInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.UriInfoImpl(this);
        }

        public UriInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends UriInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private int port;
        private String host = "localhost";
        private String scheme = "http";
        private UriFragment fragment = UriFragment.empty();
        private UriPath path = UriPath.root();
        private UriQuery query = UriQuery.empty();

        protected BuilderBase() {
        }

        public BUILDER from(UriInfo prototype) {
            this.scheme(prototype.scheme());
            this.host(prototype.host());
            this.port(prototype.port());
            this.path(prototype.path());
            this.query(prototype.query());
            this.fragment(prototype.fragment());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.scheme(builder.scheme());
            this.host(builder.host());
            this.port(builder.port());
            this.path(builder.path());
            this.query(builder.query());
            this.fragment(builder.fragment());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER authority(String authority) {
            UriBuilderSupport.UriInfoCustomMethods.authority(this, authority);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER path(String path) {
            UriBuilderSupport.UriInfoCustomMethods.path(this, path);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER scheme(String scheme) {
            Objects.requireNonNull(scheme);
            this.scheme = scheme;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER host(String host) {
            Objects.requireNonNull(host);
            this.host = host;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER port(int port) {
            this.port = port;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER path(UriPath path) {
            Objects.requireNonNull(path);
            this.path = path;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER query(UriQuery query) {
            Objects.requireNonNull(query);
            this.query = query;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fragment(UriFragment fragment) {
            Objects.requireNonNull(fragment);
            this.fragment = fragment;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String scheme() {
            return this.scheme;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public UriPath path() {
            return this.path;
        }

        public UriQuery query() {
            return this.query;
        }

        public UriFragment fragment() {
            return this.fragment;
        }

        public String toString() {
            return "UriInfoBuilder{scheme=" + this.scheme + ",host=" + this.host + ",port=" + this.port + ",path=" + String.valueOf(this.path) + ",query=" + String.valueOf(this.query) + ",fragment=" + String.valueOf(this.fragment) + "}";
        }

        protected void preBuildPrototype() {
            new UriBuilderSupport.UriInfoInterceptor().decorate(this);
        }

        protected void validatePrototype() {
        }

        protected static class UriInfoImpl
        implements UriInfo {
            private final int port;
            private final String host;
            private final String scheme;
            private final UriFragment fragment;
            private final UriPath path;
            private final UriQuery query;

            protected UriInfoImpl(BuilderBase<?, ?> builder) {
                this.scheme = builder.scheme();
                this.host = builder.host();
                this.port = builder.port();
                this.path = builder.path();
                this.query = builder.query();
                this.fragment = builder.fragment();
            }

            @Override
            public String scheme() {
                return this.scheme;
            }

            @Override
            public String host() {
                return this.host;
            }

            @Override
            public int port() {
                return this.port;
            }

            @Override
            public UriPath path() {
                return this.path;
            }

            @Override
            public UriQuery query() {
                return this.query;
            }

            @Override
            public UriFragment fragment() {
                return this.fragment;
            }

            public String toString() {
                return "UriInfo{scheme=" + this.scheme + ",host=" + this.host + ",port=" + this.port + ",path=" + String.valueOf(this.path) + ",query=" + String.valueOf(this.query) + ",fragment=" + String.valueOf(this.fragment) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UriInfo)) {
                    return false;
                }
                UriInfo other = (UriInfo)o;
                return Objects.equals(this.scheme, other.scheme()) && Objects.equals(this.host, other.host()) && this.port == other.port() && Objects.equals(this.path, other.path()) && Objects.equals(this.query, other.query()) && Objects.equals(this.fragment, other.fragment());
            }

            public int hashCode() {
                return Objects.hash(this.scheme, this.host, this.port, this.path, this.query, this.fragment);
            }
        }
    }
}

