/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.StreamDebugUtils;
import com.swirlds.common.merkle.MerkleNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;

public class MerkleTreeSnapshotReader {
    public static final int SIG_SET_SEPARATE_STATE_FILE_VERSION = 2;
    public static final Set<Integer> SUPPORTED_STATE_FILE_VERSIONS = Set.of(Integer.valueOf(2));
    public static final byte VERSIONED_FILE_BYTE = 127;
    public static final String SIGNED_STATE_FILE_NAME = "SignedState.swh";
    public static final int MAX_MERKLE_NODES_IN_STATE = Integer.MAX_VALUE;

    @NonNull
    public static MerkleNode readStateFileData(@NonNull Path stateDirectory) throws IOException {
        Path stateFile = stateDirectory.resolve(SIGNED_STATE_FILE_NAME);
        return StreamDebugUtils.deserializeAndDebugOnFailure(() -> new BufferedInputStream(new FileInputStream(stateFile.toFile())), in -> {
            int fileVersion = MerkleTreeSnapshotReader.readAndCheckStateFileVersion(in);
            if (fileVersion == 2) {
                try {
                    return in.readMerkleTree(stateDirectory, Integer.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new IOException("Failed to read snapshot file " + String.valueOf(stateDirectory.toFile()), e);
                }
            }
            throw new IOException("Unsupported state file version: " + fileVersion);
        });
    }

    private static int readAndCheckStateFileVersion(@NonNull MerkleDataInputStream in) throws IOException {
        byte versionByte = in.readByte();
        if (versionByte != 127) {
            throw new IOException("File is not versioned -- data corrupted or is an unsupported legacy state");
        }
        int fileVersion = in.readInt();
        if (!SUPPORTED_STATE_FILE_VERSIONS.contains(fileVersion)) {
            throw new IOException("Unsupported file version: " + fileVersion);
        }
        in.readProtocolVersion();
        return fileVersion;
    }
}

