/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features.metadata;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.features.metadata.Aot;
import io.helidon.common.features.metadata.Deprecation;
import io.helidon.common.features.metadata.FeatureMetadataBlueprint;
import io.helidon.common.features.metadata.FeatureMetadataSupport;
import io.helidon.common.features.metadata.FeatureStatus;
import io.helidon.common.features.metadata.Flavor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.features.metadata.FeatureMetadataBlueprint")
public interface FeatureMetadata
extends FeatureMetadataBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FeatureMetadata instance) {
        return (Builder)FeatureMetadata.builder().from(instance);
    }

    public static FeatureMetadata create() {
        return FeatureMetadata.builder().buildPrototype();
    }

    @Override
    public String module();

    @Override
    public String name();

    @Override
    public Optional<String> description();

    @Override
    public List<String> path();

    @Override
    public Optional<String> since();

    @Override
    public List<Flavor> flavors();

    @Override
    public List<Flavor> invalidFlavors();

    @Override
    public Optional<Aot> aot();

    @Override
    public Optional<Deprecation> deprecation();

    @Override
    public FeatureStatus status();

    public static class Builder
    extends BuilderBase<Builder, FeatureMetadata>
    implements io.helidon.common.Builder<Builder, FeatureMetadata> {
        private Builder() {
        }

        public FeatureMetadata buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.FeatureMetadataImpl(this);
        }

        public FeatureMetadata build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends FeatureMetadata>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Flavor> flavors = new ArrayList<Flavor>();
        private final List<Flavor> invalidFlavors = new ArrayList<Flavor>();
        private final List<String> path = new ArrayList<String>();
        private Aot aot;
        private boolean isFlavorsMutated;
        private boolean isInvalidFlavorsMutated;
        private boolean isPathMutated;
        private Deprecation deprecation;
        private FeatureStatus status;
        private String description;
        private String module;
        private String name;
        private String since;

        protected BuilderBase() {
        }

        public BUILDER from(FeatureMetadata prototype) {
            this.module(prototype.module());
            this.name(prototype.name());
            this.description(prototype.description());
            if (!this.isPathMutated) {
                this.path.clear();
            }
            this.addPath(prototype.path());
            this.since(prototype.since());
            if (!this.isFlavorsMutated) {
                this.flavors.clear();
            }
            this.addFlavors(prototype.flavors());
            if (!this.isInvalidFlavorsMutated) {
                this.invalidFlavors.clear();
            }
            this.addInvalidFlavors(prototype.invalidFlavors());
            this.aot(prototype.aot());
            this.deprecation(prototype.deprecation());
            this.status(prototype.status());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.module().ifPresent(this::module);
            builder.name().ifPresent(this::name);
            builder.description().ifPresent(this::description);
            if (this.isPathMutated) {
                if (builder.isPathMutated) {
                    this.addPath(builder.path);
                }
            } else {
                this.path.clear();
                this.addPath(builder.path);
            }
            builder.since().ifPresent(this::since);
            if (this.isFlavorsMutated) {
                if (builder.isFlavorsMutated) {
                    this.addFlavors(builder.flavors);
                }
            } else {
                this.flavors.clear();
                this.addFlavors(builder.flavors);
            }
            if (this.isInvalidFlavorsMutated) {
                if (builder.isInvalidFlavorsMutated) {
                    this.addInvalidFlavors(builder.invalidFlavors);
                }
            } else {
                this.invalidFlavors.clear();
                this.addInvalidFlavors(builder.invalidFlavors);
            }
            builder.aot().ifPresent(this::aot);
            builder.deprecation().ifPresent(this::deprecation);
            builder.status().ifPresent(this::status);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER module(String module) {
            Objects.requireNonNull(module);
            this.module = module;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDescription() {
            this.description = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER path(List<String> path) {
            Objects.requireNonNull(path);
            this.isPathMutated = true;
            this.path.clear();
            this.path.addAll(path);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPath(List<String> path) {
            Objects.requireNonNull(path);
            this.isPathMutated = true;
            this.path.addAll(path);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSince() {
            this.since = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER since(String since) {
            Objects.requireNonNull(since);
            this.since = since;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER flavors(List<? extends Flavor> flavors) {
            Objects.requireNonNull(flavors);
            this.isFlavorsMutated = true;
            this.flavors.clear();
            this.flavors.addAll(flavors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addFlavors(List<? extends Flavor> flavors) {
            Objects.requireNonNull(flavors);
            this.isFlavorsMutated = true;
            this.flavors.addAll(flavors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addFlavor(Flavor flavor) {
            Objects.requireNonNull(flavor);
            this.flavors.add(flavor);
            this.isFlavorsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER invalidFlavors(List<? extends Flavor> invalidFlavors) {
            Objects.requireNonNull(invalidFlavors);
            this.isInvalidFlavorsMutated = true;
            this.invalidFlavors.clear();
            this.invalidFlavors.addAll(invalidFlavors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInvalidFlavors(List<? extends Flavor> invalidFlavors) {
            Objects.requireNonNull(invalidFlavors);
            this.isInvalidFlavorsMutated = true;
            this.invalidFlavors.addAll(invalidFlavors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInvalidFlavor(Flavor invalidFlavor) {
            Objects.requireNonNull(invalidFlavor);
            this.invalidFlavors.add(invalidFlavor);
            this.isInvalidFlavorsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAot() {
            this.aot = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER aot(Aot aot) {
            Objects.requireNonNull(aot);
            this.aot = aot;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER aot(Consumer<Aot.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Aot.Builder builder = Aot.builder();
            consumer.accept(builder);
            this.aot(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDeprecation() {
            this.deprecation = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deprecation(Deprecation deprecation) {
            Objects.requireNonNull(deprecation);
            this.deprecation = deprecation;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deprecation(Consumer<Deprecation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Deprecation.Builder builder = Deprecation.builder();
            consumer.accept(builder);
            this.deprecation(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER status(FeatureStatus status) {
            Objects.requireNonNull(status);
            this.status = status;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> module() {
            return Optional.ofNullable(this.module);
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public List<String> path() {
            return this.path;
        }

        public Optional<String> since() {
            return Optional.ofNullable(this.since);
        }

        public List<Flavor> flavors() {
            return this.flavors;
        }

        public List<Flavor> invalidFlavors() {
            return this.invalidFlavors;
        }

        public Optional<Aot> aot() {
            return Optional.ofNullable(this.aot);
        }

        public Optional<Deprecation> deprecation() {
            return Optional.ofNullable(this.deprecation);
        }

        public Optional<FeatureStatus> status() {
            return Optional.ofNullable(this.status);
        }

        public String toString() {
            return "FeatureMetadataBuilder{module=" + this.module + ",name=" + this.name + ",description=" + this.description + ",path=" + String.valueOf(this.path) + ",since=" + this.since + ",flavors=" + String.valueOf(this.flavors) + ",invalidFlavors=" + String.valueOf(this.invalidFlavors) + ",aot=" + String.valueOf(this.aot) + ",deprecation=" + String.valueOf(this.deprecation) + ",status=" + String.valueOf((Object)this.status) + "}";
        }

        protected void preBuildPrototype() {
            new FeatureMetadataSupport().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.module == null) {
                collector.fatal(this.getClass(), "Property \"module\" must not be null, but not set");
            }
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            if (this.status == null) {
                collector.fatal(this.getClass(), "Property \"status\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER description(Optional<String> description) {
            Objects.requireNonNull(description);
            this.description = description.map(String.class::cast).orElse(this.description);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER since(Optional<String> since) {
            Objects.requireNonNull(since);
            this.since = since.map(String.class::cast).orElse(this.since);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER aot(Optional<? extends Aot> aot) {
            Objects.requireNonNull(aot);
            this.aot = aot.map(Aot.class::cast).orElse(this.aot);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER deprecation(Optional<? extends Deprecation> deprecation) {
            Objects.requireNonNull(deprecation);
            this.deprecation = deprecation.map(Deprecation.class::cast).orElse(this.deprecation);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class FeatureMetadataImpl
        implements FeatureMetadata {
            private final FeatureStatus status;
            private final List<Flavor> flavors;
            private final List<Flavor> invalidFlavors;
            private final List<String> path;
            private final Optional<Aot> aot;
            private final Optional<Deprecation> deprecation;
            private final Optional<String> description;
            private final Optional<String> since;
            private final String module;
            private final String name;

            protected FeatureMetadataImpl(BuilderBase<?, ?> builder) {
                this.module = builder.module().get();
                this.name = builder.name().get();
                this.description = builder.description().map(Function.identity());
                this.path = List.copyOf(builder.path());
                this.since = builder.since().map(Function.identity());
                this.flavors = List.copyOf(builder.flavors());
                this.invalidFlavors = List.copyOf(builder.invalidFlavors());
                this.aot = builder.aot().map(Function.identity());
                this.deprecation = builder.deprecation().map(Function.identity());
                this.status = builder.status().get();
            }

            @Override
            public String module() {
                return this.module;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Optional<String> description() {
                return this.description;
            }

            @Override
            public List<String> path() {
                return this.path;
            }

            @Override
            public Optional<String> since() {
                return this.since;
            }

            @Override
            public List<Flavor> flavors() {
                return this.flavors;
            }

            @Override
            public List<Flavor> invalidFlavors() {
                return this.invalidFlavors;
            }

            @Override
            public Optional<Aot> aot() {
                return this.aot;
            }

            @Override
            public Optional<Deprecation> deprecation() {
                return this.deprecation;
            }

            @Override
            public FeatureStatus status() {
                return this.status;
            }

            public String toString() {
                return "FeatureMetadata{module=" + this.module + ",name=" + this.name + ",description=" + String.valueOf(this.description) + ",path=" + String.valueOf(this.path) + ",since=" + String.valueOf(this.since) + ",flavors=" + String.valueOf(this.flavors) + ",invalidFlavors=" + String.valueOf(this.invalidFlavors) + ",aot=" + String.valueOf(this.aot) + ",deprecation=" + String.valueOf(this.deprecation) + ",status=" + String.valueOf((Object)this.status) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FeatureMetadata)) {
                    return false;
                }
                FeatureMetadata other = (FeatureMetadata)o;
                return Objects.equals(this.module, other.module()) && Objects.equals(this.name, other.name()) && Objects.equals(this.description, other.description()) && Objects.equals(this.path, other.path()) && Objects.equals(this.since, other.since()) && Objects.equals(this.flavors, other.flavors()) && Objects.equals(this.invalidFlavors, other.invalidFlavors()) && Objects.equals(this.aot, other.aot()) && Objects.equals(this.deprecation, other.deprecation()) && Objects.equals((Object)this.status, (Object)other.status());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.module, this.name, this.description, this.path, this.since, this.flavors, this.invalidFlavors, this.aot, this.deprecation, this.status});
            }
        }
    }
}

