/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metadata.hson;

import java.io.PrintWriter;
import java.io.Writer;

class HsonPrettyPrintWriter
extends PrintWriter {
    private static final String IDENT_UNIT = "   ";
    private int indentLevel = 0;
    private boolean inString = false;
    private boolean escape = false;

    HsonPrettyPrintWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) {
        char ch = (char)c;
        if (this.inString) {
            if (this.escape) {
                this.escape = false;
            } else if (ch == '\\') {
                this.escape = true;
            } else if (ch == '\"') {
                this.inString = false;
            }
            super.write(c);
            return;
        }
        if (ch == '\"') {
            this.inString = true;
            super.write(c);
            return;
        }
        switch (ch) {
            case '[': 
            case '{': {
                super.write(ch);
                ++this.indentLevel;
                super.write(10);
                this.write(IDENT_UNIT.repeat(this.indentLevel));
                break;
            }
            case ']': 
            case '}': {
                --this.indentLevel;
                super.write(10);
                this.write(IDENT_UNIT.repeat(this.indentLevel));
                super.write(ch);
                break;
            }
            case ',': {
                super.write(ch);
                super.write(10);
                this.write(IDENT_UNIT.repeat(this.indentLevel));
                break;
            }
            case ':': {
                super.write(": ");
                break;
            }
            default: {
                super.write(ch);
            }
        }
    }
}

