/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.helidon.config;

import com.hedera.pbj.grpc.helidon.config.PbjConfigBlueprint;
import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="com.hedera.pbj.grpc.helidon.config.PbjConfigBlueprint")
public interface PbjConfig
extends PbjConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PbjConfig instance) {
        return (Builder)PbjConfig.builder().from(instance);
    }

    public static PbjConfig create(Config config) {
        return ((Builder)PbjConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static PbjConfig create(io.helidon.common.config.Config config) {
        return PbjConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static PbjConfig create() {
        return PbjConfig.builder().buildPrototype();
    }

    @Override
    public int maxMessageSizeBytes();

    public String name();

    public static class Builder
    extends BuilderBase<Builder, PbjConfig>
    implements io.helidon.common.Builder<Builder, PbjConfig> {
        private Builder() {
        }

        public PbjConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.PbjConfigImpl(this);
        }

        public PbjConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PbjConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private int maxMessageSizeBytes = 10240;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(PbjConfig prototype) {
            this.maxMessageSizeBytes(prototype.maxMessageSizeBytes());
            this.name(prototype.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.maxMessageSizeBytes(builder.maxMessageSizeBytes());
            builder.name().ifPresent(this::name);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("max-message-size-bytes").as(Integer.class).ifPresent(this::maxMessageSizeBytes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxMessageSizeBytes(int maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public int maxMessageSizeBytes() {
            return this.maxMessageSizeBytes;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "PbjConfigBuilder{maxMessageSizeBytes=" + this.maxMessageSizeBytes + ",name=" + this.name + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class PbjConfigImpl
        implements PbjConfig {
            private final int maxMessageSizeBytes;
            private final String name;

            protected PbjConfigImpl(BuilderBase<?, ?> builder) {
                this.maxMessageSizeBytes = builder.maxMessageSizeBytes();
                this.name = builder.name().get();
            }

            @Override
            public int maxMessageSizeBytes() {
                return this.maxMessageSizeBytes;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                return "PbjConfig{maxMessageSizeBytes=" + this.maxMessageSizeBytes + ",name=" + this.name + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PbjConfig)) {
                    return false;
                }
                PbjConfig other = (PbjConfig)o;
                return this.maxMessageSizeBytes == other.maxMessageSizeBytes() && Objects.equals(this.name, other.name());
            }

            public int hashCode() {
                return Objects.hash(this.maxMessageSizeBytes, this.name);
            }
        }
    }
}

