/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.claimairdrops;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.claimairdrops.TokenClaimAirdropDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenClaimAirdropTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod CLAIM_AIRDROPS = SystemContractMethod.declare("claimAirdrops((address,address,address,int64)[])", "(int64)").withCategories(SystemContractMethod.Category.AIRDROP);
    public static final SystemContractMethod HRC_CLAIM_AIRDROP_FT = SystemContractMethod.declare("claimAirdropFT(address)", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withVariant(SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.AIRDROP);
    public static final SystemContractMethod HRC_CLAIM_AIRDROP_NFT = SystemContractMethod.declare("claimAirdropNFT(address,int64)", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withVariant(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.AIRDROP);
    private final TokenClaimAirdropDecoder decoder;

    @Inject
    public TokenClaimAirdropTranslator(@NonNull TokenClaimAirdropDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(CLAIM_AIRDROPS, HRC_CLAIM_AIRDROP_FT, HRC_CLAIM_AIRDROP_NFT);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        boolean claimAirdropEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractClaimAirdropsEnabled();
        if (!claimAirdropEnabled) {
            return Optional.empty();
        }
        return attempt.isRedirect() ? attempt.isMethod(HRC_CLAIM_AIRDROP_FT, HRC_CLAIM_AIRDROP_NFT) : attempt.isMethod(CLAIM_AIRDROPS);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new DispatchForResponseCodeHtsCall(attempt, attempt.isSelector(CLAIM_AIRDROPS) ? this.bodyForClassic(attempt) : this.bodyForHRC(attempt), TokenClaimAirdropTranslator::gasRequirement);
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.TOKEN_CLAIM_AIRDROP, payerId);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        return this.decoder.decodeTokenClaimAirdrop(attempt);
    }

    private TransactionBody bodyForHRC(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(HRC_CLAIM_AIRDROP_FT)) {
            return this.decoder.decodeHrcClaimAirdropFt(attempt);
        }
        return this.decoder.decodeHrcClaimAirdropNft(attempt);
    }
}

