/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.task;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.CustomViewRootLesson;
import com.swirlds.common.merkle.synchronization.task.InternalDataLesson;
import com.swirlds.common.merkle.synchronization.task.LeafDataLesson;
import com.swirlds.common.merkle.synchronization.task.Lesson;
import com.swirlds.common.merkle.synchronization.task.QueryResponse;
import com.swirlds.common.merkle.synchronization.task.TeacherSubtree;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.CustomReconnectRoot;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;

public class TeacherPushSendTask<T> {
    private static final Logger logger = LogManager.getLogger(TeacherPushSendTask.class);
    private static final String NAME = "teacher-send-task";
    private static final Lesson<?> UP_TO_DATE_LESSON = new Lesson(0, null);
    private final ReconnectConfig reconnectConfig;
    private final StandardWorkGroup workGroup;
    private final AsyncInputStream<QueryResponse> in;
    private final AsyncOutputStream<Lesson<T>> out;
    private final Queue<TeacherSubtree> subtrees;
    private final TeacherTreeView<T> view;
    private final AtomicBoolean senderIsFinished;
    private final RateLimiter rateLimiter;
    private final int sleepNanos;

    public TeacherPushSendTask(@NonNull Time time, @NonNull ReconnectConfig reconnectConfig, StandardWorkGroup workGroup, AsyncInputStream<QueryResponse> in, AsyncOutputStream<Lesson<T>> out, Queue<TeacherSubtree> subtrees, TeacherTreeView<T> view, AtomicBoolean senderIsFinished) {
        this.reconnectConfig = reconnectConfig;
        this.workGroup = workGroup;
        this.in = in;
        this.out = out;
        this.subtrees = subtrees;
        this.view = view;
        this.senderIsFinished = senderIsFinished;
        int maxRate = reconnectConfig.teacherMaxNodesPerSecond();
        if (maxRate > 0) {
            this.rateLimiter = new RateLimiter(time, (double)maxRate);
            this.sleepNanos = (int)reconnectConfig.teacherRateLimiterSleep().toNanos();
        } else {
            this.rateLimiter = null;
            this.sleepNanos = -1;
        }
    }

    public void start() {
        this.workGroup.execute(NAME, this::run);
    }

    private void prepareForQueryResponse(T parent, int childIndex) {
        this.in.anticipateMessage();
        T child = this.view.getChildAndPrepareForQueryResponse(parent, childIndex);
        this.view.addToHandleQueue(child);
    }

    private Lesson<T> buildCustomReconnectRootLesson(T node) {
        Lesson lesson = new Lesson(3, new CustomViewRootLesson(this.view.getClassId(node)));
        CustomReconnectRoot subtreeRoot = (CustomReconnectRoot)this.view.getMerkleRoot(node);
        this.subtrees.add(new TeacherSubtree(subtreeRoot, subtreeRoot.buildTeacherView(this.reconnectConfig)));
        return lesson;
    }

    private Lesson<T> buildDataLesson(T node) {
        Lesson lesson;
        if (this.view.isInternal(node, true)) {
            lesson = new Lesson(2, new InternalDataLesson<T>(this.view, node));
            int childCount = this.view.getNumberOfChildren(node);
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                this.prepareForQueryResponse(node, childIndex);
            }
        } else {
            lesson = new Lesson(1, new LeafDataLesson<T>(this.view, node));
        }
        return lesson;
    }

    private void sendLesson(T node) throws InterruptedException {
        boolean learnerHasConfirmed = this.view.hasLearnerConfirmedFor(node);
        Lesson<Object> lesson = learnerHasConfirmed ? UP_TO_DATE_LESSON : (this.view.isCustomReconnectRoot(node) ? this.buildCustomReconnectRootLesson(node) : this.buildDataLesson(node));
        this.out.sendAsync(lesson);
    }

    private void rateLimit() throws InterruptedException {
        if (this.rateLimiter != null) {
            while (!this.rateLimiter.requestAndTrigger()) {
                TimeUnit.NANOSECONDS.sleep(this.sleepNanos);
            }
        }
    }

    private void run() {
        try (AsyncOutputStream<Lesson<T>> asyncOutputStream = this.out;){
            this.out.sendAsync(this.buildDataLesson(this.view.getRoot()));
            while (this.view.areThereNodesToHandle()) {
                this.rateLimit();
                Object node = this.view.getNextNodeToHandle();
                this.sendLesson(node);
            }
        }
        catch (InterruptedException ex) {
            logger.warn(LogMarker.RECONNECT.getMarker(), "teacher's sending thread interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new MerkleSynchronizationException("exception in the teacher's receiving thread", ex);
        }
        finally {
            this.senderIsFinished.set(true);
        }
    }
}

