/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.task;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.views.TeacherPushMerkleTreeView;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import edu.umd.cs.findbugs.annotations.NonNull;

public final class TeacherSubtree
implements AutoCloseable {
    private final MerkleNode root;
    private final TeacherTreeView<?> view;

    public TeacherSubtree(@NonNull ReconnectConfig reconnectConfig, MerkleNode root) {
        this(root, new TeacherPushMerkleTreeView(reconnectConfig, root));
    }

    public TeacherSubtree(MerkleNode root, TeacherTreeView<?> view) {
        this.root = root;
        this.view = view;
        if (root != null) {
            root.reserve();
        }
    }

    public MerkleNode getRoot() {
        return this.root;
    }

    public TeacherTreeView<?> getView() {
        return this.view;
    }

    @Override
    public void close() {
        this.view.close();
        if (this.root != null) {
            this.root.release();
        }
    }
}

