/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.sysfiles.domain.throttling;

import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.HapiThrottleUtils;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ThrottleGroup;
import com.hedera.node.app.hapi.utils.sysfiles.validation.ErrorCodeUtils;
import com.hedera.node.app.hapi.utils.throttles.BucketThrottle;
import com.hedera.node.app.hapi.utils.throttles.DeterministicThrottle;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ThrottleBucket<E extends Enum<E>> {
    private static final Logger log = LogManager.getLogger(ThrottleBucket.class);
    private static final String BUCKET_PREFIX = "Bucket ";
    private int burstPeriod;
    private long burstPeriodMs;
    private String name;
    private List<ThrottleGroup<E>> throttleGroups = new ArrayList<ThrottleGroup<E>>();

    public ThrottleBucket() {
    }

    public ThrottleBucket(long burstPeriodMs, String name, List<ThrottleGroup<E>> throttleGroups) {
        this.burstPeriodMs = burstPeriodMs;
        this.name = name;
        this.throttleGroups = throttleGroups;
    }

    public long getBurstPeriodMs() {
        return this.burstPeriodMs;
    }

    public void setBurstPeriodMs(long burstPeriodMs) {
        this.burstPeriodMs = burstPeriodMs;
    }

    public int getBurstPeriod() {
        return this.burstPeriod;
    }

    public void setBurstPeriod(int burstPeriod) {
        this.burstPeriod = burstPeriod;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ThrottleGroup<E>> getThrottleGroups() {
        return this.throttleGroups;
    }

    public void setThrottleGroups(List<ThrottleGroup<E>> throttleGroups) {
        this.throttleGroups = throttleGroups;
    }

    public Pair<DeterministicThrottle, List<Pair<E, Integer>>> asThrottleMapping(long capacitySplit) {
        if (this.throttleGroups.isEmpty()) {
            throw new IllegalStateException(ErrorCodeUtils.exceptionMsgFor(ResponseCodeEnum.BUCKET_HAS_NO_THROTTLE_GROUPS, BUCKET_PREFIX + this.name + " includes no throttle groups!"));
        }
        this.assertMinimalOpsPerSec();
        long mtps = this.logicalMtps();
        return this.mappingWith(mtps, capacitySplit);
    }

    private long logicalMtps() {
        try {
            return this.requiredLogicalMilliTpsToAccommodateAllGroups();
        }
        catch (ArithmeticException overflow) {
            throw new IllegalStateException(ErrorCodeUtils.exceptionMsgFor(ResponseCodeEnum.BUCKET_CAPACITY_OVERFLOW, BUCKET_PREFIX + this.name + " overflows with given throttle groups!"));
        }
    }

    private Pair<DeterministicThrottle, List<Pair<E, Integer>>> mappingWith(long mtps, long capacitySplit) {
        DeterministicThrottle throttle = this.throttleFor(mtps, capacitySplit);
        long totalCapacityUnits = throttle.capacity();
        HashSet seenSoFar = new HashSet();
        ArrayList<Pair<E, Integer>> opsReqs = new ArrayList<Pair<E, Integer>>();
        for (ThrottleGroup<E> throttleGroup : this.throttleGroups) {
            this.updateOpsReqs(capacitySplit, mtps, totalCapacityUnits, throttleGroup, seenSoFar, opsReqs);
        }
        return Pair.of((Object)throttle, opsReqs);
    }

    private void updateOpsReqs(long capacitySplit, long mtps, long totalCapacity, ThrottleGroup<E> group, Set<E> seenSoFar, List<Pair<E, Integer>> opsReqs) {
        int opsReq = (int)(mtps / group.impliedMilliOpsPerSec());
        long capacityReq = DeterministicThrottle.capacityRequiredFor(opsReq);
        if (capacityReq < 0L || capacityReq > totalCapacity) {
            throw new IllegalStateException(ErrorCodeUtils.exceptionMsgFor(ResponseCodeEnum.NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION, BUCKET_PREFIX + this.name + " contains an unsatisfiable milliOpsPerSec with " + capacitySplit + " nodes!"));
        }
        List<E> functions = group.getOperations();
        if (Collections.disjoint(seenSoFar, functions)) {
            HashSet<Enum> listedSoFar = new HashSet<Enum>();
            for (Enum function : functions) {
                if (listedSoFar.contains(function)) continue;
                opsReqs.add(Pair.of((Object)function, (Object)opsReq));
                listedSoFar.add(function);
            }
        } else {
            throw new IllegalStateException(ErrorCodeUtils.exceptionMsgFor(ResponseCodeEnum.OPERATION_REPEATED_IN_BUCKET_GROUPS, BUCKET_PREFIX + this.name + " assigns an operation to multiple groups!"));
        }
        seenSoFar.addAll(functions);
    }

    private DeterministicThrottle throttleFor(long mtps, long capacitySplit) {
        try {
            long effBurstPeriodMs = this.autoScaledBurstPeriodMs(capacitySplit);
            return DeterministicThrottle.withMtpsAndBurstPeriodMsNamed(this.mtpsSplitBy(mtps, capacitySplit), effBurstPeriodMs, this.name);
        }
        catch (IllegalArgumentException unsatisfiable) {
            if (unsatisfiable.getMessage().startsWith("Cannot free")) {
                throw new IllegalStateException(ErrorCodeUtils.exceptionMsgFor(ResponseCodeEnum.BUCKET_CAPACITY_OVERFLOW, BUCKET_PREFIX + this.name + " overflows with given throttle groups!"));
            }
            throw new IllegalStateException(ErrorCodeUtils.exceptionMsgFor(ResponseCodeEnum.NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION, BUCKET_PREFIX + this.name + " contains an unsatisfiable milliOpsPerSec with " + capacitySplit + " nodes!"));
        }
    }

    long autoScaledBurstPeriodMs(long capacitySplit) {
        long reqBurstPeriodMs;
        long mtps = this.logicalMtps();
        long minCapacityUnitsPostSplit = 0L;
        for (ThrottleGroup<E> group : this.throttleGroups) {
            int opsReq = (int)(mtps / group.impliedMilliOpsPerSec());
            minCapacityUnitsPostSplit = Math.max(minCapacityUnitsPostSplit, DeterministicThrottle.capacityRequiredFor(opsReq));
        }
        long postSplitCapacityUnitsLeakedPerMs = BucketThrottle.capacityUnitsPerMs(this.mtpsSplitBy(mtps, capacitySplit));
        long minBurstPeriodMs = ThrottleBucket.quotientRoundedUp(minCapacityUnitsPostSplit, postSplitCapacityUnitsLeakedPerMs);
        if (minBurstPeriodMs > (reqBurstPeriodMs = this.impliedBurstPeriodMs())) {
            log.info("Auto-scaled {} burst period from {}ms -> {}ms to achieve requested steady-state OPS", (Object)this.name, (Object)reqBurstPeriodMs, (Object)minBurstPeriodMs);
        }
        return Math.max(minBurstPeriodMs, reqBurstPeriodMs);
    }

    private long mtpsSplitBy(long mtps, long splitFactor) {
        return Math.max(1L, mtps / splitFactor);
    }

    public static long quotientRoundedUp(long lhs, long rhs) {
        return lhs / rhs + (long)(lhs % rhs == 0L ? 0 : 1);
    }

    private void assertMinimalOpsPerSec() {
        for (ThrottleGroup<E> group : this.throttleGroups) {
            if (group.impliedMilliOpsPerSec() != 0L) continue;
            throw new IllegalStateException(ErrorCodeUtils.exceptionMsgFor(ResponseCodeEnum.THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC, BUCKET_PREFIX + this.name + " contains a group with zero milliOpsPerSec!"));
        }
    }

    private long requiredLogicalMilliTpsToAccommodateAllGroups() {
        long lcm = this.throttleGroups.get(0).impliedMilliOpsPerSec();
        int n = this.throttleGroups.size();
        for (int i = 1; i < n; ++i) {
            lcm = HapiThrottleUtils.lcm(lcm, this.throttleGroups.get(i).impliedMilliOpsPerSec());
        }
        return lcm;
    }

    public long impliedBurstPeriodMs() {
        return this.burstPeriodMs > 0L ? this.burstPeriodMs : 1000L * (long)this.burstPeriod;
    }
}

