/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features.metadata;

import io.helidon.builder.api.Prototype;
import io.helidon.common.features.metadata.Aot;
import io.helidon.common.features.metadata.Deprecation;
import io.helidon.common.features.metadata.FeatureMetadata;
import io.helidon.common.features.metadata.FeatureMetadataBlueprint;
import io.helidon.common.features.metadata.FeatureStatus;
import io.helidon.metadata.hson.Hson;
import java.util.List;
import java.util.stream.Collectors;

class FeatureMetadataSupport
implements Prototype.BuilderDecorator<FeatureMetadata.BuilderBase<?, ?>> {
    static final String HSON_VERSION = "version";
    static final String HSON_MODULE = "module";
    static final String HSON_NAME = "name";
    static final String HSON_PATH = "path";
    static final String HSON_DESCRIPTION = "description";
    static final String HSON_SINCE = "since";
    static final String HSON_FLAVOR = "flavor";
    static final String HSON_INVALID_FLAVOR = "invalid-flavor";
    static final String HSON_STATUS = "status";
    static final String HSON_AOT = "aot";
    static final String HSON_AOT_SUPPORTED = "supported";
    static final String HSON_DEPRECATION = "deprecation";
    static final String HSON_DEPRECATION_DEPRECATED = "deprecated";

    FeatureMetadataSupport() {
    }

    static Hson.Struct toHson(FeatureMetadataBlueprint featureMetadata) {
        Deprecation deprecation;
        Aot aot;
        List invalidFlavors;
        Hson.Struct.Builder builder = Hson.structBuilder();
        builder.set(HSON_MODULE, featureMetadata.module());
        builder.set(HSON_NAME, featureMetadata.name());
        List<String> path = featureMetadata.path();
        if (path.size() != 1 || !path.getFirst().equals(featureMetadata.name())) {
            builder.setStrings(HSON_PATH, path);
        }
        featureMetadata.description().ifPresent(it -> builder.set(HSON_DESCRIPTION, it));
        featureMetadata.since().ifPresent(it -> builder.set(HSON_SINCE, it));
        List flavors = featureMetadata.flavors().stream().map(Enum::name).collect(Collectors.toUnmodifiableList());
        if (!flavors.isEmpty()) {
            builder.setStrings(HSON_FLAVOR, flavors);
        }
        if (!(invalidFlavors = featureMetadata.invalidFlavors().stream().map(Enum::name).collect(Collectors.toUnmodifiableList())).isEmpty()) {
            builder.setStrings(HSON_INVALID_FLAVOR, invalidFlavors);
        }
        if (featureMetadata.status() != FeatureStatus.PRODUCTION && !featureMetadata.deprecation().map(Deprecation::isDeprecated).orElse(false).booleanValue()) {
            builder.set(HSON_STATUS, featureMetadata.status().name());
        }
        if (featureMetadata.aot().isPresent() && (!(aot = featureMetadata.aot().get()).supported() || aot.description().isPresent())) {
            Hson.Struct.Builder aotBuilder = Hson.structBuilder();
            if (!aot.supported()) {
                aotBuilder.set(HSON_AOT_SUPPORTED, aot.supported());
            }
            aot.description().ifPresent(it -> aotBuilder.set(HSON_DESCRIPTION, it));
            builder.set(HSON_AOT, (Hson.Value)aotBuilder.build());
        }
        if (featureMetadata.deprecation().isPresent() && (deprecation = featureMetadata.deprecation().get()).isDeprecated()) {
            Hson.Struct.Builder deprecationBuilder = Hson.structBuilder();
            deprecationBuilder.set(HSON_DEPRECATION_DEPRECATED, true);
            deprecation.description().ifPresent(it -> deprecationBuilder.set(HSON_DESCRIPTION, it));
            deprecation.since().ifPresent(it -> deprecationBuilder.set(HSON_SINCE, it));
            builder.set(HSON_DEPRECATION, (Hson.Value)deprecationBuilder.build());
        }
        return (Hson.Struct)builder.build();
    }

    public void decorate(FeatureMetadata.BuilderBase<?, ?> target) {
        if (target.path().isEmpty()) {
            target.name().map(List::of).ifPresent(target::path);
        }
        if (target.deprecation().map(Deprecation::isDeprecated).orElse(false).booleanValue()) {
            target.status(FeatureStatus.DEPRECATED);
        }
        if (target.status().isEmpty()) {
            target.status(FeatureStatus.PRODUCTION);
        }
    }
}

