/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.types;

import com.hedera.node.config.types.TriggeredValuesParser;
import java.util.Arrays;
import java.util.Objects;

public record CongestionMultipliers(int[] usagePercentTriggers, long[] multipliers) {
    public static CongestionMultipliers from(String csv) {
        TriggeredValuesParser.TriggeredValues<Long> triggeredMultipliers = TriggeredValuesParser.parseFrom(csv, CongestionMultipliers::multiplierFrom);
        return new CongestionMultipliers(triggeredMultipliers.triggers().stream().mapToInt(v -> v).toArray(), triggeredMultipliers.values().stream().mapToLong(l -> l).toArray());
    }

    private static Long multiplierFrom(String s) {
        Long multiplier;
        Long l = multiplier = s.endsWith("x") ? Long.valueOf(TriggeredValuesParser.sansDecimals(s.substring(0, s.length() - 1))) : Long.valueOf(TriggeredValuesParser.sansDecimals(s));
        if (multiplier <= 0L) {
            throw new IllegalArgumentException("Cannot use multiplier value " + multiplier + "!");
        }
        return multiplier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.usagePercentTriggers), Arrays.hashCode(this.multipliers));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(CongestionMultipliers.class)) {
            return false;
        }
        CongestionMultipliers that = (CongestionMultipliers)o;
        return Arrays.equals(this.multipliers, that.multipliers) && Arrays.equals(this.usagePercentTriggers, that.usagePercentTriggers);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CongestionMultipliers{");
        for (int i = 0; i < this.multipliers.length; ++i) {
            sb.append(this.multipliers[i]).append("x @ >=").append(this.usagePercentTriggers[i]).append("%").append(i == this.multipliers.length - 1 ? "" : ", ");
        }
        return sb.append("}").toString();
    }
}

