/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ModOperation
extends AbstractFixedCostOperation {
    private static final Operation.OperationResult modSuccess = new Operation.OperationResult(5L, null);

    public ModOperation(GasCalculator gasCalculator) {
        super(6, "MOD", 2, 1, gasCalculator, gasCalculator.getLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return ModOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem();
        Bytes value1 = frame.popStackItem();
        if (value1.isZero()) {
            frame.pushStackItem((Bytes)Bytes32.ZERO);
        } else {
            BigInteger b2;
            BigInteger b1 = new BigInteger(1, value0.toArrayUnsafe());
            BigInteger result = b1.mod(b2 = new BigInteger(1, value1.toArrayUnsafe()));
            Bytes resultBytes = Bytes.wrap((byte[])result.toByteArray());
            if (resultBytes.size() > 32) {
                resultBytes = resultBytes.slice(resultBytes.size() - 32, 32);
            }
            byte[] padding = new byte[32 - resultBytes.size()];
            Arrays.fill(padding, result.signum() < 0 ? (byte)-1 : 0);
            frame.pushStackItem(Bytes.concatenate((Bytes[])new Bytes[]{Bytes.wrap((byte[])padding), resultBytes}));
        }
        return modSuccess;
    }
}

