/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.bag.sorted;

import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.MutableBagIterable;
import org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import org.eclipse.collections.api.bag.sorted.SortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.SortedSets;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.sortedbag.MutableSortedBagMultimap;
import org.eclipse.collections.api.partition.bag.sorted.PartitionMutableSortedBag;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;

public interface MutableSortedBag<T>
extends SortedBag<T>,
MutableBagIterable<T>,
Cloneable {
    @Override
    public MutableSortedBag<T> selectByOccurrences(IntPredicate var1);

    @Override
    default public MutableSortedBag<T> selectDuplicates() {
        return this.selectByOccurrences(occurrences -> occurrences > 1);
    }

    @Override
    default public MutableSortedSet<T> selectUnique() {
        MutableSortedSet result = SortedSets.mutable.with(this.comparator());
        this.forEachWithOccurrences((each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result;
    }

    @Override
    public MutableSortedMap<T, Integer> toMapOfItemToCount();

    @Override
    default public MutableSortedBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    default public MutableSortedBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    default public MutableSortedBag<T> withOccurrences(T element, int occurrences) {
        this.addOccurrences(element, occurrences);
        return this;
    }

    @Override
    default public MutableSortedBag<T> withoutOccurrences(T element, int occurrences) {
        this.removeOccurrences(element, occurrences);
        return this;
    }

    @Override
    default public MutableSortedBag<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    default public MutableSortedBag<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    public MutableSortedBag<T> newEmpty();

    public MutableSortedBag<T> clone();

    @Override
    public MutableSortedBag<T> asUnmodifiable();

    @Override
    public MutableSortedBag<T> asSynchronized();

    @Override
    public MutableSortedBag<T> tap(Procedure<? super T> var1);

    @Override
    public MutableSortedBag<T> select(Predicate<? super T> var1);

    @Override
    public <P> MutableSortedBag<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public MutableSortedBag<T> reject(Predicate<? super T> var1);

    @Override
    public <P> MutableSortedBag<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionMutableSortedBag<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionMutableSortedBag<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionMutableSortedBag<T> partitionWhile(Predicate<? super T> var1);

    @Override
    public <S> MutableSortedBag<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> MutableList<V> collect(Function<? super T, ? extends V> var1);

    @Override
    public <V> MutableList<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> var1);

    @Override
    default public <V> MutableList<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each, n);
        });
    }

    @Override
    public MutableBooleanList collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public MutableByteList collectByte(ByteFunction<? super T> var1);

    @Override
    public MutableCharList collectChar(CharFunction<? super T> var1);

    @Override
    public MutableDoubleList collectDouble(DoubleFunction<? super T> var1);

    @Override
    public MutableFloatList collectFloat(FloatFunction<? super T> var1);

    @Override
    public MutableIntList collectInt(IntFunction<? super T> var1);

    @Override
    public MutableLongList collectLong(LongFunction<? super T> var1);

    @Override
    public MutableShortList collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> MutableList<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> MutableList<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public MutableSortedSet<T> distinct();

    @Override
    public MutableSortedBag<T> takeWhile(Predicate<? super T> var1);

    @Override
    public MutableSortedBag<T> dropWhile(Predicate<? super T> var1);

    @Override
    public <V> MutableSortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> MutableSortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <V> MutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.asLazy().collect((Function)function).toBag();
    }

    @Override
    default public <V, P> MutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.asLazy().collectWith((Function2)function, (Object)parameter).toBag();
    }

    @Override
    default public <V> MutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.asLazy().flatCollect((Function)function).toBag();
    }

    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public MutableSortedSet<Pair<T, Integer>> zipWithIndex();

    @Override
    public MutableSortedBag<T> toReversed();

    @Override
    public MutableSortedBag<T> take(int var1);

    @Override
    public MutableSortedBag<T> drop(int var1);

    @Override
    default public ImmutableSortedBag<T> toImmutableSortedBag() {
        return this.toImmutable();
    }
}

