/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.ApprovalSwitchHelper;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.CallStatusStandardizer;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.ClassicTransfersTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.SpecialRewardReceivers;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.SystemAccountCreditScreen;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.TransferEventLoggingUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class ClassicTransfersCall
extends AbstractCall {
    private final byte[] selector;
    private final AccountID senderId;
    private final ResponseCodeEnum preemptingFailureStatus;
    @Nullable
    private final TransactionBody syntheticTransfer;
    private final Configuration configuration;
    @Nullable
    private final ApprovalSwitchHelper approvalSwitchHelper;
    private final CallStatusStandardizer callStatusStandardizer;
    private final SystemAccountCreditScreen systemAccountCreditScreen;
    private final VerificationStrategy verificationStrategy;
    private final SpecialRewardReceivers specialRewardReceivers;

    public ClassicTransfersCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull byte[] selector, @NonNull AccountID senderId, @Nullable ResponseCodeEnum preemptingFailureStatus, @Nullable TransactionBody syntheticTransfer, @NonNull Configuration configuration, @Nullable ApprovalSwitchHelper approvalSwitchHelper, @NonNull CallStatusStandardizer callStatusStandardizer, @NonNull VerificationStrategy verificationStrategy, @NonNull SystemAccountCreditScreen systemAccountCreditScreen, @NonNull SpecialRewardReceivers specialRewardReceivers) {
        super(gasCalculator, enhancement, false);
        this.selector = Objects.requireNonNull(selector);
        this.senderId = Objects.requireNonNull(senderId);
        this.preemptingFailureStatus = preemptingFailureStatus;
        this.syntheticTransfer = syntheticTransfer;
        this.configuration = Objects.requireNonNull(configuration);
        this.approvalSwitchHelper = approvalSwitchHelper;
        this.callStatusStandardizer = Objects.requireNonNull(callStatusStandardizer);
        this.systemAccountCreditScreen = systemAccountCreditScreen;
        this.verificationStrategy = Objects.requireNonNull(verificationStrategy);
        this.specialRewardReceivers = Objects.requireNonNull(specialRewardReceivers);
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        if (this.syntheticTransfer == null) {
            return Call.PricedResult.gasOnly(FullResult.haltResult(((ContractsConfig)this.configuration.getConfigData(ContractsConfig.class)).precompileHtsDefaultGasCost()), ResponseCodeEnum.INVALID_TRANSACTION_BODY, false);
        }
        long gasRequirement = ClassicTransfersCall.transferGasRequirement(this.syntheticTransfer, this.gasCalculator, this.enhancement, this.senderId);
        if (this.preemptingFailureStatus != null) {
            return this.reversionWith(this.preemptingFailureStatus, gasRequirement);
        }
        if (this.systemAccountCreditScreen.creditsToSystemAccount(this.syntheticTransfer.cryptoTransferOrThrow())) {
            return this.reversionWith(gasRequirement, this.systemContractOperations().externalizePreemptedDispatch(this.syntheticTransfer, ResponseCodeEnum.INVALID_RECEIVING_NODE_ACCOUNT, HederaFunctionality.CRYPTO_TRANSFER));
        }
        if (this.executionIsNotSupported()) {
            return this.haltWith(gasRequirement, this.systemContractOperations().externalizePreemptedDispatch(this.syntheticTransfer, ResponseCodeEnum.NOT_SUPPORTED, HederaFunctionality.CRYPTO_TRANSFER));
        }
        TransactionBody transferToDispatch = this.shouldRetryWithApprovals() ? this.syntheticTransfer.copyBuilder().cryptoTransfer(Objects.requireNonNull(this.approvalSwitchHelper).switchToApprovalsAsNeededIn(this.syntheticTransfer.cryptoTransferOrThrow(), this.systemContractOperations().signatureTestWith(this.verificationStrategy), this.nativeOperations(), this.senderId)).build() : this.syntheticTransfer;
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(transferToDispatch, this.verificationStrategy, this.senderId, ContractCallStreamBuilder.class);
        CryptoTransferTransactionBody op = transferToDispatch.cryptoTransferOrThrow();
        if (recordBuilder.status() == ResponseCodeEnum.SUCCESS) {
            this.maybeEmitErcLogsFor(op, frame);
            this.specialRewardReceivers.addInFrame(frame, op, recordBuilder.getAssessedCustomFees());
        } else {
            recordBuilder.status(this.callStatusStandardizer.codeForFailure(recordBuilder.status(), frame, op));
        }
        if (recordBuilder.getNumAutoAssociations() > 0 && ((EntitiesConfig)FrameUtils.configOf(frame).getConfigData(EntitiesConfig.class)).unlimitedAutoAssociationsEnabled()) {
            gasRequirement += (long)recordBuilder.getNumAutoAssociations() * this.gasCalculator.canonicalGasRequirement(DispatchType.ASSOCIATE);
        }
        return this.completionWith(gasRequirement, recordBuilder, ReturnTypes.encodedRc(recordBuilder.status()));
    }

    public static long transferGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        CryptoTransferTransactionBody op = body.cryptoTransferOrThrow();
        boolean hasCustomFees = enhancement.nativeOperations().checkForCustomFees(op);
        long baseUnitAdjustTinycentPrice = systemContractGasCalculator.canonicalPriceInTinycents(hasCustomFees ? DispatchType.TRANSFER_FUNGIBLE_CUSTOM_FEES : DispatchType.TRANSFER_FUNGIBLE) / 2L;
        long baseNftTransferTinycentsPrice = systemContractGasCalculator.canonicalPriceInTinycents(hasCustomFees ? DispatchType.TRANSFER_NFT_CUSTOM_FEES : DispatchType.TRANSFER_NFT);
        long baseAdjustTinycentsPrice = systemContractGasCalculator.canonicalPriceInTinycents(DispatchType.TRANSFER_HBAR) / 2L;
        long baseLazyCreationPrice = systemContractGasCalculator.canonicalPriceInTinycents(DispatchType.CRYPTO_CREATE) + systemContractGasCalculator.canonicalPriceInTinycents(DispatchType.CRYPTO_UPDATE);
        ReadableAccountStore extantAccounts = enhancement.nativeOperations().readableAccountStore();
        long minimumTinycentPrice = ClassicTransfersCall.minimumTinycentPriceGiven(op, baseUnitAdjustTinycentPrice, baseAdjustTinycentsPrice, baseNftTransferTinycentsPrice, baseLazyCreationPrice, extantAccounts);
        return systemContractGasCalculator.gasRequirementWithTinycents(body, payerId, minimumTinycentPrice);
    }

    @VisibleForTesting
    public static long minimumTinycentPriceGiven(@NonNull CryptoTransferTransactionBody op, long baseUnitAdjustTinyCentPrice, long baseAdjustTinyCentsPrice, long baseNftTransferTinyCentsPrice, long baseLazyCreationPrice, @NonNull ReadableAccountStore extantAccounts) {
        long minimumTinycentPrice = 0L;
        int numTinyCentsAdjusts = op.transfersOrElse(TransferList.DEFAULT).accountAmounts().size();
        minimumTinycentPrice += (long)numTinyCentsAdjusts * baseAdjustTinyCentsPrice;
        HashSet<Bytes> aliasesToLazyCreate = new HashSet<Bytes>();
        for (TokenTransferList tokenTransfers : op.tokenTransfers()) {
            Object unitAdjust2;
            List unitAdjusts = tokenTransfers.transfers();
            minimumTinycentPrice += (long)unitAdjusts.size() * baseUnitAdjustTinyCentPrice;
            for (Object unitAdjust2 : unitAdjusts) {
                if (unitAdjust2.amount() <= 0L || !unitAdjust2.accountIDOrElse(AccountID.DEFAULT).hasAlias()) continue;
                AccountID accountId = unitAdjust2.accountIDOrThrow();
                Bytes alias = unitAdjust2.accountIDOrThrow().aliasOrThrow();
                AccountID extantAccount = extantAccounts.getAccountIDByAlias(accountId.shardNum(), accountId.realmNum(), alias);
                if (extantAccount != null) continue;
                aliasesToLazyCreate.add(alias);
            }
            List nftTransfers = tokenTransfers.nftTransfers();
            minimumTinycentPrice += (long)nftTransfers.size() * baseNftTransferTinyCentsPrice;
            unitAdjust2 = nftTransfers.iterator();
            while (unitAdjust2.hasNext()) {
                NftTransfer nftTransfer = (NftTransfer)unitAdjust2.next();
                if (!nftTransfer.receiverAccountIDOrElse(AccountID.DEFAULT).hasAlias()) continue;
                AccountID receiverAccountId = nftTransfer.receiverAccountIDOrThrow();
                Bytes alias = receiverAccountId.aliasOrThrow();
                AccountID extantAccount = extantAccounts.getAccountIDByAlias(receiverAccountId.shardNum(), receiverAccountId.realmNum(), alias);
                if (extantAccount != null) continue;
                aliasesToLazyCreate.add(alias);
            }
        }
        for (AccountAmount adjust : op.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            if (adjust.amount() <= 0L || !adjust.accountIDOrElse(AccountID.DEFAULT).hasAlias()) continue;
            AccountID accountId = adjust.accountIDOrThrow();
            Bytes alias = accountId.aliasOrThrow();
            AccountID extantAccount = extantAccounts.getAccountIDByAlias(accountId.shardNum(), accountId.realmNum(), alias);
            if (extantAccount != null) continue;
            aliasesToLazyCreate.add(alias);
        }
        return minimumTinycentPrice += (long)aliasesToLazyCreate.size() * baseLazyCreationPrice;
    }

    private boolean shouldRetryWithApprovals() {
        return this.approvalSwitchHelper != null;
    }

    private boolean executionIsNotSupported() {
        return Arrays.equals(this.selector, ClassicTransfersTranslator.CRYPTO_TRANSFER_V2.selector()) && !((ContractsConfig)this.configuration.getConfigData(ContractsConfig.class)).precompileAtomicCryptoTransferEnabled();
    }

    private void maybeEmitErcLogsFor(@NonNull CryptoTransferTransactionBody op, @NonNull MessageFrame frame) {
        if (Arrays.equals(ClassicTransfersTranslator.TRANSFER_FROM.selector(), this.selector)) {
            TokenTransferList fungibleTransfers = (TokenTransferList)op.tokenTransfers().getFirst();
            TransferEventLoggingUtils.logSuccessfulFungibleTransfer(fungibleTransfers.tokenOrThrow(), fungibleTransfers.transfers(), this.readableAccountStore(), frame);
        } else if (Arrays.equals(ClassicTransfersTranslator.TRANSFER_NFT_FROM.selector(), this.selector)) {
            TokenTransferList nftTransfers = (TokenTransferList)op.tokenTransfers().getFirst();
            TransferEventLoggingUtils.logSuccessfulNftTransfer(nftTransfers.tokenOrThrow(), (NftTransfer)nftTransfers.nftTransfers().getFirst(), this.readableAccountStore(), frame);
        }
    }
}

