/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.ClassicTransfersTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClassicTransfersDecoder {
    @Inject
    public ClassicTransfersDecoder() {
    }

    public TransactionBody decodeCryptoTransfer(@NonNull byte[] encoded, @NonNull HtsCallAttempt attempt) {
        Tuple call = ClassicTransfersTranslator.CRYPTO_TRANSFER.decodeCall(encoded);
        return this.bodyOf(this.tokenTransfers(this.convertTokenTransfers((Tuple[])call.get(0), this::convertingAdjustments, this::convertingOwnershipChanges, attempt)));
    }

    public TransactionBody decodeCryptoTransferV2(@NonNull byte[] encoded, @NonNull HtsCallAttempt attempt) {
        Tuple call = ClassicTransfersTranslator.CRYPTO_TRANSFER_V2.decodeCall(encoded);
        TransferList transferList = this.consolidatedTransferList(this.convertingMaybeApprovedAdjustments((Tuple[])((Tuple)call.get(0)).get(0), attempt));
        CryptoTransferTransactionBody.Builder cryptoTransfersBody = this.tokenTransfers(this.convertTokenTransfers((Tuple[])call.get(1), this::convertingMaybeApprovedAdjustments, this::convertingMaybeApprovedOwnershipChanges, attempt));
        if (!transferList.accountAmounts().isEmpty()) {
            return this.bodyOf(cryptoTransfersBody.transfers(transferList));
        }
        return this.bodyOf(cryptoTransfersBody);
    }

    public TransactionBody decodeTransferTokens(@NonNull byte[] encoded, @NonNull HtsCallAttempt attempt) {
        Tuple call = ClassicTransfersTranslator.TRANSFER_TOKENS.decodeCall(encoded);
        return this.bodyOf(this.tokenTransfers(this.convertingAdjustments((Address)call.get(0), (Address[])call.get(1), (long[])call.get(2), attempt)));
    }

    @Nullable
    public TransactionBody decodeTransferToken(@NonNull byte[] encoded, @NonNull HtsCallAttempt attempt) {
        Tuple call = ClassicTransfersTranslator.TRANSFER_TOKEN.decodeCall(encoded);
        long amount = (Long)call.get(3);
        if (amount < 0L) {
            return null;
        }
        return this.bodyOf(this.tokenTransfers(this.sendingUnitsFromTo(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0)), attempt.addressIdConverter().convert((Address)call.get(1)), attempt.addressIdConverter().convertCredit((Address)call.get(2)), amount, IsApproval.FALSE, TransferPrecedence.DEBIT)));
    }

    public TransactionBody decodeTransferNfts(@NonNull byte[] encoded, @NonNull HtsCallAttempt attempt) {
        Tuple call = ClassicTransfersTranslator.TRANSFER_NFTS.decodeCall(encoded);
        Address[] from = (Address[])call.get(1);
        Address[] to = (Address[])call.get(2);
        long[] serialNo = (long[])call.get(3);
        if (from.length != to.length || from.length != serialNo.length) {
            throw new IllegalArgumentException("Mismatched argument arrays (# from=" + from.length + ", # to=" + to.length + ", # serialNo=" + serialNo.length + ")");
        }
        NftTransfer[] ownershipChanges = new NftTransfer[from.length];
        for (int i = 0; i < from.length; ++i) {
            ownershipChanges[i] = this.nftTransfer(attempt.addressIdConverter().convert(from[i]), attempt.addressIdConverter().convertCredit(to[i]), serialNo[i], IsApproval.FALSE);
        }
        return this.bodyOf(this.tokenTransfers(this.changingOwners(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0)), ownershipChanges)));
    }

    public TransactionBody decodeTransferNft(@NonNull byte[] encoded, @NonNull HtsCallAttempt attempt) {
        Tuple call = ClassicTransfersTranslator.TRANSFER_NFT.decodeCall(encoded);
        return this.bodyOf(this.tokenTransfers(this.changingOwner(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0)), attempt.addressIdConverter().convert((Address)call.get(1)), attempt.addressIdConverter().convertCredit((Address)call.get(2)), (Long)call.get(3), IsApproval.FALSE)));
    }

    public TransactionBody decodeHrcTransferFrom(@NonNull byte[] encoded, @NonNull HtsCallAttempt attempt) {
        Tuple call = ClassicTransfersTranslator.TRANSFER_FROM.decodeCall(encoded);
        return this.bodyOf(this.tokenTransfers(this.sendingUnitsFromTo(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0)), attempt.addressIdConverter().convert((Address)call.get(1)), attempt.addressIdConverter().convertCredit((Address)call.get(2)), this.exactLongValueOrThrow((BigInteger)call.get(3)), IsApproval.TRUE, TransferPrecedence.CREDIT)));
    }

    public TransactionBody decodeHrcTransferNftFrom(@NonNull byte[] encoded, @NonNull HtsCallAttempt attempt) {
        Tuple call = ClassicTransfersTranslator.TRANSFER_NFT_FROM.decodeCall(encoded);
        return this.bodyOf(this.tokenTransfers(this.changingOwner(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0)), attempt.addressIdConverter().convert((Address)call.get(1)), attempt.addressIdConverter().convertCredit((Address)call.get(2)), this.exactLongValueOrThrow((BigInteger)call.get(3)), IsApproval.TRUE)));
    }

    public ResponseCodeEnum checkForFailureStatus(@NonNull HtsCallAttempt attempt) {
        Tuple call;
        if (Arrays.equals(attempt.selector(), ClassicTransfersTranslator.TRANSFER_TOKEN.selector()) && (Long)(call = ClassicTransfersTranslator.TRANSFER_TOKEN.decodeCall(attempt.inputBytes())).get(3) < 0L) {
            return ResponseCodeEnum.INVALID_TRANSACTION_BODY;
        }
        return null;
    }

    private TokenTransferList[] convertTokenTransfers(@NonNull Tuple[] transfersByToken, @NonNull FungibleAdjustmentConverter fungibleAdjustmentConverter, @NonNull OwnershipChangeConverter ownershipChangeConverter, @NonNull HtsCallAttempt attempt) {
        TokenTransferList[] allImpliedTransfers = new TokenTransferList[transfersByToken.length];
        for (int i = 0; i < transfersByToken.length; ++i) {
            Tuple transfers = transfersByToken[i];
            Tuple[] unitAdjustments = (Tuple[])transfers.get(1);
            allImpliedTransfers[i] = unitAdjustments.length > 0 ? fungibleAdjustmentConverter.convert((Address)transfers.get(0), unitAdjustments, attempt) : ownershipChangeConverter.convert((Address)transfers.get(0), (Tuple[])transfers.get(2), attempt);
        }
        return allImpliedTransfers;
    }

    private CryptoTransferTransactionBody.Builder tokenTransfers(TokenTransferList ... tokenTransferLists) {
        if (this.repeatsTokenId(tokenTransferLists)) {
            LinkedHashMap<TokenID, TokenTransferList> consolidatedTokenTransfers = new LinkedHashMap<TokenID, TokenTransferList>();
            for (TokenTransferList tokenTransferList : tokenTransferLists) {
                consolidatedTokenTransfers.merge(tokenTransferList.tokenOrThrow(), tokenTransferList, this::mergeTokenTransferLists);
            }
            tokenTransferLists = (TokenTransferList[])consolidatedTokenTransfers.values().toArray(TokenTransferList[]::new);
        }
        return CryptoTransferTransactionBody.newBuilder().tokenTransfers(tokenTransferLists);
    }

    private TransferList consolidatedTransferList(@NonNull TransferList fromTransferList) {
        LinkedHashMap<AccountID, AccountAmount> consolidatedTransfers = new LinkedHashMap<AccountID, AccountAmount>();
        for (AccountAmount accountAmount : fromTransferList.accountAmounts()) {
            consolidatedTransfers.merge(accountAmount.accountIDOrThrow(), accountAmount, this::mergeAdjusts);
        }
        return new TransferList(consolidatedTransfers.values().stream().toList());
    }

    private TokenTransferList mergeTokenTransferLists(@NonNull TokenTransferList from, @NonNull TokenTransferList to) {
        return from.copyBuilder().transfers(this.mergeTransfers(from.transfers(), to.transfers())).nftTransfers(this.mergeNftTransfers(from.nftTransfers(), to.nftTransfers())).build();
    }

    private List<AccountAmount> mergeTransfers(@NonNull List<AccountAmount> from, @NonNull List<AccountAmount> to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        LinkedHashMap<AccountID, AccountAmount> consolidated = new LinkedHashMap<AccountID, AccountAmount>();
        this.consolidateInto(consolidated, from);
        this.consolidateInto(consolidated, to);
        return consolidated.values().stream().toList();
    }

    private void consolidateInto(@NonNull Map<AccountID, AccountAmount> consolidated, @NonNull List<AccountAmount> transfers) {
        for (AccountAmount transfer : transfers) {
            consolidated.merge(transfer.accountID(), transfer, this::mergeAdjusts);
        }
    }

    private AccountAmount mergeAdjusts(@NonNull AccountAmount from, @NonNull AccountAmount to) {
        return from.copyBuilder().amount(Math.addExact(from.amount(), to.amount())).isApproval(from.isApproval() || to.isApproval()).build();
    }

    private List<NftTransfer> mergeNftTransfers(@NonNull List<NftTransfer> from, @NonNull List<NftTransfer> to) {
        HashSet<NftTransfer> present = new HashSet<NftTransfer>();
        ArrayList<NftTransfer> consolidated = new ArrayList<NftTransfer>();
        this.consolidateInto(present, consolidated, from);
        this.consolidateInto(present, consolidated, to);
        return consolidated;
    }

    private void consolidateInto(@NonNull Set<NftTransfer> present, @NonNull List<NftTransfer> consolidated, @NonNull List<NftTransfer> transfers) {
        for (NftTransfer transfer : transfers) {
            if (!present.add(transfer)) continue;
            consolidated.add(transfer);
        }
    }

    private boolean repeatsTokenId(@NonNull TokenTransferList[] tokenTransferList) {
        return tokenTransferList.length > 1 && Arrays.stream(tokenTransferList).map(TokenTransferList::token).collect(Collectors.toSet()).size() < tokenTransferList.length;
    }

    private TokenTransferList adjustingUnits(@NonNull TokenID tokenId, AccountAmount ... unitAdjustments) {
        return TokenTransferList.newBuilder().token(tokenId).transfers(unitAdjustments).build();
    }

    private TokenTransferList sendingUnitsFromTo(@NonNull TokenID tokenId, @NonNull AccountID from, @NonNull AccountID to, long amount, IsApproval isApproval, @NonNull TransferPrecedence precedence) {
        ArrayList<AccountAmount> accountAmounts = new ArrayList<AccountAmount>();
        if (precedence == TransferPrecedence.DEBIT) {
            accountAmounts.add(this.debit(from, amount, isApproval));
            accountAmounts.add(this.credit(to, amount));
        } else {
            accountAmounts.add(this.credit(to, amount));
            accountAmounts.add(this.debit(from, amount, isApproval));
        }
        return TokenTransferList.newBuilder().token(tokenId).transfers(accountAmounts).build();
    }

    private TokenTransferList changingOwner(@NonNull TokenID tokenId, @NonNull AccountID from, @NonNull AccountID to, long serialNo, IsApproval isApproval) {
        return TokenTransferList.newBuilder().token(tokenId).nftTransfers(new NftTransfer[]{this.nftTransfer(from, to, serialNo, isApproval)}).build();
    }

    private TokenTransferList changingOwners(@NonNull TokenID tokenId, NftTransfer ... ownershipChanges) {
        return TokenTransferList.newBuilder().token(tokenId).nftTransfers(ownershipChanges).build();
    }

    private AccountAmount debit(@NonNull AccountID account, long amount, @NonNull IsApproval isApproval) {
        return this.adjust(account, -amount, isApproval);
    }

    private AccountAmount credit(@NonNull AccountID account, long amount) {
        return this.adjust(account, amount, IsApproval.FALSE);
    }

    private AccountAmount adjust(@NonNull AccountID account, long amount, @NonNull IsApproval isApproval) {
        return AccountAmount.newBuilder().accountID(account).amount(amount).isApproval(isApproval == IsApproval.TRUE).build();
    }

    private NftTransfer nftTransfer(@NonNull AccountID from, @NonNull AccountID to, long serialNo, IsApproval isApproval) {
        return NftTransfer.newBuilder().serialNumber(serialNo).senderAccountID(from).receiverAccountID(to).isApproval(isApproval == IsApproval.TRUE).build();
    }

    private TransactionBody bodyOf(@NonNull CryptoTransferTransactionBody.Builder cryptoTransfer) {
        return TransactionBody.newBuilder().cryptoTransfer(cryptoTransfer).build();
    }

    private long exactLongValueOrThrow(@NonNull BigInteger value) {
        return value.longValueExact();
    }

    private TokenTransferList convertingAdjustments(@NonNull Address token, @NonNull Tuple[] adjustments, @NonNull HtsCallAttempt attempt) {
        return this.convertingAdjustmentsAsGiven(attempt, token, adjustments, adjustment -> {
            Address party = (Address)adjustment.get(0);
            long amount = (Long)adjustment.get(1);
            return amount > 0L ? this.credit(attempt.addressIdConverter().convertCredit(party), amount) : this.debit(attempt.addressIdConverter().convert(party), -amount, IsApproval.FALSE);
        });
    }

    private TransferList convertingMaybeApprovedAdjustments(@NonNull Tuple[] adjustments, @NonNull HtsCallAttempt attempt) {
        AccountAmount[] hbarAdjustments = new AccountAmount[adjustments.length];
        for (int i = 0; i < hbarAdjustments.length; ++i) {
            hbarAdjustments[i] = this.asMaybeApprovedAdjustment(adjustments[i], attempt);
        }
        return TransferList.newBuilder().accountAmounts(hbarAdjustments).build();
    }

    private TokenTransferList convertingMaybeApprovedAdjustments(@NonNull Address token, @NonNull Tuple[] adjustments, @NonNull HtsCallAttempt attempt) {
        return this.convertingAdjustmentsAsGiven(attempt, token, adjustments, adjustment -> this.asMaybeApprovedAdjustment((Tuple)adjustment, attempt));
    }

    private TokenTransferList convertingAdjustmentsAsGiven(@NonNull HtsCallAttempt attempt, @NonNull Address token, @NonNull Tuple[] adjustments, @NonNull Function<Tuple, AccountAmount> adjustmentFn) {
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token);
        AccountAmount[] unitAdjustments = new AccountAmount[adjustments.length];
        for (int i = 0; i < unitAdjustments.length; ++i) {
            unitAdjustments[i] = adjustmentFn.apply(adjustments[i]);
        }
        return this.adjustingUnits(tokenId, unitAdjustments);
    }

    private TokenTransferList convertingOwnershipChanges(@NonNull Address token, @NonNull Tuple[] ownershipChanges, @NonNull HtsCallAttempt attempt) {
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token);
        NftTransfer[] nftTransfers = new NftTransfer[ownershipChanges.length];
        for (int i = 0; i < ownershipChanges.length; ++i) {
            nftTransfers[i] = this.nftTransfer(attempt.addressIdConverter().convert((Address)ownershipChanges[i].get(0)), attempt.addressIdConverter().convertCredit((Address)ownershipChanges[i].get(1)), (Long)ownershipChanges[i].get(2), IsApproval.FALSE);
        }
        return this.changingOwners(tokenId, nftTransfers);
    }

    private TokenTransferList convertingMaybeApprovedOwnershipChanges(@NonNull Address token, @NonNull Tuple[] ownershipChanges, @NonNull HtsCallAttempt attempt) {
        return this.convertingOwnershipChangesAsGiven(attempt, token, ownershipChanges, ownershipChange -> this.nftTransfer(attempt.addressIdConverter().convert((Address)ownershipChange.get(0)), attempt.addressIdConverter().convertCredit((Address)ownershipChange.get(1)), (Long)ownershipChange.get(2), (Boolean)ownershipChange.get(3) != false ? IsApproval.TRUE : IsApproval.FALSE));
    }

    private TokenTransferList convertingOwnershipChangesAsGiven(@NonNull HtsCallAttempt attempt, @NonNull Address token, @NonNull Tuple[] ownershipChanges, @NonNull Function<Tuple, NftTransfer> ownershipChangeFn) {
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token);
        NftTransfer[] nftTransfers = new NftTransfer[ownershipChanges.length];
        for (int i = 0; i < ownershipChanges.length; ++i) {
            nftTransfers[i] = ownershipChangeFn.apply(ownershipChanges[i]);
        }
        return this.changingOwners(tokenId, nftTransfers);
    }

    private TokenTransferList convertingAdjustments(@NonNull Address token, @NonNull Address[] party, @NonNull long[] amount, @NonNull HtsCallAttempt attempt) {
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token);
        if (party.length != amount.length) {
            throw new IllegalArgumentException("Mismatched argument arrays (# party=" + party.length + ", # amount=" + amount.length + ")");
        }
        AccountAmount[] unitAdjustments = new AccountAmount[party.length];
        for (int i = 0; i < party.length; ++i) {
            unitAdjustments[i] = amount[i] > 0L ? this.credit(attempt.addressIdConverter().convertCredit(party[i]), amount[i]) : this.debit(attempt.addressIdConverter().convert(party[i]), -amount[i], IsApproval.FALSE);
        }
        return this.adjustingUnits(tokenId, unitAdjustments);
    }

    private AccountAmount asMaybeApprovedAdjustment(@NonNull Tuple adjustment, @NonNull HtsCallAttempt attempt) {
        Address party = (Address)adjustment.get(0);
        long amount = (Long)adjustment.get(1);
        return this.adjust(amount > 0L ? attempt.addressIdConverter().convertCredit(party) : attempt.addressIdConverter().convert(party), amount, (Boolean)adjustment.get(2) != false ? IsApproval.TRUE : IsApproval.FALSE);
    }

    @FunctionalInterface
    static interface FungibleAdjustmentConverter {
        public TokenTransferList convert(@NonNull Address var1, @NonNull Tuple[] var2, @NonNull HtsCallAttempt var3);
    }

    @FunctionalInterface
    static interface OwnershipChangeConverter {
        public TokenTransferList convert(@NonNull Address var1, @NonNull Tuple[] var2, @NonNull HtsCallAttempt var3);
    }

    static enum IsApproval {
        TRUE,
        FALSE;

    }

    private static enum TransferPrecedence {
        DEBIT,
        CREDIT;

    }
}

