/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.swirlds.platform.consensus.EventVisitedMark;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class AncestorIterator
implements Iterator<EventImpl> {
    private static final int INITIAL_STACK_SIZE = 300;
    private final EventVisitedMark mark;
    private final Deque<EventImpl> stackRef = new ArrayDeque<EventImpl>(300);
    private final Deque<IteratorState> stackState = new ArrayDeque<IteratorState>(300);
    private final Deque<Boolean> stackSelfAncestor = new ArrayDeque<Boolean>(300);
    private final Deque<Instant> stackTime = new ArrayDeque<Instant>(300);
    private EventImpl curr;
    private Predicate<EventImpl> valid;
    private Instant timeReachedRoot;
    private boolean hasNext = false;
    private IteratorState state;
    private boolean selfAncestor;
    private final Deque<Integer> stackNextOtherParentIndex = new ArrayDeque<Integer>(300);
    private int nextOtherParentIndex = 0;

    public AncestorIterator(@NonNull EventVisitedMark mark) {
        this.mark = mark;
    }

    public void initializeSearch(@NonNull EventImpl root, @NonNull Predicate<EventImpl> predicate) {
        this.clear();
        this.mark.nextMark();
        this.curr = root;
        this.valid = predicate;
        this.timeReachedRoot = root.getTimeCreated();
        this.hasNext = true;
        this.state = IteratorState.TRAVERSING_SELF_PARENT;
        this.selfAncestor = true;
        this.nextOtherParentIndex = 0;
    }

    private void clear() {
        this.stackRef.clear();
        this.stackState.clear();
        this.stackSelfAncestor.clear();
        this.stackTime.clear();
        this.curr = null;
        this.valid = null;
        this.timeReachedRoot = null;
        this.hasNext = false;
        this.state = null;
        this.selfAncestor = false;
    }

    @NonNull
    public Instant getTime() {
        return this.timeReachedRoot;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    @NonNull
    public EventImpl next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("no more events left to iterate over");
        }
        block5: while (true) {
            this.mark.markVisited(this.curr);
            switch (this.state.ordinal()) {
                case 0: {
                    EventImpl parent = (EventImpl)this.curr.getSelfParent();
                    if (this.curr.getOtherParents().isEmpty()) {
                        this.state = IteratorState.BOTTOM;
                    } else {
                        this.state = IteratorState.TRAVERSING_OTHER_PARENT;
                        this.nextOtherParentIndex = 0;
                    }
                    if (!this.mark.isNotVisited(parent) || !this.valid.test(parent)) continue block5;
                    this.stackRef.push(this.curr);
                    this.stackState.push(this.state);
                    this.stackNextOtherParentIndex.push(this.nextOtherParentIndex);
                    this.stackSelfAncestor.push(this.selfAncestor);
                    this.stackTime.push(this.timeReachedRoot);
                    this.curr = parent;
                    this.state = IteratorState.TRAVERSING_SELF_PARENT;
                    if (!this.selfAncestor) continue block5;
                    this.timeReachedRoot = this.curr.getTimeCreated();
                    continue block5;
                }
                case 1: {
                    EventImpl parent = (EventImpl)this.curr.getOtherParents().get(this.nextOtherParentIndex);
                    if (this.nextOtherParentIndex + 1 >= this.curr.getOtherParents().size()) {
                        this.state = IteratorState.BOTTOM;
                    } else {
                        this.state = IteratorState.TRAVERSING_OTHER_PARENT;
                        ++this.nextOtherParentIndex;
                    }
                    if (!this.mark.isNotVisited(parent) || !this.valid.test(parent)) continue block5;
                    this.stackRef.push(this.curr);
                    this.stackState.push(this.state);
                    this.stackNextOtherParentIndex.push(this.nextOtherParentIndex);
                    this.stackSelfAncestor.push(this.selfAncestor);
                    this.stackTime.push(this.timeReachedRoot);
                    this.curr = parent;
                    this.state = IteratorState.TRAVERSING_SELF_PARENT;
                    this.selfAncestor = false;
                    continue block5;
                }
                case 2: {
                    if (this.stackRef.isEmpty()) {
                        this.hasNext = false;
                        return this.curr;
                    }
                    EventImpl toReturn = this.curr;
                    this.curr = this.stackRef.pop();
                    this.state = this.stackState.pop();
                    this.nextOtherParentIndex = this.stackNextOtherParentIndex.pop();
                    this.selfAncestor = this.stackSelfAncestor.pop();
                    this.timeReachedRoot = this.stackTime.pop();
                    return toReturn;
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown state: " + String.valueOf((Object)this.state));
    }

    private static enum IteratorState {
        TRAVERSING_SELF_PARENT,
        TRAVERSING_OTHER_PARENT,
        BOTTOM;

    }
}

