/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.hasher;

import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import org.hiero.consensus.metrics.RunningAverageMetric;

public class StateHasherMetrics {
    private static final RunningAverageMetric.Config STATE_HASHING_TIME_CONFIG = new RunningAverageMetric.Config("platform", "sigStateHash").withDescription("average time it takes to hash a SignedState (in milliseconds)").withUnit("ms");
    private final RunningAverageMetric stateHashingTime;

    public StateHasherMetrics(@NonNull Metrics metrics) {
        this.stateHashingTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)STATE_HASHING_TIME_CONFIG);
    }

    public void reportHashingTime(@NonNull Duration hashingTime) {
        this.stateHashingTime.update((double)hashingTime.toMillis());
    }
}

