/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.internal;

import com.hedera.hapi.block.internal.codec.BufferedBlockJsonCodec;
import com.hedera.hapi.block.internal.codec.BufferedBlockProtoCodec;
import com.hedera.hapi.block.internal.schema.BufferedBlockSchema;
import com.hedera.hapi.block.stream.Block;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class BufferedBlock {
    public static final Codec<BufferedBlock> PROTOBUF = new BufferedBlockProtoCodec();
    public static final JsonCodec<BufferedBlock> JSON = new BufferedBlockJsonCodec();
    public static final BufferedBlock DEFAULT = BufferedBlock.newBuilder().build();
    private final long blockNumber;
    @Nullable
    private final Timestamp closedTimestamp;
    private final boolean isProofSent;
    private final boolean isAcknowledged;
    @Nullable
    private final Block block;
    @Nullable
    private final Timestamp openedTimestamp;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BufferedBlock(long blockNumber, Timestamp closedTimestamp, boolean isProofSent, boolean isAcknowledged, Block block, Timestamp openedTimestamp) {
        this.$unknownFields = null;
        this.blockNumber = blockNumber;
        this.closedTimestamp = closedTimestamp;
        this.isProofSent = isProofSent;
        this.isAcknowledged = isAcknowledged;
        this.block = block;
        this.openedTimestamp = openedTimestamp;
    }

    public BufferedBlock(long blockNumber, Timestamp closedTimestamp, boolean isProofSent, boolean isAcknowledged, Block block, Timestamp openedTimestamp, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.blockNumber = blockNumber;
        this.closedTimestamp = closedTimestamp;
        this.isProofSent = isProofSent;
        this.isAcknowledged = isAcknowledged;
        this.block = block;
        this.openedTimestamp = openedTimestamp;
    }

    public long blockNumber() {
        return this.blockNumber;
    }

    public Timestamp closedTimestamp() {
        return this.closedTimestamp;
    }

    public boolean isProofSent() {
        return this.isProofSent;
    }

    public boolean isAcknowledged() {
        return this.isAcknowledged;
    }

    public Block block() {
        return this.block;
    }

    public Timestamp openedTimestamp() {
        return this.openedTimestamp;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)BufferedBlockSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BufferedBlockSchema.CLOSED_TIMESTAMP, (Object)this.closedTimestamp, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)BufferedBlockSchema.IS_PROOF_SENT, (boolean)this.isProofSent, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)BufferedBlockSchema.IS_ACKNOWLEDGED, (boolean)this.isAcknowledged, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BufferedBlockSchema.BLOCK, (Object)this.block, Block.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BufferedBlockSchema.OPENED_TIMESTAMP, (Object)this.openedTimestamp, Timestamp.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.blockNumber != BufferedBlock.DEFAULT.blockNumber) {
                result = 31 * result + Long.hashCode(this.blockNumber);
            }
            if (this.closedTimestamp != null && !this.closedTimestamp.equals(BufferedBlock.DEFAULT.closedTimestamp)) {
                result = 31 * result + this.closedTimestamp.hashCode();
            }
            if (this.isProofSent != BufferedBlock.DEFAULT.isProofSent) {
                result = 31 * result + Boolean.hashCode(this.isProofSent);
            }
            if (this.isAcknowledged != BufferedBlock.DEFAULT.isAcknowledged) {
                result = 31 * result + Boolean.hashCode(this.isAcknowledged);
            }
            if (this.block != null && !this.block.equals(BufferedBlock.DEFAULT.block)) {
                result = 31 * result + this.block.hashCode();
            }
            if (this.openedTimestamp != null && !this.openedTimestamp.equals(BufferedBlock.DEFAULT.openedTimestamp)) {
                result = 31 * result + this.openedTimestamp.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BufferedBlock thatObj = (BufferedBlock)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.blockNumber != thatObj.blockNumber) {
            return false;
        }
        if (this.closedTimestamp == null && thatObj.closedTimestamp != null) {
            return false;
        }
        if (this.closedTimestamp != null && !this.closedTimestamp.equals(thatObj.closedTimestamp)) {
            return false;
        }
        if (this.isProofSent != thatObj.isProofSent) {
            return false;
        }
        if (this.isAcknowledged != thatObj.isAcknowledged) {
            return false;
        }
        if (this.block == null && thatObj.block != null) {
            return false;
        }
        if (this.block != null && !this.block.equals(thatObj.block)) {
            return false;
        }
        if (this.openedTimestamp == null && thatObj.openedTimestamp != null) {
            return false;
        }
        if (this.openedTimestamp != null && !this.openedTimestamp.equals(thatObj.openedTimestamp)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BufferedBlock[blockNumber=" + this.blockNumber + ", closedTimestamp=" + String.valueOf(this.closedTimestamp) + ", isProofSent=" + this.isProofSent + ", isAcknowledged=" + this.isAcknowledged + ", block=" + String.valueOf(this.block) + ", openedTimestamp=" + String.valueOf(this.openedTimestamp) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasClosedTimestamp() {
        return this.closedTimestamp != null;
    }

    public Timestamp closedTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasClosedTimestamp() ? this.closedTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp closedTimestampOrThrow() {
        return Objects.requireNonNull(this.closedTimestamp, "Field closedTimestamp is null");
    }

    public void ifClosedTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasClosedTimestamp()) {
            ifPresent.accept(this.closedTimestamp);
        }
    }

    public boolean hasBlock() {
        return this.block != null;
    }

    public Block blockOrElse(@NonNull Block defaultValue) {
        return this.hasBlock() ? this.block : defaultValue;
    }

    @NonNull
    public Block blockOrThrow() {
        return Objects.requireNonNull(this.block, "Field block is null");
    }

    public void ifBlock(@NonNull Consumer<Block> ifPresent) {
        if (this.hasBlock()) {
            ifPresent.accept(this.block);
        }
    }

    public boolean hasOpenedTimestamp() {
        return this.openedTimestamp != null;
    }

    public Timestamp openedTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasOpenedTimestamp() ? this.openedTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp openedTimestampOrThrow() {
        return Objects.requireNonNull(this.openedTimestamp, "Field openedTimestamp is null");
    }

    public void ifOpenedTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasOpenedTimestamp()) {
            ifPresent.accept(this.openedTimestamp);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.blockNumber, this.closedTimestamp, this.isProofSent, this.isAcknowledged, this.block, this.openedTimestamp, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long blockNumber = 0L;
        @Nullable
        private Timestamp closedTimestamp = null;
        private boolean isProofSent = false;
        private boolean isAcknowledged = false;
        @Nullable
        private Block block = null;
        @Nullable
        private Timestamp openedTimestamp = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long blockNumber, Timestamp closedTimestamp, boolean isProofSent, boolean isAcknowledged, Block block, Timestamp openedTimestamp) {
            this.$unknownFields = null;
            this.blockNumber = blockNumber;
            this.closedTimestamp = closedTimestamp;
            this.isProofSent = isProofSent;
            this.isAcknowledged = isAcknowledged;
            this.block = block;
            this.openedTimestamp = openedTimestamp;
        }

        public Builder(long blockNumber, Timestamp closedTimestamp, boolean isProofSent, boolean isAcknowledged, Block block, Timestamp openedTimestamp, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.blockNumber = blockNumber;
            this.closedTimestamp = closedTimestamp;
            this.isProofSent = isProofSent;
            this.isAcknowledged = isAcknowledged;
            this.block = block;
            this.openedTimestamp = openedTimestamp;
        }

        public BufferedBlock build() {
            return new BufferedBlock(this.blockNumber, this.closedTimestamp, this.isProofSent, this.isAcknowledged, this.block, this.openedTimestamp);
        }

        public Builder blockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public Builder closedTimestamp(@Nullable Timestamp closedTimestamp) {
            this.closedTimestamp = closedTimestamp;
            return this;
        }

        public Builder closedTimestamp(Timestamp.Builder builder) {
            this.closedTimestamp = builder.build();
            return this;
        }

        public Builder isProofSent(boolean isProofSent) {
            this.isProofSent = isProofSent;
            return this;
        }

        public Builder isAcknowledged(boolean isAcknowledged) {
            this.isAcknowledged = isAcknowledged;
            return this;
        }

        public Builder block(@Nullable Block block) {
            this.block = block;
            return this;
        }

        public Builder block(Block.Builder builder) {
            this.block = builder.build();
            return this;
        }

        public Builder openedTimestamp(@Nullable Timestamp openedTimestamp) {
            this.openedTimestamp = openedTimestamp;
            return this;
        }

        public Builder openedTimestamp(Timestamp.Builder builder) {
            this.openedTimestamp = builder.build();
            return this;
        }

        public long blockNumber() {
            return this.blockNumber;
        }

        public Timestamp closedTimestamp() {
            return this.closedTimestamp;
        }

        public boolean isProofSent() {
            return this.isProofSent;
        }

        public boolean isAcknowledged() {
            return this.isAcknowledged;
        }

        public Block block() {
            return this.block;
        }

        public Timestamp openedTimestamp() {
            return this.openedTimestamp;
        }
    }
}

