/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.intake.impl;

import com.google.auto.service.AutoService;
import com.swirlds.base.time.Time;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.metrics.event.EventPipelineTracker;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.transformers.WireTransformer;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.hiero.consensus.crypto.DefaultEventHasher;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.event.intake.EventIntakeModule;
import org.hiero.consensus.event.intake.config.EventIntakeWiringConfig;
import org.hiero.consensus.event.intake.impl.deduplication.EventDeduplicator;
import org.hiero.consensus.event.intake.impl.deduplication.StandardEventDeduplicator;
import org.hiero.consensus.event.intake.impl.validation.DefaultInternalEventValidator;
import org.hiero.consensus.event.intake.impl.validation.InternalEventValidator;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.transaction.TransactionLimits;

@AutoService(value={EventIntakeModule.class})
public class DefaultEventIntakeModule
implements EventIntakeModule {
    @Nullable
    private WireTransformer<EventWindow, EventWindow> eventWindowDispatcher;
    @Nullable
    private ComponentWiring<EventHasher, PlatformEvent> eventHasherWiring;
    @Nullable
    private ComponentWiring<InternalEventValidator, PlatformEvent> eventValidatorWiring;
    @Nullable
    private ComponentWiring<EventDeduplicator, PlatformEvent> eventDeduplicatorWiring;

    public void initialize(@NonNull WiringModel model, @NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull RosterHistory rosterHistory, @NonNull NodeId selfId, @NonNull IntakeEventCounter intakeEventCounter, @NonNull TransactionLimits transactionLimits, @NonNull RecycleBin recycleBin, long startingRound, @Nullable EventPipelineTracker pipelineTracker) {
        if (this.eventHasherWiring != null) {
            throw new IllegalStateException("Already initialized");
        }
        EventIntakeWiringConfig wiringConfig = (EventIntakeWiringConfig)configuration.getConfigData(EventIntakeWiringConfig.class);
        this.eventWindowDispatcher = new WireTransformer(model, "EventWindowDispatcher", "event window", UnaryOperator.identity());
        this.eventHasherWiring = new ComponentWiring(model, EventHasher.class, wiringConfig.eventHasher());
        this.eventValidatorWiring = new ComponentWiring(model, InternalEventValidator.class, wiringConfig.internalEventValidator());
        this.eventDeduplicatorWiring = new ComponentWiring(model, EventDeduplicator.class, wiringConfig.eventDeduplicator());
        this.eventHasherWiring.getOutputWire().solderTo(this.eventValidatorWiring.getInputWire(InternalEventValidator::validateEvent));
        this.eventValidatorWiring.getOutputWire().solderTo(this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::handleEvent));
        this.eventWindowDispatcher.getOutputWire().solderTo(this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::setEventWindow), SolderType.INJECT);
        if (pipelineTracker != null) {
            pipelineTracker.registerMetric("hashing");
            this.eventHasherWiring.getOutputWire().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("hashing", platformEvent));
            pipelineTracker.registerMetric("validation");
            this.eventValidatorWiring.getOutputWire().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("validation", platformEvent));
            pipelineTracker.registerMetric("deduplication");
            this.eventDeduplicatorWiring.getOutputWire().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("deduplication", platformEvent));
        }
        this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::clear);
        DefaultEventHasher eventHasher = new DefaultEventHasher();
        this.eventHasherWiring.bind((Object)eventHasher);
        DefaultInternalEventValidator internalEventValidator = new DefaultInternalEventValidator(metrics, time, intakeEventCounter, transactionLimits);
        this.eventValidatorWiring.bind((Object)internalEventValidator);
        StandardEventDeduplicator eventDeduplicator = new StandardEventDeduplicator(metrics, intakeEventCounter);
        this.eventDeduplicatorWiring.bind((Object)eventDeduplicator);
    }

    @NonNull
    public OutputWire<PlatformEvent> validatedEventsOutputWire() {
        return Objects.requireNonNull(this.eventDeduplicatorWiring, "Not initialized").getOutputWire();
    }

    @NonNull
    public InputWire<PlatformEvent> unhashedEventsInputWire() {
        return Objects.requireNonNull(this.eventHasherWiring, "Not initialized").getInputWire(EventHasher::hashEvent);
    }

    @NonNull
    public InputWire<PlatformEvent> nonValidatedEventsInputWire() {
        return Objects.requireNonNull(this.eventValidatorWiring, "Not initialized").getInputWire(InternalEventValidator::validateEvent);
    }

    @NonNull
    public InputWire<EventWindow> eventWindowInputWire() {
        return Objects.requireNonNull(this.eventWindowDispatcher, "Not initialized").getInputWire();
    }

    @NonNull
    public InputWire<RosterHistory> rosterHistoryInputWire() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void destroy() {
        throw new UnsupportedOperationException("Shutdown mechanism not implemented yet");
    }

    public void flush() {
        Objects.requireNonNull(this.eventHasherWiring, "Not initialized").flush();
        Objects.requireNonNull(this.eventValidatorWiring, "Not initialized").flush();
        Objects.requireNonNull(this.eventDeduplicatorWiring, "Not initialized").flush();
    }

    @NonNull
    public InputWire<Object> clearComponentsInputWire() {
        return Objects.requireNonNull(this.eventDeduplicatorWiring, "Not initialized").getInputWire(EventDeduplicator::clear);
    }

    @NonNull
    public InputWire<Object> beginStreamingNewEventsInputWire() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @NonNull
    public InputWire<Long> registerDiscontinuityInputWire() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @NonNull
    public InputWire<Long> setMinimumAncientIdentifierToStore() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

