/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features.metadata;

import io.helidon.common.features.metadata.Aot;
import io.helidon.common.features.metadata.Deprecation;
import io.helidon.common.features.metadata.FeatureMetadata;
import io.helidon.common.features.metadata.FeatureStatus;
import io.helidon.common.features.metadata.Flavor;
import io.helidon.metadata.hson.Hson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public class FeatureRegistry {
    public static final String FEATURE_REGISTRY_LOCATION_V1 = "META-INF/helidon/feature-metadata.properties";
    public static final String FEATURE_REGISTRY_LOCATION_V2 = "META-INF/helidon/feature-registry.json";
    private static final int CURRENT_REGISTRY_VERSION = 2;
    private static final int DEFAULT_REGISTRY_VERSION = 2;

    private FeatureRegistry() {
    }

    public static FeatureMetadata metadata(String location, Properties properties) {
        String dep;
        String moduleName = properties.getProperty("m");
        String featureName = properties.getProperty("n");
        if (moduleName == null || featureName == null) {
            throw new IllegalStateException("Invalid feature metadata on " + location + ", missing feature name or module name.");
        }
        FeatureMetadata.Builder builder = (FeatureMetadata.Builder)((FeatureMetadata.Builder)FeatureMetadata.builder().module(moduleName)).name(featureName);
        Optional.ofNullable(properties.getProperty("d")).ifPresent(builder::description);
        Optional.ofNullable(properties.getProperty("s")).ifPresent(builder::since);
        Optional.ofNullable(properties.getProperty("p")).map(it -> it.split(",")).map(List::of).ifPresent(builder::path);
        Optional.ofNullable(properties.getProperty("in")).map(it -> it.split(",")).map(List::of).stream().flatMap(Collection::stream).map(Flavor::valueOf).forEach(builder::addFlavor);
        Optional.ofNullable(properties.getProperty("not")).map(it -> it.split(",")).map(List::of).stream().flatMap(Collection::stream).map(Flavor::valueOf).forEach(builder::addInvalidFlavor);
        String aot = properties.getProperty("aot");
        String aotd = properties.getProperty("aotd");
        if (aot != null || aotd != null) {
            Aot.Builder aotBuilder = Aot.builder();
            if (aot != null) {
                aotBuilder.supported(Boolean.parseBoolean(aot));
            }
            if (aotd != null) {
                aotBuilder.description(aotd);
            }
            builder.aot(aotBuilder.build());
        }
        if ((dep = properties.getProperty("dep")) != null) {
            Deprecation.Builder depBuilder = Deprecation.builder();
            depBuilder.isDeprecated(Boolean.parseBoolean(dep));
            Optional.ofNullable(properties.getProperty("deps")).ifPresent(depBuilder::since);
            builder.deprecation(depBuilder.build());
        }
        return builder.build();
    }

    public static List<FeatureMetadata> metadata(String location, Hson.Array root) {
        ArrayList<FeatureMetadata> result = new ArrayList<FeatureMetadata>();
        for (Hson.Struct featureMetadata : root.getStructs()) {
            String moduleName = (String)featureMetadata.stringValue("module").orElseThrow(() -> new IllegalStateException("Missing required property 'module' for " + location));
            String featureName = (String)featureMetadata.stringValue("name").orElseThrow(() -> new IllegalStateException("Missing required property 'name' for " + location));
            int version = featureMetadata.intValue("version", 2);
            if (version != 2) {
                throw new IllegalStateException("Invalid registry version: " + version + " for module \"" + moduleName + "\" for feature \"" + featureName + "\" loaded from \"" + location + "\", expected version: \"2\"");
            }
            result.add(FeatureRegistry.createV2(moduleName, featureName, featureMetadata));
        }
        return result;
    }

    private static FeatureMetadata createV2(String moduleName, String featureName, Hson.Struct featureMetadata) {
        FeatureMetadata.Builder builder = (FeatureMetadata.Builder)((FeatureMetadata.Builder)FeatureMetadata.builder().module(moduleName)).name(featureName);
        featureMetadata.stringArray("path").ifPresent(builder::path);
        featureMetadata.stringValue("description").ifPresent(builder::description);
        featureMetadata.stringValue("since").ifPresent(builder::since);
        featureMetadata.stringArray("flavor").stream().flatMap(Collection::stream).map(Flavor::valueOf).forEach(builder::addFlavor);
        featureMetadata.stringArray("invalid-flavor").stream().flatMap(Collection::stream).map(Flavor::valueOf).forEach(builder::addInvalidFlavor);
        featureMetadata.stringValue("status").map(FeatureStatus::valueOf).ifPresent(builder::status);
        featureMetadata.structValue("aot").ifPresent(it -> FeatureRegistry.addAot(builder, it));
        featureMetadata.structValue("deprecation").ifPresent(it -> FeatureRegistry.addDeprecation(builder, it));
        return builder.build();
    }

    private static void addDeprecation(FeatureMetadata.Builder builder, Hson.Struct deprecation) {
        Deprecation.Builder deprecationBuilder = Deprecation.builder();
        deprecation.booleanValue("deprecated").ifPresent(deprecationBuilder::isDeprecated);
        deprecation.stringValue("description").ifPresent(deprecationBuilder::description);
        deprecation.stringValue("since").ifPresent(deprecationBuilder::since);
        builder.deprecation(deprecationBuilder.build());
    }

    private static void addAot(FeatureMetadata.Builder builder, Hson.Struct aot) {
        Aot.Builder aotBuilder = (Aot.Builder)Aot.builder().supported(aot.booleanValue("supported", true));
        aot.stringValue("description").ifPresent(aotBuilder::description);
        builder.aot(aotBuilder.build());
    }
}

