/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.crypto;

import com.swirlds.common.utility.CommonUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.config.BasicConfig;
import com.swirlds.platform.config.PathsConfig;
import com.swirlds.platform.crypto.EnhancedKeyStoreLoader;
import com.swirlds.platform.crypto.KeyCertPurpose;
import com.swirlds.platform.crypto.KeyGeneratingException;
import com.swirlds.platform.crypto.KeyLoadingException;
import com.swirlds.platform.crypto.KeysAndCertsGenerator;
import com.swirlds.platform.crypto.PublicStores;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.base.crypto.config.CryptoConfig;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.crypto.CryptoConstants;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterUtils;

public final class CryptoStatic {
    private static final Logger logger = LogManager.getLogger(CryptoStatic.class);
    private static final int SERIAL_NUMBER_BITS = 64;
    private static final int MASTER_KEY_MULTIPLIER = 157;
    private static final int SWIRLD_ID_MULTIPLIER = 163;
    private static final int BITS_IN_BYTE = 8;
    private static final String ADDRESS_BOOK_MUST_NOT_BE_NULL = "addressBook must not be null";
    private static final String LOCAL_NODES_MUST_NOT_BE_NULL = "the local nodes must not be null";

    private CryptoStatic() {
    }

    private static String rdn(String[] commaSeparator, String attributeType, String attributeValue) {
        if (attributeValue == null || attributeValue.equals("")) {
            return "";
        }
        attributeValue = attributeValue.replace("\\", "\\\\");
        attributeValue = attributeValue.replace("\"", "\\\"");
        attributeValue = attributeValue.replace(",", "\\,");
        attributeValue = attributeValue.replace(";", "\\;");
        attributeValue = attributeValue.replace("<", "\\<");
        attributeValue = attributeValue.replace(">", "\\>");
        attributeValue = attributeValue.replaceAll(" $", "\\ ");
        attributeValue = attributeValue.replaceAll("^ ", "\\ ");
        attributeValue = attributeValue.replaceAll("^#", "\\#");
        String s = commaSeparator[0] + attributeType + "=" + attributeValue;
        commaSeparator[0] = ",";
        return s;
    }

    static String distinguishedName(String commonName) {
        String[] commaSeparator = new String[]{""};
        return CryptoStatic.rdn(commaSeparator, "CN", commonName) + CryptoStatic.rdn(commaSeparator, "O", null) + CryptoStatic.rdn(commaSeparator, "STREET", null) + CryptoStatic.rdn(commaSeparator, "L", null) + CryptoStatic.rdn(commaSeparator, "ST", null) + CryptoStatic.rdn(commaSeparator, "C", null) + CryptoStatic.rdn(commaSeparator, "UID", null);
    }

    public static X509Certificate generateCertificate(String distinguishedName, KeyPair pair, String caDistinguishedName, KeyPair caPair, SecureRandom secureRandom, String signatureAlgorithm) throws KeyGeneratingException {
        try {
            JcaX509v3CertificateBuilder v3CertBldr = new JcaX509v3CertificateBuilder(new X500Principal(caDistinguishedName), new BigInteger(64, secureRandom), Date.from(CryptoConstants.DEFAULT_VALID_FROM), Date.from(CryptoConstants.DEFAULT_VALID_TO), new X500Principal(distinguishedName), pair.getPublic());
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signatureAlgorithm).setProvider("BC");
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(v3CertBldr.build(signerBuilder.build(caPair.getPrivate())));
        }
        catch (CertificateException | OperatorCreationException e) {
            throw new KeyGeneratingException("Could not generate certificate!", e);
        }
    }

    static KeyStore createEmptyTrustStore() throws KeyStoreException {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new CryptographyException((Throwable)e);
        }
        return trustStore;
    }

    @NonNull
    public static KeyStore loadKeys(@NonNull Path file, @NonNull char[] password) throws KeyStoreException, KeyLoadingException {
        KeyStore store = CryptoStatic.createEmptyTrustStore();
        try (FileInputStream fis = new FileInputStream(file.toFile());){
            store.load(fis, password);
            if (store.size() == 0) {
                throw new KeyLoadingException("there are no valid keys or certificates in " + String.valueOf(file));
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyLoadingException("there was a problem reading: " + String.valueOf(file), e);
        }
        return store;
    }

    private static String getPrivateKeysFileName(NodeId nodeId) {
        return "private-" + RosterUtils.formatNodeName((NodeId)nodeId) + ".pfx";
    }

    @Deprecated(since="0.47.0", forRemoval=false)
    @NonNull
    static Map<NodeId, KeysAndCerts> loadKeysAndCerts(@NonNull AddressBook addressBook, @NonNull Path keysDirPath, @NonNull char[] password, @NonNull Set<NodeId> localNodes) throws KeyStoreException, KeyLoadingException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyGeneratingException, NoSuchProviderException {
        Objects.requireNonNull(addressBook, ADDRESS_BOOK_MUST_NOT_BE_NULL);
        Objects.requireNonNull(keysDirPath, "keysDirPath must not be null");
        Objects.requireNonNull(password, "password must not be null");
        Objects.requireNonNull(localNodes, LOCAL_NODES_MUST_NOT_BE_NULL);
        int n = addressBook.getSize();
        ArrayList<NodeId> ids = new ArrayList<NodeId>();
        for (int i = 0; i < addressBook.getSize(); ++i) {
            NodeId nodeId = addressBook.getNodeId(i);
            ids.add(nodeId);
        }
        KeyStore allPublic = CryptoStatic.loadKeys(keysDirPath.resolve("public.pfx"), password);
        PublicStores publicStores = PublicStores.fromAllPublic(allPublic, ids);
        HashMap<NodeId, KeysAndCerts> keysAndCerts = new HashMap<NodeId, KeysAndCerts>();
        for (int i = 0; i < n; ++i) {
            NodeId nodeId = addressBook.getNodeId(i);
            Address address = addressBook.getAddress(nodeId);
            if (!localNodes.contains(address.getNodeId())) continue;
            KeyStore privateKS = CryptoStatic.loadKeys(keysDirPath.resolve(CryptoStatic.getPrivateKeysFileName(nodeId)), password);
            keysAndCerts.put(nodeId, KeysAndCertsGenerator.loadExistingAndCreateAgrKeyIfMissing(nodeId, password, privateKS, publicStores));
        }
        CryptoStatic.copyPublicKeys(publicStores, addressBook);
        return keysAndCerts;
    }

    @NonNull
    public static Map<NodeId, KeysAndCerts> generateKeysAndCerts(@NonNull AddressBook addressBook) throws ExecutionException, InterruptedException, KeyStoreException {
        Objects.requireNonNull(addressBook, ADDRESS_BOOK_MUST_NOT_BE_NULL);
        PublicStores publicStores = new PublicStores();
        Map<NodeId, KeysAndCerts> keysAndCerts = CryptoStatic.generateKeysAndCerts(addressBook.getNodeIdSet(), publicStores);
        try {
            CryptoStatic.copyPublicKeys(publicStores, addressBook);
        }
        catch (KeyLoadingException e) {
            throw new CryptographyException((Throwable)e);
        }
        return keysAndCerts;
    }

    @NonNull
    public static Map<NodeId, KeysAndCerts> generateKeysAndCerts(@NonNull Collection<NodeId> nodeIds, @Nullable PublicStores pStores) throws ExecutionException, InterruptedException, KeyStoreException {
        PublicStores publicStores = Optional.ofNullable(pStores).orElse(new PublicStores());
        byte[] masterKey = new byte[32];
        byte[] swirldId = new byte[48];
        HashMap futures = HashMap.newHashMap(nodeIds.size());
        try (ExecutorService threadPool = Executors.newCachedThreadPool(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("browser")).setThreadName("crypto-generate")).setDaemon(false)).buildFactory());){
            for (NodeId nodeId : nodeIds) {
                int j;
                int i = (int)nodeId.id();
                for (j = 0; j < masterKey.length; ++j) {
                    masterKey[j] = (byte)(j * 157);
                }
                for (j = 0; j < swirldId.length; ++j) {
                    swirldId[j] = (byte)(j * 163);
                }
                masterKey[0] = (byte)i;
                masterKey[1] = (byte)(i >> 8);
                byte[] masterKeyClone = (byte[])masterKey.clone();
                byte[] swirldIdClone = (byte[])swirldId.clone();
                int memId = i;
                futures.put(nodeId, threadPool.submit(() -> KeysAndCertsGenerator.generate(nodeId, masterKeyClone, swirldIdClone, CommonUtils.intToBytes((int)memId), publicStores)));
            }
            Map<NodeId, KeysAndCerts> keysAndCerts = CryptoStatic.futuresToMap(futures);
            threadPool.shutdown();
            Map<NodeId, KeysAndCerts> map = keysAndCerts;
            return map;
        }
    }

    static void copyPublicKeys(PublicStores publicStores, AddressBook addressBook) throws KeyLoadingException {
        for (int i = 0; i < addressBook.getSize(); ++i) {
            NodeId nodeId = addressBook.getNodeId(i);
            X509Certificate sigCert = publicStores.getCertificate(KeyCertPurpose.SIGNING, nodeId);
            addressBook.add(addressBook.getAddress(nodeId).copySetSigCert(sigCert));
        }
    }

    @NonNull
    private static <T> Map<NodeId, T> futuresToMap(@NonNull Map<NodeId, Future<T>> futures) throws ExecutionException, InterruptedException {
        HashMap<NodeId, T> map = new HashMap<NodeId, T>();
        for (Map.Entry<NodeId, Future<T>> entry : futures.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get());
        }
        return map;
    }

    public static SecureRandom getNonDetRandom() {
        SecureRandom nonDetRandom;
        try {
            nonDetRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException((Throwable)e, LogMarker.EXCEPTION);
        }
        nonDetRandom.nextBytes(new byte[1]);
        return nonDetRandom;
    }

    public static Map<NodeId, KeysAndCerts> initNodeSecurity(@NonNull AddressBook addressBook, @NonNull Configuration configuration, @NonNull Set<NodeId> localNodes) {
        Map<NodeId, KeysAndCerts> keysAndCerts;
        BasicConfig basicConfig;
        block13: {
            Objects.requireNonNull(addressBook, ADDRESS_BOOK_MUST_NOT_BE_NULL);
            Objects.requireNonNull(configuration, "configuration must not be null");
            Objects.requireNonNull(localNodes, LOCAL_NODES_MUST_NOT_BE_NULL);
            PathsConfig pathsConfig = (PathsConfig)configuration.getConfigData(PathsConfig.class);
            CryptoConfig cryptoConfig = (CryptoConfig)configuration.getConfigData(CryptoConfig.class);
            basicConfig = (BasicConfig)configuration.getConfigData(BasicConfig.class);
            try {
                if (basicConfig.loadKeysFromPfxFiles()) {
                    try (Stream<Path> list = Files.list(pathsConfig.getKeysDirPath());){
                        CommonUtils.tellUserConsole((String)("Reading crypto keys from the files here:   " + Arrays.toString(list.map(p -> p.getFileName().toString()).filter(fileName -> fileName.endsWith("pfx") || fileName.endsWith("pem")).toArray())));
                    }
                    logger.debug(LogMarker.STARTUP.getMarker(), "About to start loading keys");
                    if (cryptoConfig.enableNewKeyStoreModel()) {
                        logger.debug(LogMarker.STARTUP.getMarker(), "Reading keys using the enhanced key loader");
                        keysAndCerts = EnhancedKeyStoreLoader.using(addressBook, configuration, localNodes).migrate().scan().generate().verify().injectInAddressBook().keysAndCerts();
                    } else {
                        logger.debug(LogMarker.STARTUP.getMarker(), "Reading keys using the legacy key loader");
                        keysAndCerts = CryptoStatic.loadKeysAndCerts(addressBook, pathsConfig.getKeysDirPath(), cryptoConfig.keystorePassword().toCharArray(), localNodes);
                    }
                    logger.debug(LogMarker.STARTUP.getMarker(), "Done loading keys");
                    break block13;
                }
                CommonUtils.tellUserConsole((String)("Keys will be generated in: " + String.valueOf(pathsConfig.getKeysDirPath()) + ", which is incompatible with DAB."));
                logger.warn(LogMarker.STARTUP.getMarker(), "There are no keys on disk, Adhoc keys will be generated, but this is incompatible with DAB.");
                logger.debug(LogMarker.STARTUP.getMarker(), "Started generating keys");
                keysAndCerts = CryptoStatic.generateKeysAndCerts(addressBook);
                logger.debug(LogMarker.STARTUP.getMarker(), "Done generating keys");
            }
            catch (KeyGeneratingException | KeyLoadingException | IOException | InterruptedException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | ExecutionException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Exception while loading/generating keys", (Throwable)e);
                if (Utilities.isRootCauseSuppliedType(e, NoSuchAlgorithmException.class) || Utilities.isRootCauseSuppliedType(e, NoSuchProviderException.class)) {
                    CommonUtils.tellUserConsolePopup((String)"ERROR", (String)"ERROR: This Java installation does not have the needed cryptography providers installed");
                }
                SystemExitUtils.exitSystem(SystemExitCode.KEY_LOADING_FAILED);
                throw new CryptographyException((Throwable)e);
            }
        }
        String msg = basicConfig.loadKeysFromPfxFiles() ? "Certificate loaded: {}" : "Certificate generated: {}";
        keysAndCerts.forEach((nodeId, keysAndCertsForNode) -> {
            if (keysAndCertsForNode == null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "No keys and certs for node {}", nodeId);
                return;
            }
            logger.debug(LogMarker.CERTIFICATES.getMarker(), "Node ID: {}", nodeId);
            logger.debug(LogMarker.CERTIFICATES.getMarker(), msg, (Object)keysAndCertsForNode.sigCert());
            logger.debug(LogMarker.CERTIFICATES.getMarker(), msg, (Object)keysAndCertsForNode.agrCert());
        });
        return keysAndCerts;
    }

    @NonNull
    public static KeyStore createPublicKeyStore(@NonNull Collection<PeerInfo> peers) throws KeyStoreException {
        Objects.requireNonNull(peers);
        KeyStore store = CryptoStatic.createEmptyTrustStore();
        for (PeerInfo peer : peers) {
            X509Certificate sigCert = peer.signingCertificate();
            store.setCertificateEntry(KeyCertPurpose.SIGNING.storeName(peer.nodeId()), sigCert);
        }
        return store;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

